/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzT;
import com.aspose.words.net.System.Data.zzX;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXIZ = new DataRowCollection(this);
    private final DataColumnCollection zzXIY = new DataColumnCollection(this);
    private final ConstraintCollection zzXIX = new ConstraintCollection(this);
    private final zzT zzXIW = new zzT(this);
    private ResultSet zzXIV;
    private String zzZ8K;
    private DataSet zz3p;
    private String zzYYl = "";
    private UniqueConstraint zzXIU;
    private boolean zzXJa = true;
    private final List<DataTableEventListener> zzXIT = new ArrayList<DataTableEventListener>();
    private final Set<DataRow> zzXIS = new HashSet<DataRow>();

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZ8K = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, zzY.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXIV = resultSet;
        this.zzZ8K = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXIV != null) {
            if (this.zzXIV.getStatement() != null) {
                this.zzXIV.getStatement().getConnection().close();
            }
            this.zzXIV = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZ8K;
    }

    public void setTableName(String tableName) {
        this.zzZ8K = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXIY.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXIY.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXIV;
    }

    public DataSet getDataSet() {
        return this.zz3p;
    }

    final void zzZ(DataSet dataSet) {
        this.zz3p = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzXIZ;
    }

    public DataColumnCollection getColumns() {
        return this.zzXIY;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXIX;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXIU == null) {
            return new DataColumn[0];
        }
        return this.zzXIU.getColumns();
    }

    final void zzT(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXIU != null) {
                this.zzXIU.zzPD(false);
                this.getConstraints().remove(this.zzXIU);
                this.zzXIU = null;
            }
            return;
        }
        if (this.zzXIU != null && DataColumn.areColumnSetsTheSame(value, this.zzXIU.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXIU != null) {
            this.zzXIU.zzPD(false);
            this.getConstraints().remove(this.zzXIU);
            this.zzXIU = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzXIU = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzYYl;
    }

    public void setNamespace(String namespace) {
        this.zzYYl = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXJa;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXJa = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXIS.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzY.zzZ(this.getResultSet(), this);
            zzY.zzY(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzY(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXIT.contains(listener)) {
            this.zzXIT.add(listener);
        }
    }

    public void removeEventListener(zzX listener) {
        if (this.zzXIT.contains(listener)) {
            this.zzXIT.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXIT.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXIS.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXIT) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXIS.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXIT) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXIS.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXIT) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXIT) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXIT) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzT zzYyJ() {
        return this.zzXIW;
    }

    final Set<DataRow> zzYyI() {
        return this.zzXIS;
    }
}

