/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz1F;
import com.aspose.words.internal.zz1O;
import com.aspose.words.internal.zz20;
import com.aspose.words.internal.zz2G;
import com.aspose.words.internal.zz38;
import com.aspose.words.internal.zz3S;
import com.aspose.words.internal.zz3U;
import com.aspose.words.internal.zz3X;
import com.aspose.words.internal.zz6E;
import com.aspose.words.internal.zzZXH;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.DataTableCollection;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.XmlReadMode;
import com.aspose.words.net.System.Data.zzS;
import com.aspose.words.net.System.Data.zzY;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSet {
    private boolean zzXJa = true;
    private String zzXJ9 = "NewDataSet";
    private Locale zzXJ8;
    private DataTableCollection zzXJ7 = new DataTableCollection(this);
    private DataRelationCollection zzXJ6 = new DataRelationCollection();
    private String zzXJ5;

    public DataSet() {
    }

    public DataSet(Connection connection) throws Exception {
        this(connection, "");
    }

    public DataSet(Connection connection, String schemaName) throws Exception {
        Object object;
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = connection.getCatalog();
        List<String> list = zzY.zzZ(databaseMetaData, schemaName, string);
        for (String object22 : list) {
            object = zzY.zzYP(schemaName, object22);
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + (String)object);
            DataTable dataTable = new DataTable(resultSet, object22);
            dataTable.zzT(zzY.zzZ(databaseMetaData, string, schemaName, object22));
            this.getTables().add(dataTable);
            zzY.zzZ(databaseMetaData, string, schemaName, dataTable);
        }
        List<DataRelation> list2 = zzY.zzZ(databaseMetaData, string, schemaName, this.getTables());
        Iterator<DataRelation> iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.getRelations().add((DataRelation)object);
        }
    }

    public DataSet(String name) {
        this.zzXJ9 = name;
    }

    public String getDataSetName() {
        return this.zzXJ9;
    }

    public void setDataSetName(String newDataSetName) {
        this.zzXJ9 = newDataSetName;
    }

    public String getNamespace() {
        return null;
    }

    public DataTableCollection getTables() {
        return this.zzXJ7;
    }

    public DataRelationCollection getRelations() {
        return this.zzXJ6;
    }

    public void close() throws Exception {
        for (DataTable dataTable : this.zzXJ7) {
            dataTable.close();
        }
    }

    public void clear() {
        for (DataTable dataTable : this.getTables()) {
            dataTable.getRows().clear();
        }
    }

    public void reset() {
        this.clear();
        Iterator<DataTable> iterator = this.zzXJ7.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        Iterator<DataRelation> iterator2 = this.zzXJ6.iterator();
        while (iterator2.hasNext()) {
            iterator2.remove();
        }
    }

    public XmlReadMode readXml(InputStream xmlStream, XmlReadMode mode) throws DataException {
        if (xmlStream == null) {
            return mode;
        }
        boolean bl = false;
        try {
            zzZXH zzZXH2 = DataSet.zzYyL();
            XMLStreamReader xMLStreamReader = zzZXH2.createXMLStreamReader(xmlStream);
            zzS zzS10 = null;
            zz3U zz3U2 = null;
            if (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            switch (mode) {
                                case AUTO: 
                                case DIFF_GRAM: {
                                    zzS10 = new zzS(this);
                                    zzS10.zza(xMLStreamReader);
                                    return XmlReadMode.DIFF_GRAM;
                                }
                                case FRAGMENT: {
                                    DataSet.zze(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    DataSet.zze(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            bl = true;
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zze(xMLStreamReader);
                                    return mode;
                                }
                                case FRAGMENT: {
                                    this.zzd(xMLStreamReader);
                                    break;
                                }
                                case AUTO: {
                                    if (this.getTables().getCount() == 0) {
                                        this.zzd(xMLStreamReader);
                                        return XmlReadMode.READ_SCHEMA;
                                    }
                                    DataSet.zze(xMLStreamReader);
                                    return XmlReadMode.IGNORE_SCHEMA;
                                }
                                default: {
                                    this.zzd(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        zz3U2 = new zz3U();
                        zz3U2.setName(zz3X.decode(xMLStreamReader.getLocalName()));
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            if (!"".equals(xMLStreamReader.getAttributePrefix(i))) continue;
                            zz3U2.getAttributes().put(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                        }
                        break;
                    }
                }
            }
            XmlReadMode xmlReadMode = mode;
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        zzY zzY10;
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            xMLStreamReader.getLocalName();
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zze(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    this.zzd(xMLStreamReader);
                                    xmlReadMode = XmlReadMode.READ_SCHEMA;
                                    bl = true;
                                    break;
                                }
                            }
                            break;
                        }
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            if (mode == XmlReadMode.DIFF_GRAM || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.AUTO) {
                                if (zzS10 == null) {
                                    zzS10 = new zzS(this);
                                }
                                zzS10.zza(xMLStreamReader);
                                xmlReadMode = XmlReadMode.DIFF_GRAM;
                                if (mode != XmlReadMode.DIFF_GRAM) break;
                                return xmlReadMode;
                            }
                            DataSet.zze(xMLStreamReader);
                            break;
                        }
                        if (!(bl || xmlReadMode == XmlReadMode.READ_SCHEMA || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.FRAGMENT || this.getTables().getCount() != 0 && mode != XmlReadMode.INFER_SCHEMA)) {
                            if (mode == XmlReadMode.AUTO) {
                                xmlReadMode = XmlReadMode.INFER_SCHEMA;
                            }
                            zzY10 = new zzY(this, xMLStreamReader, zz3U2, true);
                            zzY10.zzYyK();
                            return xmlReadMode;
                        }
                        mode = bl ? XmlReadMode.READ_SCHEMA : XmlReadMode.IGNORE_SCHEMA;
                        zzY10 = new zzY(this, xMLStreamReader, zz3U2, false);
                        zzY10.zzYyK();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
        catch (SQLException sQLException) {
            throw new DataException(sQLException);
        }
        catch (zz38 zz382) {
            throw new DataException(zz382);
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new DataException(invalidConstraintException);
        }
        return XmlReadMode.AUTO;
    }

    public XmlReadMode readXml(InputStream xmlStream) throws DataException {
        return this.readXml(xmlStream, XmlReadMode.AUTO);
    }

    public XmlReadMode readXml(String xmlPath) throws DataException {
        return this.readXml(xmlPath, XmlReadMode.AUTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlReadMode readXml(String xmlPath, XmlReadMode readMode) throws DataException {
        XmlReadMode xmlReadMode;
        if (xmlPath == null) throw new IllegalArgumentException("xmlPath cannot be empty");
        if (xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzXJ5 = xmlPath;
            inputStream = new FileInputStream(xmlPath);
            xmlReadMode = this.readXml(inputStream, readMode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DataException(fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return xmlReadMode;
        }
        catch (Exception exception) {}
        return xmlReadMode;
    }

    @Deprecated
    public XmlReadMode readXml(zz6E stream) {
        return this.readXml(new zz1F(stream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXmlSchema(InputStream xmlStream) throws DataException {
        if (xmlStream == null) {
            throw new IllegalArgumentException("xmlStream cannot be null");
        }
        XMLStreamReader xMLStreamReader = null;
        try {
            zzZXH zzZXH2 = DataSet.zzYyL();
            xMLStreamReader = zzZXH2.createXMLStreamReader(xmlStream);
            this.zzd(xMLStreamReader);
            if (xMLStreamReader == null) return;
        }
        catch (XMLStreamException xMLStreamException) {
            try {
                throw new DataException(xMLStreamException);
                catch (zz38 zz382) {
                    throw new DataException(zz382);
                }
                catch (InvalidConstraintException invalidConstraintException) {
                    throw new DataException(invalidConstraintException);
                }
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                try {
                    xMLStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException2) {
                    throw new DataException(xMLStreamException2);
                }
            }
        }
        try {
            xMLStreamReader.close();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
    }

    public void readXmlSchema(String xmlPath) throws DataException {
        if (xmlPath == null || xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzXJ5 = xmlPath;
            try {
                inputStream = new FileInputStream(xmlPath);
                this.readXmlSchema(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DataException(fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setLocale(Locale locale) {
        this.zzXJ8 = locale;
    }

    public boolean isLocaleSpecified() {
        return this.zzXJ8 != null;
    }

    public boolean getEnforceConstraints() {
        return this.zzXJa;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXJa = enforceConstraints;
        for (DataTable dataTable : this.getTables()) {
            dataTable.setEnforceConstraints(enforceConstraints);
        }
    }

    private static void zze(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = xMLStreamReader.getLocalName();
        while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 2: {
                    if (!string.equals(xMLStreamReader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void zzd(XMLStreamReader xMLStreamReader) throws zz38, XMLStreamException, DataException, InvalidConstraintException {
        int n = 0;
        boolean bl = false;
        do {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    if (bl) {
                        ++n;
                    }
                    if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data")) {
                        DataSet.zzYyM();
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        this.zzc(xMLStreamReader);
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().startsWith("http://www.w3.org/")) {
                        throw new IllegalStateException("DataSetUnsupportedSchema http://www.w3.org/2001/XMLSchema");
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    bl = zz1O.zzW9(xMLStreamReader.getText().trim());
                    break;
                }
                case 2: {
                    if (--n > 0) break;
                    return;
                }
            }
            if (!xMLStreamReader.hasNext()) continue;
            xMLStreamReader.next();
        } while (xMLStreamReader.hasNext());
    }

    private void zzc(XMLStreamReader xMLStreamReader) throws zz38, XMLStreamException, InvalidConstraintException, DataException {
        zz2G zz2G2 = new zz2G();
        zz3S zz3S2 = zz3S.zzZ(xMLStreamReader);
        zz3S2.zzWp(this.zzXJ5);
        zz2G2.zzN(zz3S2);
        zz2G2.zzsC();
        zz20 zz202 = new zz20();
        zz202.zzZ(zz2G2, this);
    }

    private static void zzYyM() {
        throw new UnsupportedOperationException("readXDSSchema is not implemented yet.");
    }

    private static zzZXH zzYyL() {
        zzZXH zzZXH2 = new zzZXH();
        zzZXH2.zzYuN().zzPr(false);
        zzZXH2.zzYuN().zzPz(false);
        zzZXH2.zzYuN().zzPA(false);
        zzZXH2.zzYuN().zzPB(true);
        zzZXH2.zzYuN().zzPC(true);
        zzZXH2.zzYuN().zzPy(false);
        zzZXH2.zzYuN().zzPq(false);
        zzZXH2.zzYuN().zzoK(0x800000);
        return zzZXH2;
    }
}

