/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzXJp;
    private DataTable zzXJo;
    private DataTable zzXJn;
    private String zz8P;
    private String zz8O;
    private String[] zzXJm;
    private String[] zzXJl;
    private DataColumn[] zzXJk;
    private DataColumn[] zzXJj;
    private UniqueConstraint zzXJi;
    private ForeignKeyConstraint zzXJh;
    private boolean zzXJg = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzXJp = relationName;
        this.zzXJo = parentTable;
        this.zzXJn = childTable;
        this.zz8P = parentTable.getTableName();
        this.zz8O = childTable.getTableName();
        this.zzXJm = parentColumnNames;
        this.zzXJl = childColumnNames;
        this.zzXJk = new DataColumn[this.zzXJm.length];
        for (n = 0; n < this.zzXJm.length; ++n) {
            this.zzXJk[n] = new DataColumn(this.zzXJm[n], this.zzXJo);
        }
        this.zzXJj = new DataColumn[this.zzXJl.length];
        for (n = 0; n < this.zzXJl.length; ++n) {
            this.zzXJj[n] = new DataColumn(this.zzXJl[n], this.zzXJn);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzXJp = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzXJk = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzXJj = childColumns;
        this.zzXJg = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzXJj.length; ++n) {
            if (parentColumns[n].zzY(childColumns[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzXJm = new String[this.zzXJk.length];
        for (n = 0; n < this.zzXJk.length; ++n) {
            this.zzXJm[n] = this.zzXJk[n].getColumnName();
        }
        this.zzXJl = new String[this.zzXJj.length];
        for (n = 0; n < this.zzXJj.length; ++n) {
            this.zzXJl[n] = this.zzXJj[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzXJp;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzXJo != null) {
            return this.zzXJo;
        }
        return this.zzXJk[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzXJn != null) {
            return this.zzXJn;
        }
        return this.zzXJj[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzXJm;
    }

    public String[] getChildColumnNames() {
        return this.zzXJl;
    }

    public DataColumn[] getParentColumns() {
        return this.zzXJk;
    }

    public DataColumn[] getChildColumns() {
        return this.zzXJj;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzXJi;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzXJi = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzXJh;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzXJh = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzXJp.hashCode();
        n = n * 31 + this.zz8P.hashCode();
        n = n * 31 + this.zz8O.hashCode();
        for (int i = 0; i < this.zzXJm.length; ++i) {
            n = n * 31 + this.zzXJm[i].hashCode();
            n = n * 31 + this.zzXJl[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzYyR() throws InvalidConstraintException, DataException {
        if (!this.zzXJg) {
            return;
        }
        ForeignKeyConstraint foreignKeyConstraint = this.zzX(this.getChildTable().getConstraints());
        UniqueConstraint uniqueConstraint = this.zzY(this.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzY(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzZ(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzX(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzZ(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzZ(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

