/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz1O;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXUI = new ArrayList();
    private final Map<String, DataColumn> zzXJq = new HashMap<String, DataColumn>();
    private DataTable zzYFG;

    DataColumnCollection(DataTable table) {
        this.zzYFG = table;
    }

    public void add(DataColumn column) {
        if (zz1O.zzW9(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.normalize(column.getColumnName());
        if (this.zzXJq.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZ(this.zzYFG);
        column.setOrdinal(this.zzXUI.size());
        this.zzXUI.add(column);
        this.zzXJq.put(string, column);
        this.zzYFG.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYFG);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zz1O.zzW9(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.normalize(columnName);
        DataColumn dataColumn = this.zzXJq.get(string);
        if (dataColumn != null) {
            int n = this.zzXUI.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXUI.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXUI.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXUI.remove(n);
            this.zzXJq.remove(DataColumnCollection.normalize(dataColumn.getColumnName()));
            this.zzYFG.onDataColumnDeleted(dataColumn);
        }
    }

    public int getCount() {
        return this.zzXUI.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXUI.iterator();
    }

    public void clear() {
        this.zzXJq.clear();
        this.zzXUI.clear();
    }

    final DataColumn[] zzYyS() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXUI);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXUI.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXUI.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.normalize(string);
            String string3 = DataColumnCollection.normalize(dataColumn.getColumnName());
            this.zzXJq.remove(string3);
            this.zzXJq.put(string2, dataColumn);
            return;
        }
    }

    private static String normalize(String columnName) {
        return Normalizer.normalize(columnName.toLowerCase(), Normalizer.Form.NFD);
    }
}

