/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzX;
import com.aspose.words.internal.zzZ38;
import com.aspose.words.internal.zzZUF;
import com.aspose.words.internal.zzZV4;
import com.aspose.words.internal.zzZVM;
import com.aspose.words.internal.zzZVS;
import com.aspose.words.internal.zzZVT;
import com.aspose.words.internal.zzZVU;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class zzZW9
extends zzZVS
implements zzZVM {
    private static final char[] zzXzS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final byte[] data;
    protected final int zzXzR;

    public zzZW9(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.data = zzX.zzI(byArray);
        this.zzXzR = n;
    }

    @Override
    public final String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        zzZVU zzZVU2 = new zzZVU(byteArrayOutputStream);
        try {
            zzZVU2.zzX(this);
        }
        catch (IOException iOException) {
            throw new zzZVT("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i != byArray.length; ++i) {
            stringBuffer.append(zzXzS[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(zzXzS[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public final int intValue() {
        int n = 0;
        byte[] byArray = this.data;
        if (this.zzXzR > 0 && this.data.length <= 4) {
            byArray = zzZW9.zzz(this.data, this.zzXzR);
        }
        for (int i = 0; i != byArray.length && i != 4; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public final byte[] zzYtG() {
        if (this.zzXzR != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return zzX.zzI(this.data);
    }

    public final byte[] getBytes() {
        return zzZW9.zzz(this.data, this.zzXzR);
    }

    public final int zzYtF() {
        return this.zzXzR;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return this.zzXzR ^ zzX.hashCode(this.getBytes());
    }

    @Override
    protected final boolean zzZ(zzZVS zzZVS2) {
        if (!(zzZVS2 instanceof zzZW9)) {
            return false;
        }
        zzZW9 zzZW92 = (zzZW9)zzZVS2;
        return this.zzXzR == zzZW92.zzXzR && zzX.zzY(this.getBytes(), zzZW92.getBytes());
    }

    protected static byte[] zzz(byte[] byArray, int n) {
        byte[] byArray2 = zzX.zzI(byArray);
        if (n > 0) {
            int n2 = byArray.length - 1;
            byArray2[n2] = (byte)(byArray2[n2] & 255 << n);
        }
        return byArray2;
    }

    static zzZW9 zzZ(int n, InputStream inputStream) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n2 = inputStream.read();
        byte[] byArray = new byte[n - 1];
        if (byArray.length != 0) {
            if (zzZ38.readFully(inputStream, byArray) != byArray.length) {
                throw new EOFException("EOF encountered in middle of BIT STRING");
            }
            if (n2 > 0 && n2 < 8 && byArray[byArray.length - 1] != (byte)(byArray[byArray.length - 1] & 255 << n2)) {
                return new zzZUF(byArray, n2);
            }
        }
        return new zzZV4(byArray, n2);
    }

    @Override
    final zzZVS zzYtE() {
        return new zzZV4(this.data, this.zzXzR);
    }

    @Override
    final zzZVS zzYtD() {
        return new zzZUF(this.data, this.zzXzR);
    }

    @Override
    abstract void zzZ(zzZVU var1) throws IOException;
}

