/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZAX;
import com.aspose.words.internal.zzZBL;
import com.aspose.words.internal.zzZBO;
import com.aspose.words.internal.zzZBP;
import com.aspose.words.internal.zzZC7;
import com.aspose.words.internal.zzZCK;
import com.aspose.words.internal.zzZCL;
import com.aspose.words.internal.zzZCN;
import com.aspose.words.internal.zzZQS;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZAY
extends CertPathBuilderSpi {
    private final zzZBP zzWVX;
    private zzZC7 zzWTV;

    zzZAY(zzZBP zzZBP2) {
        this.zzWVX = zzZBP2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZCK pkixParams;
        if (params instanceof zzZCK) {
            pkixParams = (zzZCK)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZCK.zzZ((PKIXBuilderParameters)params).zzYlM();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZCK.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZCL zzZCL2 = pkixParams.zzYlO().zzYlF();
        try {
            collection = zzZBO.zzZ(zzZCL2, pkixParams.zzYlO().zzYlL());
            collection.addAll(zzZBO.zzZ(zzZCL2, pkixParams.zzYlO().getCertStores()));
        }
        catch (zzZC7 zzZC72) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZC72);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZ(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWTV != null) {
            throw new CertPathBuilderException(this.zzWTV.getMessage(), this.zzWTV.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZ(X509Certificate x509Certificate, zzZCK zzZCK2, List list) throws CertPathBuilderException {
        zzZAX zzZAX2;
        zzZBL zzZBL2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZCK2.zzYlN().contains(x509Certificate)) {
            return null;
        }
        if (zzZCK2.getMaxPathLength() != -1 && list.size() - 1 > zzZCK2.getMaxPathLength()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZBL2 = new zzZBL(this.zzWVX);
            zzZAX2 = new zzZAX(this.zzWVX);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZBO.zzZ(x509Certificate, zzZCK2.zzYlO().getTrustAnchors(), zzZCK2.zzYlO().getSigProvider()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZBL2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZC7("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZAX2.engineValidate(certPath, zzZCK2);
                }
                catch (Exception exception) {
                    throw new zzZC7("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZCN> arrayList = new ArrayList<zzZCN>();
            arrayList.addAll(zzZCK2.zzYlO().zzYlL());
            try {
                arrayList.addAll(zzZBO.zzZ(x509Certificate.getExtensionValue(zzZQS.zzXo6.getId()), zzZCK2.zzYlO().zzYlK()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZC7("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZBO.zzZ(x509Certificate, zzZCK2.zzYlO().getCertStores(), arrayList));
            }
            catch (zzZC7 zzZC72) {
                throw new zzZC7("Cannot find issuer certificate for certificate in certification path.", zzZC72);
            }
            if (hashSet.isEmpty()) {
                throw new zzZC7("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZ(x509Certificate2, zzZCK2, list);
            }
        }
        catch (zzZC7 zzZC73) {
            this.zzWTV = zzZC73;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

