/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZ9B;
import com.aspose.words.internal.zzZAW;
import com.aspose.words.internal.zzZBO;
import com.aspose.words.internal.zzZC7;
import com.aspose.words.internal.zzZCJ;
import com.aspose.words.internal.zzZCK;
import com.aspose.words.internal.zzZQG;
import com.aspose.words.internal.zzZQS;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzZAX
extends CertPathValidatorSpi {
    private final Provider zzWTU;

    zzZAX(Provider provider) {
        this.zzWTU = provider;
    }

    @Override
    public final CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        int n;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        zzZCJ zzZCJ2;
        if (params instanceof zzZCJ) {
            zzZCJ2 = (zzZCJ)params;
        } else if (params instanceof zzZCK) {
            zzZCJ2 = ((zzZCK)params).zzYlO();
        } else if (params instanceof PKIXParameters) {
            zzZCJ2 = new zzZCJ.zzZ((PKIXParameters)params).zzYlE();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + zzZCJ.class.getName() + " instance.");
        }
        if (zzZCJ2.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = zzZCJ2.getInitialPolicies();
        try {
            trustAnchor = zzZBO.zzZ((X509Certificate)list.get(list.size() - 1), zzZCJ2.getTrustAnchors(), zzZCJ2.getSigProvider());
        }
        catch (zzZC7 zzZC72) {
            throw new CertPathValidatorException(zzZC72.getMessage(), (Throwable)zzZC72, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        zzZCJ2 = new zzZCJ.zzZ(zzZCJ2).zzZ(trustAnchor).zzYlE();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        zzZAW zzZAW2 = new zzZAW(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(zzZAW2);
        zzZQG zzZQG2 = new zzZQG();
        HashSet hashSet3 = new HashSet();
        int n3 = zzZCJ2.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n4 = zzZCJ2.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n5 = zzZCJ2.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = zzZBO.zzY(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        try {
            zzZBO.zzZ(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        int n6 = n2;
        if (zzZCJ2.zzYlF() != null && !zzZCJ2.zzYlF().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = zzZCJ2.getCertPathCheckers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n = list.size() - 1; n >= 0; --n) {
            boolean bl;
            int n7 = n2 - n;
            x509Certificate2 = (X509Certificate)list.get(n);
            boolean bl2 = bl = n == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n);
            }
            zzZ9B.zzZ(certPath, zzZCJ2, n, publicKey, bl, x500Principal, x509Certificate, this.zzWTU);
            zzZ9B.zzZ(certPath, n, zzZQG2);
            zzZAW2 = zzZ9B.zzZ(certPath, n, hashSet3, zzZAW2, listArray, n4);
            zzZAW2 = zzZ9B.zzZ(certPath, n, zzZAW2);
            zzZ9B.zzZ(certPath, n, zzZAW2, n3);
            if (n7 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n);
            }
            zzZ9B.zzZ(certPath, n);
            zzZAW2 = zzZ9B.zzZ(certPath, n, listArray, zzZAW2, n5);
            zzZ9B.zzY(certPath, n, zzZQG2);
            n3 = zzZ9B.zzU(certPath, n, n3);
            n5 = zzZ9B.zzT(certPath, n, n5);
            n4 = zzZ9B.zzS(certPath, n, n4);
            n3 = zzZ9B.zzZ(certPath, n, n3);
            n5 = zzZ9B.zzY(certPath, n, n5);
            n4 = zzZ9B.zzX(certPath, n, n4);
            zzZ9B.zzY(certPath, n);
            n6 = zzZ9B.zzW(certPath, n, n6);
            n6 = zzZ9B.zzV(certPath, n, n6);
            zzZ9B.zzX(certPath, n);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(zzZ9B.zzWQU);
            } else {
                hashSet = new HashSet();
            }
            zzZ9B.zzZ(certPath, n, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = zzZBO.zzY(x509Certificate);
            try {
                publicKey = zzZBO.zzZ(certPath.getCertificates(), n, this.zzWTU);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n);
            }
            zzZBO.zzZ(publicKey);
        }
        n3 = zzZ9B.zzZ(n3, x509Certificate2);
        n3 = zzZ9B.zzR(certPath, n + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(zzZ9B.zzWQU);
            set2.remove(zzZQS.zzXnT.getId());
        } else {
            set2 = new HashSet<String>();
        }
        zzZ9B.zzZ(certPath, n + 1, list2, set2);
        hashSet = zzZ9B.zzZ(certPath, zzZCJ2, set, n + 1, listArray, zzZAW2, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n);
    }
}

