/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZ3A;
import com.aspose.words.internal.zzZ3G;
import com.aspose.words.internal.zzZ92;
import com.aspose.words.internal.zzZ96;
import com.aspose.words.internal.zzZ9B;
import com.aspose.words.internal.zzZQ9;
import com.aspose.words.internal.zzZQA;
import com.aspose.words.internal.zzZQL;
import com.aspose.words.internal.zzZQO;
import com.aspose.words.internal.zzZQR;
import com.aspose.words.internal.zzZQS;
import com.aspose.words.internal.zzZQX;
import com.aspose.words.internal.zzZR0;
import com.aspose.words.internal.zzZR1;
import com.aspose.words.internal.zzZR9;
import com.aspose.words.internal.zzZRC;
import com.aspose.words.internal.zzZVS;
import com.aspose.words.internal.zzZVW;
import com.aspose.words.internal.zzZVX;
import com.aspose.words.internal.zzZVY;
import com.aspose.words.internal.zzZW0;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzZ95
extends X509CRL {
    private final Provider zzWTU;
    private final zzZQX zzWQI;
    private final String zzWQH;
    private final byte[] zzWQG;
    private final boolean zzWQF;
    private volatile boolean zzXof = false;
    private volatile int zzXpP;

    static boolean zzX(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(zzZQS.zzXo1.getId());
            return byArray != null && zzZQL.zzXI(zzZVW.zzZa(byArray).zzYtG()).zzYqE();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected zzZ95(Provider provider, zzZQX zzZQX2) throws CRLException {
        this.zzWTU = provider;
        this.zzWQI = zzZQX2;
        try {
            this.zzWQH = zzZ92.zzR(zzZQX2.zzYqY());
            this.zzWQG = (byte[])(zzZQX2.zzYqY().zzYs9() != null ? zzZQX2.zzYqY().zzYs9().zzYtH().getEncoded("DER") : null);
            this.zzWQF = zzZ95.zzX(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(zzZ9B.zzWQT);
        return !set.isEmpty();
    }

    private Set zzOy(boolean bl) {
        zzZQR zzZQR2;
        if (this.getVersion() == 2 && (zzZQR2 = this.zzWQI.zzYqW().zzYqs()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzZQR2.zzYqK();
            while (enumeration.hasMoreElements()) {
                zzZVX zzZVX2 = (zzZVX)enumeration.nextElement();
                zzZQS zzZQS2 = zzZQR2.zzS(zzZVX2);
                if (bl != zzZQS2.isCritical()) continue;
                hashSet.add(zzZVX2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public final Set getCriticalExtensionOIDs() {
        return this.zzOy(true);
    }

    public final Set getNonCriticalExtensionOIDs() {
        return this.zzOy(false);
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzZQS zzZQS2;
        zzZQR zzZQR2 = this.zzWQI.zzYqW().zzYqs();
        if (zzZQR2 != null && (zzZQS2 = zzZQR2.zzS(new zzZVX(oid))) != null) {
            try {
                return zzZQS2.zzYqM().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public final byte[] getEncoded() throws CRLException {
        try {
            return this.zzWQI.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.zzWTU);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzZ(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzZ(key, signature);
    }

    private void zzZ(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzWQI.zzYqY().equals(this.zzWQI.zzYqW().zzYqt())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public final int getVersion() {
        return this.zzWQI.getVersionNumber();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzWQI.zzYr3().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getThisUpdate() {
        return this.zzWQI.zzYqU().getDate();
    }

    @Override
    public final Date getNextUpdate() {
        if (this.zzWQI.zzYqT() != null) {
            return this.zzWQI.zzYqT().getDate();
        }
        return null;
    }

    private Set zzYkq() {
        HashSet<zzZ96> hashSet = new HashSet<zzZ96>();
        Enumeration enumeration = this.zzWQI.zzYqV();
        zzZR9 zzZR92 = null;
        while (enumeration.hasMoreElements()) {
            zzZQS zzZQS2;
            zzZQA.zzZ zzZ100 = (zzZQA.zzZ)enumeration.nextElement();
            zzZ96 zzZ962 = new zzZ96(zzZ100, this.zzWQF, zzZR92);
            hashSet.add(zzZ962);
            if (!this.zzWQF || !zzZ100.hasExtensions() || (zzZQS2 = zzZ100.zzYqs().zzS(zzZQS.zzXo0)) == null) continue;
            zzZR92 = zzZR9.zzY0(zzZQO.zzXL(zzZQS2.zzYqL()).zzYqI()[0].zzYqO());
        }
        return hashSet;
    }

    @Override
    public final X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzWQI.zzYqV();
        zzZR9 zzZR92 = null;
        while (enumeration.hasMoreElements()) {
            zzZQS zzZQS2;
            zzZQA.zzZ zzZ100 = (zzZQA.zzZ)enumeration.nextElement();
            if (serialNumber.equals(zzZ100.zzYqr().zzYtB())) {
                return new zzZ96(zzZ100, this.zzWQF, zzZR92);
            }
            if (!this.zzWQF || !zzZ100.hasExtensions() || (zzZQS2 = zzZ100.zzYqs().zzS(zzZQS.zzXo0)) == null) continue;
            zzZR92 = zzZR9.zzY0(zzZQO.zzXL(zzZQS2.zzYqL()).zzYqI()[0].zzYqO());
        }
        return null;
    }

    public final Set getRevokedCertificates() {
        Set set = this.zzYkq();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public final byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzWQI.zzYqW().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zzWQI.zzYqX().zzYtG();
    }

    @Override
    public final String getSigAlgName() {
        return this.zzWQH;
    }

    @Override
    public final String getSigAlgOID() {
        return this.zzWQI.zzYqY().zzYsa().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zzWQG != null) {
            byte[] byArray = new byte[this.zzWQG.length];
            System.arraycopy(this.zzWQG, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public final String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzZ3G.zzYiD();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzZ3G.zzWP(zzZ3A.zzo(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzZ3G.zzWP(zzZ3A.zzo(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzZ3G.zzWP(zzZ3A.zzo(byArray, i, byArray.length - i))).append(string);
        }
        zzZQR zzZQR2 = this.zzWQI.zzYqW().zzYqs();
        if (zzZQR2 != null) {
            object2 = zzZQR2.zzYqK();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzZVX)object2.nextElement();
                zzZQS zzZQS2 = zzZQR2.zzS((zzZVX)object);
                if (zzZQS2.zzYqM() != null) {
                    byte[] byArray2 = zzZQS2.zzYqM().zzYtG();
                    stringBuffer.append("                       critical(").append(zzZQS2.isCritical()).append(") ");
                    try {
                        zzZVS zzZVS2 = zzZVS.zzYb(byArray2);
                        if (((zzZVS)object).equals(zzZQS.zzXo4)) {
                            stringBuffer.append(new zzZR0(zzZW0.zzZc(zzZVS2).zzYtu())).append(string);
                            continue;
                        }
                        if (((zzZVS)object).equals(zzZQS.zzXo2)) {
                            stringBuffer.append("Base CRL: " + new zzZR0(zzZW0.zzZc(zzZVS2).zzYtu())).append(string);
                            continue;
                        }
                        if (((zzZVS)object).equals(zzZQS.zzXo1)) {
                            stringBuffer.append(zzZQL.zzXI(zzZVS2)).append(string);
                            continue;
                        }
                        if (((zzZVS)object).equals(zzZQS.zzXnY)) {
                            stringBuffer.append(zzZR1.zzXW(zzZVS2)).append(string);
                            continue;
                        }
                        if (((zzZVS)object).equals(zzZQS.zzXnS)) {
                            stringBuffer.append(zzZR1.zzXW(zzZVS2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzZVX)object).getId());
                        stringBuffer.append(" value = ").append(zzZRC.zzY3(zzZVS2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzZVX)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzWQI.zzYqV();
        zzZR9 zzZR92 = this.zzWQI.zzYr3();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzZVY zzZVY2;
                zzZQA.zzZ zzZ100 = zzZQA.zzZ.zzXA(enumeration.nextElement());
                if (this.zzWQF && zzZ100.hasExtensions() && (zzZVY2 = zzZ100.zzYqs().zzS(zzZQS.zzXo0)) != null) {
                    zzZR92 = zzZR9.zzY0(zzZQO.zzXL(zzZVY2.zzYqL()).zzYqI()[0].zzYqO());
                }
                if (!zzZ100.zzYqr().zzYtB().equals(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzZVY2 = zzZR9.zzY0(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzZVY2 = zzZQ9.zzXz(cert.getEncoded()).zzYr3();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return zzZR92.equals(zzZVY2);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        if (other instanceof zzZ95) {
            boolean bl;
            zzZ95 zzZ952 = (zzZ95)other;
            if (this.zzXof && (bl = zzZ952.zzXof) && zzZ952.zzXpP != this.zzXpP) {
                return false;
            }
            return this.zzWQI.equals(zzZ952.zzWQI);
        }
        return super.equals(other);
    }

    @Override
    public final int hashCode() {
        if (!this.zzXof) {
            this.zzXpP = super.hashCode();
            this.zzXof = true;
        }
        return this.zzXpP;
    }
}

