/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz6C;
import com.aspose.words.internal.zz7M;
import java.io.IOException;

public class zz6E
extends zz6C {
    private byte[] zzcl;
    private int zzck;
    private int _position;
    private int _length;
    private int _capacity;
    private boolean zzcj;
    private boolean zzci;
    private boolean zzch;
    private boolean zzcg;

    public zz6E() {
        this(0);
    }

    public zz6E(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity");
        }
        this.zzcl = new byte[n];
        this._capacity = n;
        this.zzcj = true;
        this.zzci = true;
        this.zzch = true;
        this.zzck = 0;
        this.zzcg = true;
    }

    public zz6E(byte[] byArray) {
        this(byArray, true);
    }

    public zz6E(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        this.zzcl = byArray;
        this._length = this._capacity = byArray.length;
        this.zzci = bl;
        this.zzch = false;
        this.zzck = 0;
        this.zzcg = true;
    }

    public zz6E(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true, false);
    }

    public zz6E(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("count");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("The buffer length minus index is less than count.");
        }
        this.zzcl = byArray;
        this.zzck = this._position = n;
        this._length = this._capacity = n + n2;
        this.zzci = bl;
        this.zzch = bl2;
        this.zzcj = false;
        this.zzcg = true;
    }

    public final boolean canRead() {
        return this.zzcg;
    }

    @Override
    public final boolean zzUd() {
        return this.zzcg;
    }

    @Override
    public final boolean canWrite() {
        return this.zzci;
    }

    @Override
    public void close() {
        this.zzcg = false;
        this.zzci = false;
        this.zzcj = false;
    }

    public final void zzuJ() throws IOException {
        this.zzcg = true;
        this.zzci = true;
        this.zzcj = true;
    }

    @Override
    public void flush() throws Exception {
    }

    private boolean zzSj(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("value");
        }
        if (n > this._capacity) {
            int n2 = n;
            if (n2 < 256) {
                n2 = 256;
            }
            if (n2 < this._capacity << 1) {
                n2 = this._capacity << 1;
            }
            this.zzSi(n2);
            return true;
        }
        return false;
    }

    public final byte[] getBuffer() {
        if (!this.zzch) {
            throw new UnsupportedOperationException("UnauthorizedAccess_MemStreamBuffer");
        }
        return this.zzcl;
    }

    private void zzSi(int n) throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (n != this._capacity) {
            if (!this.zzcj) {
                throw new UnsupportedOperationException("This stream is not expandable.");
            }
            if (n < this._length) {
                throw new IllegalArgumentException("capacity");
            }
            if (n > 0) {
                byte[] byArray = new byte[n];
                if (this._length > 0) {
                    System.arraycopy(this.zzcl, 0, byArray, 0, this._length);
                }
                this.zzcl = byArray;
            } else {
                this.zzcl = null;
            }
            this._capacity = n;
        }
    }

    @Override
    public final long getLength() throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        return this._length - this.zzck;
    }

    @Override
    public final long getPosition() throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        return this._position - this.zzck;
    }

    @Override
    public final void zzl(long l) throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("length = " + l);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("length = " + l);
        }
        this._position = this.zzck + (int)l;
    }

    @Override
    public final long zzX(long l, int n) throws IOException {
        switch (n) {
            case 0: {
                this.zzl(l);
                break;
            }
            case 1: {
                this.zzl(this.getPosition() + l);
                break;
            }
            case 2: {
                this.zzl(this.getLength() + l);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SeekOrigin type.");
            }
        }
        assert (this._position >= 0);
        return this._position;
    }

    @Override
    public final int read(byte[] buffer, int offset, int count) throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (buffer.length - offset < count) {
            throw new IllegalArgumentException("The buffer length minus index is less than count.");
        }
        int n = this._length - this._position;
        if (n > count) {
            n = count;
        }
        if (n <= 0) {
            return 0;
        }
        assert (this._position + n >= 0) : "_position + n >= 0";
        if (n <= 8) {
            int n2 = n;
            while (--n2 >= 0) {
                buffer[offset + n2] = this.zzcl[this._position + n2];
            }
        } else {
            System.arraycopy(this.zzcl, this._position, buffer, offset, n);
        }
        this._position += n;
        return n;
    }

    @Override
    public final int zzUf() throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (this._position >= this._length) {
            return -1;
        }
        return this.zzcl[this._position++] & 0xFF;
    }

    @Override
    public final void setLength(long value) throws IOException {
        if (!this.zzci) {
            zz6E.zzuH();
        }
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value");
        }
        if (value < 0L || value > (long)(Integer.MAX_VALUE - this.zzck)) {
            throw new IllegalArgumentException("value");
        }
        int n = this.zzck + (int)value;
        boolean bl = this.zzSj(n);
        if (!bl && n > this._length) {
            zz7M.fill(this.zzcl, this._length, n - this._length, (byte)0);
        }
        this._length = n;
        if (this._position > n) {
            this._position = n;
        }
    }

    public final byte[] toArray() {
        byte[] byArray = new byte[this._length - this.zzck];
        System.arraycopy(this.zzcl, this.zzck, byArray, 0, this._length - this.zzck);
        return byArray;
    }

    @Override
    public final void write(byte[] buffer, int offset, int count) throws IOException {
        int n;
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (!this.zzci) {
            zz6E.zzuH();
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (buffer.length - offset < count) {
            throw new IllegalArgumentException("Argument_InvalidOffLen");
        }
        int n2 = this._position + count;
        if (n2 < 0) {
            throw new IOException("StreamTooLong");
        }
        if (n2 > this._length) {
            boolean bl;
            int n3 = n = this._position > this._length ? 1 : 0;
            if (n2 > this._capacity && (bl = this.zzSj(n2))) {
                n = 0;
            }
            if (n != 0) {
                zz7M.fill(this.zzcl, this._length, n2 - this._length, (byte)0);
            }
            this._length = n2;
        }
        if (count <= 8) {
            n = count;
            while (--n >= 0) {
                this.zzcl[this._position + n] = buffer[offset + n];
            }
        } else {
            System.arraycopy(buffer, offset, this.zzcl, this._position, count);
        }
        this._position = n2;
    }

    @Override
    public final void writeByte(byte value) throws IOException {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (!this.zzci) {
            zz6E.zzuH();
        }
        if (this._position >= this._length) {
            boolean bl;
            boolean bl2;
            int n = this._position + 1;
            boolean bl3 = bl2 = this._position > this._length;
            if (n >= this._capacity && (bl = this.zzSj(n))) {
                bl2 = false;
            }
            if (bl2) {
                zz7M.zzJ(this.zzcl, this._length, this._position - this._length);
            }
            this._length = n;
        }
        this.zzcl[this._position++] = value;
    }

    public final void zz4(zz6C zz6C2) throws Exception {
        if (!this.zzcg) {
            zz6E.zzuI();
        }
        if (zz6C2 == null) {
            throw new IllegalArgumentException("stream");
        }
        zz6C2.write(this.zzcl, this.zzck, this._length - this.zzck);
    }

    private static void zzuI() throws IOException {
        throw new IOException("The stream is closed.");
    }

    private static void zzuH() {
        throw new UnsupportedOperationException("The stream does not support write operations.");
    }

    public String toString() {
        return zz7M.zzG(this.zzcl, this.zzck, this._length);
    }
}

