/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;

public final class zz1D
implements DataInput,
DataOutput {
    private RandomAccessFile zz1M;
    private long zz1L;
    private byte[] buffer;
    private long zz1K;
    private long zz1J;
    private int zz1I;
    private boolean zz1H;
    private int mode;
    private boolean zz1G = false;

    private zz1D(String string, String string2) throws IOException {
        this(string, string2, 4096);
    }

    private zz1D(String string, String string2, int n) throws IOException {
        this(string, "r".equals(string2) ? 1 : ("rw".equals(string2) ? 3 : 0), 4096);
    }

    public zz1D(File file, String string) throws IOException {
        this(file.getPath(), string);
    }

    private zz1D(String string, int n, int n2) throws FileNotFoundException, IOException {
        this.mode = n;
        if ((this.mode & 4) > 0) {
            this.mode |= 2;
        }
        File file = new File(string);
        if ((this.mode & 2) > 0) {
            file.exists();
        }
        if ((this.mode & 4) > 0 && file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + string);
        }
        if (this.mode == 1 && !new File(string).exists()) {
            throw new FileNotFoundException(string);
        }
        String string2 = (this.mode & 2) > 0 ? "rw" : "r";
        this.zz1M = new RandomAccessFile(string, string2);
        this.zz1K = 0L;
        this.zz1J = 0L;
        this.zz1I = 0;
        this.zz1L = 0L;
        this.buffer = new byte[n2];
        this.zz1H = false;
    }

    public final void close() throws IOException {
        try {
            if ((this.mode | 2) > 0 && this.zz1G) {
                this.zz1M.seek(this.zz1K);
                this.zz1M.write(this.buffer, 0, this.zz1I);
            }
            return;
        }
        finally {
            this.zz1M.close();
        }
    }

    public final void seek(long pos) throws IOException {
        if (pos >= this.zz1K && pos < this.zz1J) {
            this.zz1L = pos;
            return;
        }
        if (this.zz1G) {
            this.flush();
        }
        this.zz1K = pos;
        this.zz1L = pos;
        this.zz1I = this.zzZ(pos, this.buffer, 0, this.buffer.length);
        if (this.zz1I < 0) {
            this.zz1I = 0;
            this.zz1H = true;
        } else {
            this.zz1H = false;
        }
        this.zz1J = this.zz1K + (long)this.zz1I;
    }

    public final long getFilePointer() throws IOException {
        return this.zz1L;
    }

    public final long length() throws IOException {
        long l = this.zz1M.length();
        if (l < this.zz1J) {
            return this.zz1J;
        }
        return l;
    }

    public final void setLength(long newLength) throws IOException {
        if (this.zz1G) {
            this.flush();
        }
        this.zz1M.setLength(newLength);
        if (this.zz1L > newLength) {
            this.seek(newLength);
        }
    }

    public final void flush() throws IOException {
        if (this.zz1G) {
            this.zz1M.seek(this.zz1K);
            this.zz1M.write(this.buffer, 0, this.zz1I);
            this.zz1G = false;
        }
    }

    public final int read() throws IOException {
        while (this.zz1L >= this.zz1J) {
            if (this.zz1H) {
                return -1;
            }
            this.seek(this.zz1L);
        }
        return this.buffer[(int)(this.zz1L++ - this.zz1K)] & 0xFF;
    }

    private int zzF(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while (true) {
            if (this.zz1H) {
                return -1;
            }
            n3 = (int)(this.zz1J - this.zz1L);
            if (n3 > 0) break;
            this.seek(this.zz1L);
        }
        int n4 = n3 >= n2 ? n2 : n3;
        System.arraycopy(this.buffer, (int)(this.zz1L - this.zz1K), byArray, n, n4);
        this.zz1L += (long)n4;
        if (n4 < n2) {
            int n5 = n2 - n4;
            if (n5 > this.buffer.length) {
                n5 = this.zzZ(this.zz1L, byArray, n + n4, n2 - n4);
            } else {
                this.seek(this.zz1L);
                if (!this.zz1H) {
                    n5 = n5 > this.zz1I ? this.zz1I : n5;
                    System.arraycopy(this.buffer, 0, byArray, n + n4, n5);
                } else {
                    n5 = -1;
                }
            }
            if (n5 > 0) {
                this.zz1L += (long)n5;
                return n4 + n5;
            }
        }
        return n4;
    }

    private int zzZ(long l, byte[] byArray, int n, int n2) throws IOException {
        this.zz1M.seek(l);
        int n3 = this.zz1M.read(byArray, n, n2);
        return n3;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.zzF(b, off, len);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int n;
        for (int i = 0; i < len; i += n) {
            zz1D zz1D2 = this;
            byte[] byArray = b;
            int n2 = off + i;
            int n3 = len - i;
            n = zz1D2.zzF(byArray, n2, n3);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        zz1D zz1D2 = this;
        this.seek(zz1D2.zz1L + (long)n);
        return n;
    }

    @Override
    public final void write(int b) throws IOException {
        while (true) {
            if (this.zz1L >= this.zz1K && this.zz1L < this.zz1K + (long)this.buffer.length) {
                this.buffer[(int)(this.zz1L - this.zz1K)] = (byte)b;
                this.zz1G = true;
                if (this.zz1L >= this.zz1J) {
                    ++this.zz1I;
                    ++this.zz1J;
                }
                ++this.zz1L;
                return;
            }
            this.seek(this.zz1L);
        }
    }

    private void zzU(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < this.buffer.length) {
            long l;
            int n3 = 0;
            int n4 = 0;
            if (this.zz1L >= this.zz1K) {
                n3 = (int)(this.zz1K + (long)this.buffer.length - this.zz1L);
            }
            if (n3 > 0) {
                n4 = n3 > n2 ? n2 : n3;
                System.arraycopy(byArray, n, this.buffer, (int)(this.zz1L - this.zz1K), n4);
                this.zz1G = true;
                l = this.zz1L + (long)n4;
                this.zz1J = l > this.zz1J ? l : this.zz1J;
                this.zz1I = (int)(this.zz1J - this.zz1K);
                this.zz1L += (long)n4;
            }
            if (n4 < n2) {
                this.seek(this.zz1L);
                System.arraycopy(byArray, n + n4, this.buffer, (int)(this.zz1L - this.zz1K), n2 - n4);
                this.zz1G = true;
                l = this.zz1L + (long)(n2 - n4);
                this.zz1J = l > this.zz1J ? l : this.zz1J;
                this.zz1I = (int)(this.zz1J - this.zz1K);
                this.zz1L += (long)(n2 - n4);
            }
            return;
        }
        this.flush();
        this.zz1I = 0;
        this.zz1J = 0L;
        this.zz1K = 0L;
        this.zz1M.seek(this.zz1L);
        this.zz1M.write(byArray, n, n2);
        this.zz1L += (long)n2;
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.zzU(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.zzU(b, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    @Override
    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    @Override
    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)v & 0xFF);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int n;
        int n2 = str.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = str.charAt(n);
            if (c > '\u0000' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = str.charAt(n);
            if (c > '\u0000' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c & 0x3F);
        }
    }

    public final String toString() {
        return "fp=" + this.zz1L + ", bs=" + this.zz1K + ", de=" + this.zz1J + ", ds=" + this.zz1I + ", bl=" + this.buffer.length + ", m=" + this.mode + ", bm=" + this.zz1G;
    }
}

