/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ConditionalStyle;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.Font;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.List;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.Style;
import com.aspose.words.TableStyle;
import com.aspose.words.Theme;
import com.aspose.words.internal.zz1O;
import com.aspose.words.internal.zz6C;
import com.aspose.words.internal.zzAU;
import com.aspose.words.internal.zzBC;
import com.aspose.words.internal.zzBP;
import com.aspose.words.internal.zzBR;
import com.aspose.words.internal.zzMD;
import com.aspose.words.internal.zzZE;
import com.aspose.words.zz6;
import com.aspose.words.zzX;
import com.aspose.words.zzYSI;
import com.aspose.words.zzYU9;
import com.aspose.words.zzYYX;
import com.aspose.words.zzZ5V;
import com.aspose.words.zzZM0;
import com.aspose.words.zzZMT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StyleCollection
implements Cloneable,
Iterable<Style> {
    private DocumentBase zzZZx;
    private zzYYX zzXY2 = new zzYYX();
    private zzZ5V zzXY1 = new zzZ5V();
    private zzBR<Style> zzXY0 = new zzBR();
    private zzBP<Style> zzXXZ = new zzBP();
    private zzBR<Style> zzXXY = new zzBR();
    private zzZM0 zzXXX = new zzZM0();
    private static Document zzXXW;
    private static Object zzXXV;
    private static Document zzXXU;
    private static Object zzXXT;
    private static Document zzXXS;
    private static Object zzXXR;
    private Font zzXXQ;
    private ParagraphFormat zzXXP;
    private HashMap<Style, String> zzXXO;

    StyleCollection(DocumentBase doc) {
        this.zzZZx = doc;
    }

    public DocumentBase getDocument() {
        return this.zzZZx;
    }

    public Font getDefaultFont() {
        if (this.zzXXQ == null) {
            StyleCollection styleCollection = this;
            this.zzXXQ = new Font(styleCollection.zzXY2, this.zzZZx);
        }
        return this.zzXXQ;
    }

    public ParagraphFormat getDefaultParagraphFormat() {
        if (this.zzXXP == null) {
            StyleCollection styleCollection = this;
            this.zzXXP = new ParagraphFormat(styleCollection.zzXY1, this);
        }
        return this.zzXXP;
    }

    public int getCount() {
        return this.zzXY0.getCount();
    }

    public Style get(String name) {
        return this.zz6(name, true);
    }

    public Style getByStyleIdentifier(int sti) {
        return this.zzZh(sti, true);
    }

    public Style get(int index) {
        return this.zzXY0.zzVB(index);
    }

    final void validate() {
        this.zzYIt();
        Style style = this.zz6("Table Normal", false);
        if (style != null && style.getType() != 3) {
            this.zzy(style);
        }
    }

    private int zzYIH() {
        if (this.zzXY0.getCount() > 0) {
            return this.zzXY0.zzTv(this.zzXY0.getCount() - 1);
        }
        return -1;
    }

    final zzYYX zzYIG() {
        return this.zzXY2;
    }

    final zzZ5V zzYIF() {
        return this.zzXY1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleCollection zzYIE() {
        if (zzXXW == null) {
            Object object = zzXXV;
            synchronized (object) {
                if (zzXXW == null) {
                    zzXXW = StyleCollection.zzGf("Aspose.Words.Resources.AllStyles2003.docx");
                }
            }
        }
        return zzXXW.getStyles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleCollection zzYID() {
        if (zzXXU == null) {
            Object object = zzXXT;
            synchronized (object) {
                if (zzXXU == null) {
                    zzXXU = StyleCollection.zzGf("Aspose.Words.Resources.AllStyles2007.docx");
                }
            }
        }
        return zzXXU.getStyles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleCollection zzYIC() {
        if (zzXXS == null) {
            Object object = zzXXR;
            synchronized (object) {
                if (zzXXS == null) {
                    zzXXS = StyleCollection.zzGf("Aspose.Words.Resources.AllStyles2013.docx");
                }
            }
        }
        return zzXXS.getStyles();
    }

    final StyleCollection zzYIB() {
        Document document = this.getDocument().getNodeType() == 1 ? (Document)this.getDocument() : ((GlossaryDocument)this.getDocument()).zzZQd();
        int n = document.getCompatibilityOptions().getMswVersion();
        if (n != 0) {
            switch (n) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return StyleCollection.zzYIE();
                }
                case 12: 
                case 14: {
                    return StyleCollection.zzYID();
                }
                case 15: 
                case 16: {
                    return StyleCollection.zzYIC();
                }
            }
        }
        return StyleCollection.zzs2(this.getLoadFormat());
    }

    private static StyleCollection zzs2(int n) {
        switch (n) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return StyleCollection.zzYID();
            }
        }
        return StyleCollection.zzYIE();
    }

    private static Document zzGf(String string) {
        Document document;
        block6: {
            String string2 = string;
            zz6C zz6C2 = zzAU.zzY(string2, Document.class);
            try {
                Document document2 = new Document(zz6C2);
                document2.getStyles().zzYIu();
                document = document2;
                if (zz6C2 == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (zz6C2 != null) {
                        zz6C2.close();
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Cannot load built in styles from an embedded resource.", exception);
                }
            }
            zz6C2.close();
        }
        return document;
    }

    final zzZM0 zzYVw() {
        return this.zzXXX;
    }

    private boolean zzYIA() {
        return this.getDocument() == zzXXW || this.getDocument() == zzXXU || this.getDocument() == zzXXS;
    }

    final int zzYIz() {
        if (!this.zzYIy()) {
            throw new IllegalStateException("There are too many styles in the document.");
        }
        return this.zzYIx();
    }

    final boolean zzYIy() {
        int n = this.zzYIx();
        return n < 4094;
    }

    private int zzYIx() {
        return Math.max(this.zzYIH(), 14) + 1;
    }

    @Override
    public Iterator<Style> iterator() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.zzXXZ) {
            String string = (String)entry.getKey();
            Style style = (Style)entry.getValue();
            if (!zz1O.equals(style.getName(), string)) continue;
            com.aspose.words.internal.zzX.zzZ(arrayList, style);
        }
        return arrayList.iterator();
    }

    public Style add(int type, String name) {
        com.aspose.words.internal.zzX.zzZ(name, "name");
        Style style = Style.zzY(type, this.zzYIz(), 4094, name);
        if (type == 4) {
            List list = zzX.zzZ(this.getDocument().getLists(), 6);
            list.zzZkT().zzCb(style.zzZz6());
            style.zzgE().zzCu(list.getListId());
        }
        this.zzw(style);
        return style;
    }

    final void remove(String styleName) {
        while (true) {
            Style style;
            if ((style = this.zz6(styleName, false)) == null) {
                throw new IllegalArgumentException("Style not found.");
            }
            for (Style style2 : this) {
                if (style2.zzYJ4() == style.zzZz6()) {
                    StyleCollection.zzZ(style2, style);
                    style2.zzs9(StyleCollection.zzs1(style2.getType()));
                    if (style2.getType() != 1 || style2.zzYJ3() != style.zzZz6()) continue;
                    style2.zzs8(style2.zzZz6());
                    continue;
                }
                if (style2.getType() != 1 || style2.zzYJ3() != style.zzZz6()) continue;
                style2.zzs8(0);
            }
            this.zzV(style, style.zzZz6(), -1);
            if (style.hasRevisions() && style.getDocument() instanceof Document) {
                ((Document)style.getDocument()).getRevisions().zzO(style);
            }
            this.zzy(style);
            Style style3 = style.getLinkedStyle();
            if (style3 == null) break;
            style3.zzs7(4095);
            styleName = style3.getName();
        }
    }

    final void zzy(Style style) {
        if (this.zzYIB().zz6(style.getName(), false) != null) {
            this.zzXXY.remove(style.getStyleIdentifier());
        }
        this.zzXY0.remove(style.zzZz6());
        this.zzx(style);
        this.zzXXO = null;
    }

    final void zzS(StyleCollection styleCollection) {
        StyleCollection styleCollection2 = styleCollection;
        this.zzXY2 = (zzYYX)styleCollection2.zzXY2.zzqw();
        styleCollection2 = styleCollection;
        this.zzXY1 = (zzZ5V)styleCollection2.zzXY1.zzqw();
        this.zzZ(styleCollection, new zzZMT(styleCollection, this));
    }

    private void zzx(Style style) {
        for (int i = this.zzXXZ.getCount() - 1; i >= 0; --i) {
            if (this.zzXXZ.zzVB(i) != style) continue;
            this.zzXXZ.removeAt(i);
        }
    }

    private static int zzs1(int n) {
        switch (n) {
            case 2: {
                return 10;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 11;
            }
        }
        return 4095;
    }

    private void zzWB(int n, int n2) {
        for (Row row : this.getDocument().getChildNodes(6, true)) {
            zzYSI zzYSI2 = row.zzgA();
            if (zzYSI2.zzZz6() != n) continue;
            if (n2 == -1) {
                zzYSI2.remove(4005);
                continue;
            }
            zzYSI2.set(4005, n2);
        }
    }

    private void zzZ(Style style, int n, int n2) {
        for (Paragraph paragraph : this.getDocument().getChildNodes(8, true)) {
            zzZ5V zzZ5V2 = paragraph.zzgE();
            if (zzZ5V2.getListId() == 0 || paragraph.getListFormat().getList().getStyle() == null || paragraph.getListFormat().getList().getStyle().zzZz6() != n) continue;
            if (n2 == -1) {
                zzZ5V2.remove(1120);
                zzZ5V2.remove(1110);
                continue;
            }
            zzZ5V2.set(1120, style.getList().getListId());
        }
    }

    private void zzWA(int n, int n2) {
        for (Paragraph paragraph : this.getDocument().getChildNodes(8, true)) {
            zzZ5V zzZ5V2 = paragraph.zzgE();
            if (zzZ5V2.zzZz6() != n) continue;
            if (n2 == -1) {
                zzZ5V2.remove(1000);
                continue;
            }
            zzZ5V2.set(1000, n2);
        }
    }

    private void zzWz(int n, int n2) {
        for (Paragraph paragraph : this.getDocument().getChildNodes(8, true)) {
            StyleCollection.zzZ(paragraph.zzZ14(), n, n2);
            for (Run run : paragraph.getRuns()) {
                StyleCollection.zzZ(run.zzgC(), n, n2);
            }
        }
    }

    private static void zzZ(zzYYX zzYYX2, int n, int n2) {
        if (zzYYX2.zzZz6() == n) {
            if (n2 == -1) {
                zzYYX2.remove(50);
                return;
            }
            zzYYX2.set(50, n2);
        }
    }

    private static void zzZ(Style style, Style style2) {
        switch (style2.getType()) {
            case 2: {
                style.zzY(style.zzs4(0));
                return;
            }
            case 1: {
                style.zzY(style.zzs4(0));
                style.zzZ(style.zzwG(1));
                return;
            }
            case 3: {
                TableStyle tableStyle = (TableStyle)style;
                tableStyle.zzY(tableStyle.zzYDM());
                tableStyle.zzW(tableStyle.zzni());
                tableStyle.zzZ(tableStyle.zzYDN());
                style.zzY(style.zzs4(0));
                style.zzZ(style.zzwG(1));
                return;
            }
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected style type.");
    }

    final void zzw(Style style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        if (style.getStyles() != null) {
            throw new IllegalArgumentException("Style already belongs to another collection of styles.");
        }
        if (this.zzXXZ.containsKey(style.getName())) {
            throw new IllegalArgumentException("Cannot add a style because a style with the same name already exists.");
        }
        if (style.getBuiltIn() && this.zzXXY.contains(style.getStyleIdentifier())) {
            throw new IllegalArgumentException("Cannot add a style because a style with this identifier already exists.");
        }
        this.zzXY0.add(style.zzZz6(), style);
        this.zzXXZ.zzB(style.getName(), style);
        if (style.getBuiltIn()) {
            this.zzXXY.add(style.getStyleIdentifier(), style);
        }
        style.zzT(this);
        this.zzXXO = null;
    }

    final void zzZ(Style style, String string, String string2) {
        this.zzXXZ.remove(string);
        if (!this.zzXXZ.containsKey(string2)) {
            this.zzXXZ.zzB(string2, style);
        } else {
            Style style2 = (Style)this.zzXXZ.get(string2);
            this.zzXXZ.set(string2, style);
            if (style2 != style && zz1O.equals(style2.getName(), string2)) {
                this.zzx(style2);
            }
        }
        this.zzXXO = null;
    }

    final void zzY(Style style, int n, int n2) {
        if (style.getBuiltIn()) {
            this.zzXXY.remove(n);
        }
        if (n2 != 4094) {
            if (this.zzXXY.contains(n2)) {
                this.zzXXY.set(n2, style);
                return;
            }
            this.zzXXY.add(n2, style);
        }
    }

    final void zzX(Style style, int n, int n2) {
        this.zzXY0.remove(n);
        if (this.zzXY0.contains(n2)) {
            this.zzXY0.set(n2, style);
        } else {
            this.zzXY0.add(n2, style);
        }
        this.zzW(style, n, n2);
    }

    private void zzW(Style style, int n, int n2) {
        this.zzWy(n, n2);
        this.zzV(style, n, n2);
    }

    private void zzWy(int n, int n2) {
        for (Style style : this) {
            if (style.zzYJ4() == n) {
                style.zzs9(n2);
            }
            if (style.zzYJ3() == n) {
                style.zzs8(n2);
            }
            if (style.zzYJ2() != n) continue;
            style.zzs7(n2);
        }
    }

    private void zzV(Style style, int n, int n2) {
        switch (style.getType()) {
            case 2: {
                this.zzWz(n, n2);
                return;
            }
            case 1: {
                this.zzWA(n, n2);
                return;
            }
            case 4: {
                this.zzZ(style, n, n2);
                return;
            }
            case 3: {
                this.zzWB(n, n2);
                return;
            }
        }
        throw new IllegalStateException("Unknown style type.");
    }

    final void zzZ(Style style, String[] stringArray) {
        if (!StyleCollection.zzv(style)) {
            this.zzZh(style.getStyleIdentifier(), true);
            return;
        }
        if (this.zzXXZ.containsKey(style.getName())) {
            style.zzGg(this.zzLi(style.getName()));
        }
        if (style.getBuiltIn() && this.zzXXY.contains(style.getStyleIdentifier())) {
            style.setStyleIdentifier(4094);
        }
        this.zzw(style);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.zzXXZ.zzB(this.zzLi(stringArray[i]), style);
            }
            this.zzXXO = null;
        }
    }

    final String zzLi(String string) {
        String string2 = string;
        int n = 0;
        while (this.zzXXZ.containsKey(string2)) {
            string2 = zz1O.format("{0}_{1}", string, n);
            ++n;
        }
        return string2;
    }

    public Style addCopy(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("Style can not be null.");
        }
        Style style2 = this.zzu(style);
        if (style.zzYJ2() != 4095) {
            Style style3 = style.getStyles().zzZi(style.zzYJ2(), false);
            if (style3 != null) {
                Style style4 = this.zzu(style3);
                style2.zzs7(style4.zzZz6());
                style4.zzs7(style2.zzZz6());
            } else {
                style2.zzs7(4095);
            }
        }
        return style2;
    }

    private static boolean zzv(Style style) {
        switch (style.getStyleIdentifier()) {
            case 65: {
                return style.getType() == 2;
            }
            case 0: {
                return style.getType() == 1;
            }
            case 105: {
                return style.getType() == 3;
            }
        }
        return true;
    }

    private Style zzu(Style style) {
        Style style2 = style.zzYIT();
        style2.zzGg(this.zzXXZ.containsKey(style.getName()) ? this.zzLi(style.getName()) : style.getName());
        int n = zzYU9.zzFW(style2.getName());
        boolean bl = false;
        if (n != 4094) {
            bl = zzYU9.zzZ(style2, n, null, false);
        } else {
            style2.setStyleIdentifier(4094);
        }
        if (!bl) {
            style2.zzFj(this.zzYIz());
        }
        style2.zzs8(zzYU9.zzrK(style.zzYJ3()) ? style.zzYJ3() : style2.zzZz6());
        style2.zzs9(zzYU9.zzrK(style.zzYJ4()) ? style.zzYJ4() : 4095);
        this.zzw(style2);
        Document document = com.aspose.words.internal.zzX.zzZ((Object)style.getDocument(), Document.class);
        if (document != null && !document.getStyles().zzYIA()) {
            StyleCollection.zzY(style, style2);
        }
        int n2 = (Integer)style.fetchParaAttr(1120);
        if (style.getType() != 2 && n2 > 0) {
            List list = style.getDocument().getLists().zzCm(n2);
            List list2 = this.getDocument().getLists().zzZ(list, false);
            style2.zzgE().zzCu(list2.getListId());
            for (ListLevel listLevel : list2.getListLevels()) {
                if (listLevel.zzZkd() != style.zzZz6()) continue;
                listLevel.zzBY(style2.zzZz6());
            }
        }
        if (style2.hasRevisions() && style2.getDocument() instanceof Document) {
            ((Document)style2.getDocument()).getRevisions().zzN(style2);
        }
        return style2;
    }

    private static void zzY(Style style, Style style2) {
        switch (style.getType()) {
            case 1: {
                StyleCollection.zzW(style, style2);
                StyleCollection.zzX(style, style2);
                return;
            }
            case 2: {
                StyleCollection.zzW(style, style2);
                return;
            }
            case 4: {
                return;
            }
            case 3: {
                StyleCollection.zzY((TableStyle)style, (TableStyle)style2);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown style type");
    }

    private static void zzX(Style style, Style style2) {
        zzZ5V zzZ5V2 = style.zzwG(65);
        zzZ5V zzZ5V3 = style2.zzwG(193);
        zzZ5V2.zzX(zzZ5V3);
        style2.zzgE().zzZ((zz6)zzZ5V2, new int[]{1000, 1120, 1580});
        style2.zzZ(zzZ5V2);
    }

    private static void zzW(Style style, Style style2) {
        boolean bl;
        Theme theme;
        Theme theme2 = style.getDocument().zzZPj();
        boolean bl2 = !Theme.zzZ(theme2, theme = style2.getDocument().zzZPj()) && !(style.getDocument() instanceof GlossaryDocument) && !(style2.getDocument() instanceof GlossaryDocument);
        boolean bl3 = style.getType() == 2 && style.zzYJ2() != 4095;
        int n = StyleCollection.zzY(style2, bl3);
        zzYYX zzYYX2 = style.zzs4(n);
        if (bl2) {
            Theme.zzZ(theme2, zzYYX2);
        }
        if (!(bl = style2.getType() == 2 && style2.zzYJ2() == 4095 && !bl3)) {
            zzYYX zzYYX3 = style2.zzs4(n | 0x80);
            zzYYX2.zzX(zzYYX3);
        }
        style2.zzgC().zzZ((zz6)zzYYX2, new int[]{50, 40, 30});
        style2.zzY(zzYYX2);
    }

    private static int zzY(Style style, boolean bl) {
        int n = 33;
        if (style.getType() != 2 || style.zzYJ2() != 4095) {
            return 33;
        }
        if (!bl) {
            n = 0;
        }
        return n;
    }

    private static void zzY(TableStyle tableStyle, TableStyle tableStyle2) {
        StyleCollection.zzW(tableStyle, tableStyle2);
        StyleCollection.zzX(tableStyle, tableStyle2);
        tableStyle2.zzY(tableStyle.zzYDM());
        tableStyle2.zzW(tableStyle.zzni());
        tableStyle2.zzZ(tableStyle.zzYDN());
        TableStyle tableStyle3 = com.aspose.words.internal.zzX.zzZ((Object)tableStyle2.zzYIS(), TableStyle.class);
        if (tableStyle3 != null) {
            tableStyle2.zzgy().zzX(tableStyle3.zzYDM());
            tableStyle2.zznj().zzX(tableStyle3.zzni());
            tableStyle2.zzgA().zzX(tableStyle3.zzYDN());
        }
    }

    final StyleCollection zzs(DocumentBase documentBase) {
        StyleCollection styleCollection = (StyleCollection)this.memberwiseClone();
        ((StyleCollection)this.memberwiseClone()).zzZZx = documentBase;
        styleCollection.zzXY2 = (zzYYX)this.zzXY2.zzqw();
        styleCollection.zzXY1 = (zzZ5V)this.zzXY1.zzqw();
        styleCollection.zzXY0 = new zzBR();
        styleCollection.zzXXZ = new zzBP();
        styleCollection.zzXXY = new zzBR();
        for (int i = 0; i < this.zzXY0.getCount(); ++i) {
            Style object = this.zzXY0.zzVB(i);
            styleCollection.zzw(object.zzYIT());
        }
        for (Map.Entry entry : this.zzXXZ) {
            Style style;
            String string = (String)entry.getKey();
            if (zz1O.equals(string, (style = (Style)entry.getValue()).getName())) continue;
            Style style2 = styleCollection.zz6(style.getName(), false);
            styleCollection.zzXXZ.zzB(string, style2);
        }
        styleCollection.zzXXX = this.zzXXX.zzZp6();
        styleCollection.zzXXO = null;
        styleCollection.zzXXQ = null;
        styleCollection.zzXXP = null;
        return styleCollection;
    }

    final String zzX(Style style, boolean bl) {
        String string;
        if (this.zzXXO == null) {
            this.zzYIw();
        }
        if (!zzBC.zzYe(string = com.aspose.words.internal.zzX.zzZ(this.zzXXO, style))) {
            string = "";
        }
        if (bl) {
            return zzBC.zzw(style.getName(), string);
        }
        return string;
    }

    private void zzYIw() {
        this.zzXXO = new HashMap(this.zzXXZ.getCount());
        for (int i = 0; i < this.zzXXZ.getCount(); ++i) {
            Style style = this.zzXXZ.zzVB(i);
            String string = this.zzXXZ.getKey(i);
            if (zz1O.equals(style.getName(), string)) continue;
            String string2 = com.aspose.words.internal.zzX.zzZ(this.zzXXO, style);
            this.zzXXO.put(style, zzBC.zzw(string2, string));
        }
    }

    final Style zzZi(int n, boolean bl) {
        Style style;
        Style style2 = this.zzXY0.get(n);
        if (style2 == null && bl && (style = this.zzYIB().zzZi(n, false)) != null) {
            style2 = this.zzt(style);
        }
        return style2;
    }

    final Style zz6(String string, boolean bl) {
        com.aspose.words.internal.zzX.zzZ((Object)string, "name");
        Style style = com.aspose.words.internal.zzX.zzZ(this.zzXXZ, string);
        if (style == null && bl) {
            Style style2 = this.zzYIB().zz6(string, false);
            if (style2 == null) {
                style2 = StyleCollection.zzYIC().zz6(string, false);
                if (style2 == null) {
                    style2 = StyleCollection.zzYID().zz6(string, false);
                }
                if (style2 == null) {
                    style2 = StyleCollection.zzYIE().zz6(string, false);
                }
            }
            if (style2 != null && style2.getBuiltIn()) {
                style = this.zzt(style2);
            }
        }
        return style;
    }

    final Style zzZh(int n, boolean bl) {
        Style style;
        if (n == 4094) {
            throw new IllegalArgumentException("Cannot return user defined styles by style identifier.");
        }
        Style style2 = this.zzXXY.get(n);
        if (style2 == null && bl && (style = this.zzs0(n)) != null) {
            style2 = this.zzt(style);
        }
        return style2;
    }

    private Style zzs0(int n) {
        Style style = this.zzYIB().zzZh(n, false);
        if (style == null) {
            style = StyleCollection.zzYIC().zzZh(n, false);
            if (style == null) {
                style = StyleCollection.zzYID().zzZh(n, false);
            }
            if (style == null) {
                style = StyleCollection.zzYIE().zzZh(n, false);
            }
        }
        return style;
    }

    private int getLoadFormat() {
        if (this.zzZZx.getNodeType() == 29) {
            return 20;
        }
        return ((Document)this.zzZZx).getOriginalLoadFormat();
    }

    final boolean contains(int styleIdentifier) {
        return this.zzXXY.zzVq(styleIdentifier);
    }

    final Style zzWx(int n, int n2) {
        Style style = this.zzZi(n, n <= 14);
        if (style != null) {
            return style;
        }
        style = this.zzZi(n2, n2 <= 14);
        if (style != null) {
            return style;
        }
        throw new IllegalStateException("Cannot find a style with this istd.");
    }

    final Style zzGe(String string) {
        Style style = this.get(string);
        if (style == null) {
            throw new IllegalStateException(zz1O.format("Cannot find style '{0}'.", string));
        }
        return style;
    }

    final Style zzrZ(int n) {
        Style style = this.getByStyleIdentifier(n);
        if (style == null) {
            throw new IllegalStateException("Cannot find a style with this style identifier.");
        }
        return style;
    }

    final Style zzt(Style style) {
        zzZMT zzZMT2 = new zzZMT(style.getDocument(), this.getDocument(), 0);
        return this.zzZ(zzZMT2, style);
    }

    final Style zzZ(zzZMT zzZMT2, Style style) {
        try {
            Style style2;
            int n;
            if (style == null) {
                throw new NullPointerException("srcStyle");
            }
            if (style.getStyles() == this) {
                return style;
            }
            if (style.zzYJ4() != 4095 && (n = this.zzY(style, zzZMT2)) == 4095) {
                this.zzZ(zzZMT2, style.zzYIS());
            }
            if (zzZMT2.zzU(style)) {
                return this.zzZi(zzZMT2.zzZqa().get(style.zzZz6()), false);
            }
            switch (zzZMT2.zzZMg()) {
                case 0: 
                case 2: {
                    style2 = this.zzX(zzZMT2, style);
                    break;
                }
                case 1: {
                    style2 = this.zzY(zzZMT2, style);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown import format action.");
                }
            }
            return style2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final Style zzs(Style style) {
        Style style2;
        if (style.getBuiltIn() && (style2 = this.zzZh(style.getStyleIdentifier(), false)) != null) {
            return style2;
        }
        return this.zz6(style.getName(), false);
    }

    private Style zzr(Style style) {
        Style style2;
        if (style.getBuiltIn() && (style2 = this.zzZh(style.getStyleIdentifier(), false)) != null && style2.getType() == style.getType()) {
            return style2;
        }
        return this.zzp(style);
    }

    private Style zzY(zzZMT zzZMT2, Style style) {
        Style style2;
        if (zzYU9.zzj(style) && (style2 = this.zzZh(style.getStyleIdentifier(), false)) != null) {
            return style2;
        }
        style2 = style.zzYIT();
        if (zzZMT2.zzZq5()) {
            Theme.zzZ(zzZMT2.zzZqg().zzZPj(), style2.zzgC());
        }
        if (zzZMT2.zzZq4()) {
            zzX.zzZ(style2, zzZMT2.zzZqf().zzZPj());
        }
        if (this.zzs(style) == null) {
            if (style.zzZz6() > 14) {
                style2.zzFj(this.zzYIz());
            }
        } else {
            style2.zzGg(this.zzLi(style.getName()));
            style2.zzFj(this.zzYIz());
            style2.setStyleIdentifier(4094);
        }
        this.zzZ(style, zzZMT2, style2);
        if (!zzZMT2.zzZqe().zzYIA()) {
            this.zzV(style, style2);
        }
        return style2;
    }

    private Style zzX(zzZMT zzZMT2, Style style) {
        Style style2 = this.zzs(style);
        if (style2 != null) {
            if (zzZMT2.zzZMg() == 0) {
                return style2;
            }
            Style style3 = this.zzY(zzZMT2, style);
            style2 = this.zzq(style3);
            if (style2 == null) {
                return style3;
            }
            style3.remove();
            zzZMT2.zzZqa().set(style.zzZz6(), style2.zzZz6());
            if (style.zzYJ2() != 4095) {
                zzZMT2.zzZqa().set(style.zzYJ2(), style2.zzYJ2());
            }
            return style2;
        }
        return this.zzY(zzZMT2, style);
    }

    private void zzZ(Style style, zzZMT zzZMT2, Style style2) {
        int n;
        this.zzw(style2);
        zzZMT2.zzZqa().set(style.zzZz6(), style2.zzZz6());
        if (style.zzYJ4() != 4095) {
            n = this.zzY(style, zzZMT2);
            zz1O.format("The base style for '{0}' must be already imported.", style2.getName());
            style2.zzs9(n);
        }
        if (style.getType() == 4 || style.getType() == 1) {
            StyleCollection.zzZ(zzZMT2, style, style2);
        }
        if (style.zzYJ3() != 4095) {
            style2.zzs8(this.zzZ(zzZMT2, style.zzYIR()).zzZz6());
        }
        if (style.zzYJ2() != 4095) {
            n = zzZMT2.zzZqa().get(style.zzYJ2());
            if (zzMD.zzVT(n)) {
                style2.zzs7(this.zzZ(zzZMT2, style.getLinkedStyle()).zzZz6());
                if (style2.zzYJ2() != 4095) {
                    Style style3 = this.zzZi(style2.zzYJ2(), false);
                    style3.zzs7(style2.zzZz6());
                    return;
                }
            } else {
                style2.zzs7(4095);
            }
        }
    }

    private static void zzZ(zzZMT zzZMT2, Style style, Style style2) {
        if (style.getType() != 1) {
            style.getType();
        }
        if (style.zzgE().getListId() == 0) {
            return;
        }
        int n = style.zzgE().getListId();
        int n2 = zzZMT2.zzZqb().zzZ(zzZMT2, n);
        style2.zzgE().zzCu(n2);
        if (style2.getType() == 4) {
            style2.getList().zzZkT().zzCb(style2.zzZz6());
        }
    }

    final void ensureMinimum() {
        this.zzo(0, "Normal");
        this.zzo(65, "Default Paragraph Font");
    }

    final void zzYIv() {
        ArrayList arrayList = new ArrayList();
        for (Style style : this) {
            com.aspose.words.internal.zzX.zzZ(arrayList, style);
        }
        for (Style style : arrayList) {
            style.zzYIP();
        }
        for (Style style : arrayList) {
            style.zzYIO();
        }
    }

    final void zzYIu() {
        for (Style style : this) {
            zzYYX zzYYX2 = style.zzgC();
            zzYYX2.remove(380);
            zzYYX2.remove(340);
            zzYYX2.remove(390);
        }
    }

    final void zze(Document document) {
        zzZMT zzZMT2 = new zzZMT(document, this.getDocument(), 0);
        boolean bl = Theme.zzZ(this.zzZZx.zzZPj(), document.zzZPj());
        for (Style style : this.getDocument().getStyles()) {
            StyleCollection styleCollection = document.getStyles();
            Style style2 = styleCollection.zzs(style);
            if (style2 == null) continue;
            if (style.getStyleIdentifier() == 0) {
                StyleCollection styleCollection2 = styleCollection;
                style.zzY((zzYYX)styleCollection2.zzXY2.zzqw());
                styleCollection2 = styleCollection;
                style.zzZ((zzZ5V)styleCollection2.zzXY1.zzqw());
                style2.zzgC().zzY(style.zzgC());
                style2.zzgE().zzY(style.zzgE());
            } else {
                style.zzY((zzYYX)style2.zzgC().zzqw());
                style.zzZ((zzZ5V)style2.zzgE().zzqw());
                if (style.zzgE().getListId() != 0) {
                    style.zzgE().zzCu(zzZMT2.zzZqb().zzZ(zzZMT2, style2.zzgE().getListId()));
                }
                TableStyle tableStyle = com.aspose.words.internal.zzX.zzZ((Object)style, TableStyle.class);
                TableStyle tableStyle2 = com.aspose.words.internal.zzX.zzZ((Object)style2, TableStyle.class);
                if (tableStyle != null && tableStyle2 != null) {
                    tableStyle.zzZ((zzYSI)tableStyle2.zzgA().zzqw());
                    tableStyle.zzYDO();
                    for (ConditionalStyle conditionalStyle : tableStyle2.getConditionalStyles().zzgu()) {
                        tableStyle.zzY(conditionalStyle.zzgG());
                    }
                }
            }
            if (bl) continue;
            Theme.zzZ(document.zzZPj(), style.zzgC());
        }
    }

    final int zzZ(Style style, zzZMT zzZMT2) {
        int n;
        int n2 = zzZMT2.zzZqa().get(style.zzZz6());
        if (!zzMD.zzVT(n2)) {
            return n2;
        }
        Style style2 = this.zzX(style, zzZMT2);
        if (style2 == null) {
            return 4095;
        }
        if (style.zzYJ4() != 4095) {
            style2.zzs9(this.zzZ(style.zzYIS(), zzZMT2));
        }
        if (style.zzYJ2() != 4095) {
            style2.zzs7(this.zzZ(style.getLinkedStyle(), zzZMT2));
        }
        if (style.zzYJ3() != 4095) {
            style2.zzs8(this.zzZ(style.zzYIR(), zzZMT2));
        }
        if ((style.getType() == 4 || style.getType() == 1) && (n = style.zzgE().getListId()) != 0) {
            style2.zzgE().set(1120, this.getDocument().getLists().zzZ(n, zzZMT2));
        }
        return style2.zzZz6();
    }

    private void zzo(int n, String string) {
        int n2;
        Style style = this.zz6(string, false);
        if (style != null && style.getStyleIdentifier() != n) {
            String string2 = this.zzLi(string);
            style.zz7(string2, true);
        }
        if ((style = this.zzZi(n2 = zzYU9.zzrL(n), true)).getStyleIdentifier() != n) {
            style.zzZm(this.zzYIz(), true);
            this.zzZh(n, true);
        }
    }

    private static void zzO(zzYYX zzYYX2, int n) {
        int n2;
        if (zzYYX2.contains(n) && (n2 = ((Integer)zzYYX2.get(n)).intValue()) == 0) {
            zzYYX2.remove(n);
        }
    }

    private Style zzq(Style style) {
        for (Style style2 : this) {
            if (com.aspose.words.internal.zzX.zzU((Object)style2, style) || !style.zzD(style2)) continue;
            return style2;
        }
        return null;
    }

    private void zzV(Style style, Style style2) {
        if (zzYU9.zzj(style2)) {
            return;
        }
        Style style3 = style.zzYIS();
        if (style3 != null) {
            Style style4 = this.zzs(style3);
            style2.zzs9(style4 != null ? style4.zzZz6() : StyleCollection.zzs1(style2.getType()));
        }
        StyleCollection.zzY(style, style2);
    }

    private int zzY(Style style, zzZMT zzZMT2) {
        style.zzYJ4();
        Style style2 = style.zzYIS();
        int n = zzZMT2.zzZqa().get(style2.zzZz6());
        if (n == Integer.MIN_VALUE) {
            Style style3;
            if (zzYU9.zzj(style2)) {
                style3 = this.zzZh(style2.getStyleIdentifier(), false);
            } else {
                style3 = this.zzs(style2);
                if (style3 == null && zzZMT2.zzZMg() == 2) {
                    style3 = this.zzq(style2);
                }
            }
            if (style3 != null) {
                n = style3.zzZz6();
            }
        }
        if (zzMD.zzVT(n)) {
            return 4095;
        }
        return n;
    }

    private void zzZ(StyleCollection styleCollection, zzZMT zzZMT2) {
        for (Style style : styleCollection) {
            this.zzZ(style, zzZMT2);
        }
    }

    private Style zzX(Style style, zzZMT zzZMT2) {
        Style style2 = this.zzs(style);
        while (style2 != null && style2.getType() != style.getType()) {
            Style style3 = style.getStyles().zzr(style2);
            if (style3 == null) {
                zzX.zzY(this.getDocument().getWarningCallback(), 0, "Cannot copy style {0} because it matches a style of a different type.", style.getName());
                zzZMT2.zzZqa().set(style.zzZz6(), 4095);
                return null;
            }
            StyleCollection.zzT(style2, style3);
            style2 = this.zzs(style);
        }
        if (style2 != null) {
            StyleCollection.zzU(style, style2);
        } else {
            style2 = style.zzYIT();
            if (this.zzXY0.contains(style2.zzZz6())) {
                style2.zzFj(this.zzYIz());
            }
            this.zzw(style2);
        }
        zzZMT2.zzZqa().set(style.zzZz6(), style2.zzZz6());
        return style2;
    }

    private static void zzU(Style style, Style style2) {
        style.getType();
        style2.getType();
        style2.clearCaches();
        StyleCollection.zzT(style, style2);
        style2.zzC(style);
        style2.zzY((zzYYX)style.zzgC().zzqw());
        if (style2.getType() == 2) {
            return;
        }
        style2.zzZ((zzZ5V)style.zzgE().zzqw());
        if (style2.getType() == 3) {
            TableStyle.zzX((TableStyle)style, (TableStyle)style2);
        }
    }

    private static void zzT(Style style, Style style2) {
        StyleCollection styleCollection = style2.getStyles();
        styleCollection.zzx(style2);
        styleCollection.zzXXZ.set(style.getName(), style2);
        for (String string : style.getAliases()) {
            styleCollection.zzXXZ.set(string, style2);
        }
        if (styleCollection.zzXXO != null) {
            if (style.getStyles().zzXXO.containsKey(style)) {
                styleCollection.zzXXO.put(style2, style.getStyles().zzXXO.get(style));
                return;
            }
            com.aspose.words.internal.zzX.zzY(styleCollection.zzXXO, style2);
        }
    }

    private Style zzp(Style style) {
        for (int i = 0; i < this.zzXXZ.getCount(); ++i) {
            Style style2;
            String string = this.zzXXZ.getKey(i);
            if (!zz1O.equals(string, style.getName()) && !zzZE.zzY(style.getAliases(), string) || (style2 = this.zzXXZ.zzVB(i)).getType() != style.getType()) continue;
            return style2;
        }
        return null;
    }

    private void zzYIt() {
        Style style = this.zzZh(153, false);
        if (style == null) {
            return;
        }
        StyleCollection.zzO(style.zzgC(), 190);
        StyleCollection.zzO(style.zzgC(), 350);
        style = this.zzZi(style.zzYJ2(), false);
        if (style == null) {
            return;
        }
        StyleCollection.zzO(style.zzgC(), 190);
        StyleCollection.zzO(style.zzgC(), 350);
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static {
        zzXXV = new Object();
        zzXXT = new Object();
        zzXXR = new Object();
    }
}

