/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Story;
import com.aspose.words.internal.zzX;
import com.aspose.words.zzYXQ;
import com.aspose.words.zzZNS;
import com.aspose.words.zzZOG;

public final class Section
extends CompositeNode<Node>
implements zzZNS {
    private zzYXQ zzYs1;
    private PageSetup zzY3X;
    private HeaderFooterCollection zzY3W;

    public Section(DocumentBase doc) {
        this(doc, new zzYXQ());
    }

    Section(DocumentBase doc, zzYXQ sectPr) {
        super(doc);
        this.zzYs1 = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzY3W == null) {
            this.zzY3W = new HeaderFooterCollection(this);
        }
        return this.zzY3W;
    }

    public final PageSetup getPageSetup() {
        if (this.zzY3X == null) {
            this.zzY3X = new PageSetup(this, this.getDocument().zzZOA(), this.getDocument().getStyles(), new zzZ(this));
        }
        return this.zzY3X;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZ1L();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzRX(!value);
    }

    final zzYXQ zzZ6Z() {
        return this.zzYs1;
    }

    final void zzY(zzYXQ zzYXQ2) {
        this.zzYs1 = zzYXQ2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZ(boolean bl, zzZOG zzZOG2) {
        zzYXQ zzYXQ2;
        Section section = (Section)super.zzZ(bl, zzZOG2);
        section.zzYs1 = zzYXQ2 = (zzYXQ)this.zzYs1.zzqw();
        section.zzY3X = null;
        section.zzY3W = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzV(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzV(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zztm(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZY(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zztm(n) == null;
            }
        }
        return false;
    }

    private void zzV(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzY(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYs1.zzQt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZOA().zzZoS.zzQs(key);
        }
        return zzYXQ.zzPR(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYs1.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZOA().zzZoS.zzS(key, value);
            return;
        }
        this.zzYs1.zzS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYs1.clear();
    }

    final boolean zzYQl() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzZpZ() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzZ
    implements zzZNS {
        private Section zzYrL;

        zzZ(Section section) {
            this.zzYrL = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYQk().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYQk().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYQk().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZNS zzYQk() {
            Document document = zzX.zzZ((Object)this.zzYrL.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYrL;
        }
    }
}

