/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz6D;
import com.aspose.words.internal.zzRE;
import com.aspose.words.zzZHZ;

public abstract class SaveOptions {
    private boolean zzY4G = false;
    private boolean zzY4F = true;
    private boolean zzF0;
    private String zzY4E;
    private boolean zzY4D;
    private boolean zzY4C = false;
    private boolean zzY4B = true;
    private int zzY4A = 1;
    private int zzYSe = 0;
    private int zzDY = 0;
    private String zzY4z = "";
    private boolean zzY4y = true;
    private boolean zzY4x = true;
    private boolean zzY4w;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZtB() {
        return false;
    }

    boolean zzZAM() {
        return true;
    }

    final boolean zzYRb() {
        return this.zzY4F;
    }

    public String getTempFolder() {
        return this.zzY4E;
    }

    public void setTempFolder(String value) {
        this.zzY4E = value;
    }

    public boolean getPrettyFormat() {
        return this.zzF0;
    }

    public void setPrettyFormat(boolean value) {
        this.zzF0 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzY4D;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzY4D = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzY4C;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzY4C = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzY4B;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzY4B = value;
    }

    public int getColorMode() {
        return this.zzDY;
    }

    public void setColorMode(int value) {
        this.zzDY = value;
    }

    public int getDmlRenderingMode() {
        return this.zzY4A;
    }

    public void setDmlRenderingMode(int value) {
        this.zzY4A = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYSe;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYSe = value;
    }

    public String getDefaultTemplate() {
        return this.zzY4z;
    }

    public void setDefaultTemplate(String value) {
        this.zzY4z = value;
    }

    public boolean getUpdateFields() {
        return this.zzY4y;
    }

    public void setUpdateFields(boolean value) {
        this.zzY4y = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzY4w;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzY4w = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzY4G;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzY4G = value;
    }

    final boolean zzYRa() {
        return this.zzY4x;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new zzZHZ();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzFZ(zzRE.zzZZ(zz6D.zzWZ(fileName))));
    }
}

