/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzX;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzZDR;
import com.aspose.words.zzZE8;
import com.aspose.words.zzZEE;
import com.aspose.words.zzZOF;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZOF,
Iterable<T> {
    private CompositeNode zzYyY;
    private DocumentBase zzZXw;
    private boolean zzZ9t;
    private int zzYyX;
    private int zzYyW;
    private Node zzYyV;
    private int zzZG;
    private zzZE8 zzYyU;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZDR(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZDR(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZE8 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYyY = container;
        this.zzZXw = container.getDocument();
        this.zzYyU = matcher;
        this.zzZ9t = isDeep;
        this.invalidate();
    }

    public Node get(int index) {
        try {
            this.zzZby();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYyW == index) {
                return this.zzYyV;
            }
            int n = index - this.zzYyW;
            Node node = this.zzK(this.zzYyV, n);
            if (node != null) {
                this.zzYyW = index;
                this.zzYyV = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZ9t) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYyY.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZ9t) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYyY.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZbz();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZEE(this);
    }

    final <TNode extends Node> zzZEE<TNode> zzZbA() {
        return new zzZEE(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzZbz() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzX.zzZ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzK(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            Ref<Node> ref = new Ref<Node>(node2);
            this.zzZ(ref, bl);
            node2 = ref.get();
            if (node2 != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) throws Exception {
        return this.zzZ(curNode, true);
    }

    private Node zzZ(Ref<Node> ref, boolean bl) throws Exception {
        Node node;
        ref.get();
        do {
            node = ref.get();
            ref.set(this.zzZ9t ? this.zzZ(bl, ref.get()) : (this.zzYyU.zzio() ? this.zzX(bl, ref.get()) : this.zzY(bl, ref.get())));
        } while (ref.get() != null && !this.zzYyU.zzZW(ref.get()));
        return node;
    }

    private Node zzZ(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzYyY);
        }
        return node.previousPreOrder(this.zzYyY);
    }

    private Node zzY(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzYyY) {
                return this.zzYyY.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzYyY) {
            return this.zzYyY.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzX(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzYyY ? this.zzYyY.zzhh() : node.zzZbR();
        } else {
            Node node3 = node2 = node == this.zzYyY ? this.zzYyY.zzhg() : node.zzZbS();
        }
        if (node2 == this.zzYyY.getNextSibling() || node2 == this.zzYyY.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZby() {
        if (this.zzYyX != this.zzZbx()) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.zzYyX = this.zzZbx();
        this.zzYyW = -1;
        this.zzYyV = this.zzYyY;
        this.zzZG = -1;
    }

    private int zzZbx() {
        if (this.zzZXw != null) {
            return this.zzZXw.zzZOJ();
        }
        return 0;
    }

    public int getCount() {
        this.zzZby();
        if (this.zzZG == -1) {
            this.zzZG = zzZEE.zzZ(this);
        }
        return this.zzZG;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYyY;
    }
}

