/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz1O;
import com.aspose.words.internal.zz7N;
import com.aspose.words.internal.zzX;
import com.aspose.words.zz8P;
import com.aspose.words.zzZOG;
import com.aspose.words.zzZQ0;

public abstract class Node
implements Cloneable {
    private Node zzYz7;
    private Node zzYz6;
    private Node zzYz5;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzW(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYz7 == null) {
            return null;
        }
        if (this.zzYz7.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYz7;
    }

    final CompositeNode zzZbW() {
        if (com.aspose.words.zzX.zzy(this.getParentNode())) {
            return this.getParentNode().zzZbW();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYz7 == null) {
            return null;
        }
        return this.zzYz7.getDocument();
    }

    final Document zzZbV() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZbU() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZQd();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYz5;
    }

    final Node zzZbT() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && com.aspose.words.zzX.zzG(node)) {
        }
        return node;
    }

    final Node zzZbS() {
        Node node = com.aspose.words.zzX.zzT(this.getPreviousSibling(), false);
        if (node == null && com.aspose.words.zzX.zzy(this.getParentNode())) {
            node = this.getParentNode().zzZbS();
        }
        return node;
    }

    final Node zzZbR() {
        Node node = com.aspose.words.zzX.zzU(this.getNextSibling(), false);
        if (node == null && com.aspose.words.zzX.zzy(this.getParentNode())) {
            node = this.getParentNode().zzZbR();
        }
        return node;
    }

    final CompositeNode zzZbQ() {
        Node node = this;
        while ((node = node.zzZbS()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZbP() {
        Node node = this;
        while ((node = node.zzZbR()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYz6;
    }

    final Node zzZbO() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && com.aspose.words.zzX.zzG(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZbN() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZbM() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (com.aspose.words.zzX.zzJ(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZbL() {
        return this.zzYz6;
    }

    final void zzYx(Node node) {
        this.zzYz6 = node;
    }

    final Node zzZbK() {
        return this.zzYz5;
    }

    final void zzYw(Node node) {
        this.zzYz5 = node;
    }

    final Node zzZbJ() {
        Node node = this;
        if (node.zzYz6 != null) {
            node = this;
            return node.zzYz6;
        }
        return this.getParentNode();
    }

    final int zzZbI() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = com.aspose.words.zzX.zzA(this);
        boolean bl2 = com.aspose.words.zzX.zzE(this);
        boolean bl3 = com.aspose.words.zzX.zzB(this);
        boolean bl4 = com.aspose.words.zzX.zzC(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZbI() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 36;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZbI() != 3 && n2 != 6 && n != 27 && n != 33)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZOG zzZOG2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYz7 != null) {
            node.zzYz7 = this.getDocument().zzZOI();
        }
        node.zzYz6 = null;
        node.zzYz5 = null;
        if (zzZOG2 != null) {
            zzZOG2.zzT(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzR(StringBuilder stringBuilder) {
        zzX.zzY(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzYv(Node node) {
        this.zzYz7 = node != null ? node : this.getDocument().zzZOI();
    }

    final void zzW(DocumentBase documentBase) {
        this.zzYz7 = documentBase != null ? documentBase.zzZOI() : null;
    }

    final boolean zzYu(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZbH() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzzz(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzzy(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzL(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzTg(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzZQ0 zzZQ02 = com.aspose.words.zzX.zzRk(saveFormat);
        return zzZQ02.zzYO(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZQ0 zzZQ02 = com.aspose.words.zzX.zzZ(saveOptions);
        return zzZQ02.zzYO(this);
    }

    final Node zzzx(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!com.aspose.words.zzX.zzF(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zz8P zzZbG() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zz8P.zzZI(node);
        }
        return zz8P.zzZJ(this.getParentNode());
    }

    final zz8P zzZbF() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zz8P.zzZJ(node);
        }
        return zz8P.zzZI(this.getParentNode());
    }

    final boolean zzYt(Node node) {
        return Node.zzD(this, node);
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    static Node zzE(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zz7N<Node> zz7N2 = Node.zzYs(node);
        zz7N<Node> zz7N3 = Node.zzYs(node2);
        return Node.zzZ(zz7N2, zz7N3);
    }

    static boolean zzD(Node node, Node node2) {
        zz7N<Node> zz7N2;
        if (node == null || node2 == null) {
            return false;
        }
        zz7N<Node> zz7N3 = Node.zzYs(node);
        Node node3 = Node.zzZ(zz7N3, zz7N2 = Node.zzYs(node2));
        if (node3 == null) {
            return false;
        }
        zz7N<Node> zz7N4 = zz7N3;
        if (zz7N4.size() == 0 || (zz7N4 = zz7N2).size() == 0) {
            zz7N4 = zz7N2;
            boolean bl = zz7N4.size() > 0;
            return bl;
        }
        Object e = zz7N3.peek();
        Object e2 = zz7N2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zz7N<Node> zzYs(Node node) {
        zz7N<Node> zz7N2 = new zz7N<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz7N2.push(node2);
        }
        return zz7N2;
    }

    private static Node zzZ(zz7N<Node> zz7N2, zz7N<Node> zz7N3) {
        Node node = null;
        while (zz7N2.peek() == zz7N3.peek()) {
            node = (Node)zz7N2.pop();
            zz7N3.pop();
            zz7N<Node> zz7N4 = zz7N2;
            if (zz7N4.size() != 0 && (zz7N4 = zz7N3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    private String zzZbE() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzX.zzZ(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zz1O.trim(stringBuilder.toString());
    }

    public String toString() {
        return zz1O.trim(zz1O.format("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzZbE()));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

