/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zz0Y;
import com.aspose.words.internal.zz1O;
import com.aspose.words.internal.zz7L;
import com.aspose.words.internal.zzBC;
import com.aspose.words.internal.zzQI;
import com.aspose.words.internal.zzX;
import com.aspose.words.zz8P;
import com.aspose.words.zzYNF;
import com.aspose.words.zzYYX;
import com.aspose.words.zzZDW;
import com.aspose.words.zzZOG;
import com.aspose.words.zzZZ5;

public class FormField
extends SpecialChar {
    private zzZZ5 zzZ2H;
    private Field zzZ2G;
    static String zzZ2F = zz1O.zzV('\u2002', 5);
    private static final zz0Y zzVK = new zz0Y("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZZ5 formFieldPr, zzYYX runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ2H = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZOG zzZOG2) {
        FormField formField = (FormField)super.zzZ(bl, zzZOG2);
        ((FormField)super.zzZ(bl, zzZOG2)).zzZ2H = (zzZZ5)this.zzZ2H.zzqw();
        formField.zzZ2G = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzX.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZbW().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n = FormField.zzOK(this.getTextInputFormat());
                this.setResult(zzBC.zzB((String)newValue, n));
                return;
            }
            case 1: {
                FieldOptions fieldOptions = this.zzZbV().getFieldOptions();
                this.setResult(zzQI.zzZ(zzX.zzW(newValue), this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYNF.zzX((zz7L)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    private static int zzOK(String string) {
        string = string.toLowerCase();
        switch (zzVK.zzVX(string)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private FieldStart zzZDk() {
        int n = 0;
        zz8P zz8P2 = zz8P.zzZJ(this);
        do {
            Node node = zz8P2.getNode();
            switch (node.getNodeType()) {
                case 22: {
                    if (n == 0) {
                        return (FieldStart)node;
                    }
                    --n;
                    break;
                }
                case 24: {
                    ++n;
                }
            }
        } while (zz8P2.zzZ(null, false, true, true, false, false));
        return null;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ2H.getName();
    }

    public void setName(String value) throws Exception {
        zzX.zzZ((Object)value, "value");
        this.zzZ2H.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzZ2H.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZyK() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    final Field getField() {
        FieldStart fieldStart;
        if (this.zzZ2G == null && (fieldStart = this.zzZDk()) != null) {
            this.zzZ2G = fieldStart.getField();
        }
        return this.zzZ2G;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().zzWA(true);
                if (zz1O.equals(string, zzZ2F)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZyJ();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzX.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzQI.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzOJ(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ2H.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ2H.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ2H.zzZyF();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ2H.zzWb(value);
    }

    public String getHelpText() {
        return this.zzZ2H.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ2H.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ2H.zzZyG();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ2H.zzWc(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ2H.zzZyH();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ2H.zzWd(value);
    }

    public String getEntryMacro() {
        return this.zzZ2H.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ2H.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ2H.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ2H.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ2H.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ2H.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ2H.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ2H.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ2H.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ2H.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ2H.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ2H.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzzz(21);
            zzZDW.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZbV());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ2H.zzZyE();
    }

    public void setMaxLength(int value) {
        this.zzZ2H.zzEY(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ2H.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZZ5 zzZZ52 = this.zzZ2H;
        if (zzZZ52.contains(21070)) {
            return this.zzZ2H.zzZyy();
        }
        return this.zzZ2H.zzZyz();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ2H.zzEV(value);
    }

    final String zzZyJ() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzOJ(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzBC.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZZ5 zzZZ52 = this.zzZ2H;
        if (zzZZ52.contains(21010)) {
            return this.zzZ2H.zzZyA();
        }
        return this.zzZ2H.zzZyB();
    }

    public void setChecked(boolean value) {
        this.zzZ2H.zzW8(value);
    }

    public boolean getDefault() {
        return this.zzZ2H.zzZyB();
    }

    public void setDefault(boolean value) {
        this.zzZ2H.zzW9(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ2H.zzZyD();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ2H.zzWa(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ2H.zzZyC();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ2H.zzEX(zzX.zzU(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzX.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzX.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZZ5 zzZyI() {
        return this.zzZ2H;
    }
}

