/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz6C;
import com.aspose.words.internal.zz6F;
import com.aspose.words.internal.zzBC;
import com.aspose.words.internal.zzRE;
import com.aspose.words.internal.zzU;
import com.aspose.words.internal.zzX;
import com.aspose.words.zz0M;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZ5s = new HashMap();
    private static HashMap<Integer, Integer> zzZ5r = new HashMap();
    private static HashMap<Integer, Integer> zzZ5q = new HashMap();
    private static HashMap<Integer, Integer> zzZ5p = new HashMap();
    private static HashMap<Integer, Integer> zzZ5o = new HashMap();
    private static HashMap<Integer, Integer> zzZ5n = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzX.zzZ(fileName, "fileName");
        zz6F zz6F2 = zzX.zzQ(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZN(zz6F2);
            return fileFormatInfo;
        }
        finally {
            ((zz6C)zz6F2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZN(zzU.zzZ(stream));
    }

    static FileFormatInfo zzZN(zz6C zz6C2) throws Exception {
        if (zz6C2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz0M zz0M2 = new zz0M();
            zz6C zz6C3 = zz6C2;
            zz0M zz0M3 = zz0M2;
            return zz0M2.zzY(zz6C3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzFT(zzRE.zz0(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzFZ(zzRE.zz0(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzBC.zzYe(string = zzRE.zzWr(FileFormatUtil.zzFW(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzFT(FileFormatUtil.zzFV(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzFZ(FileFormatUtil.zzFW(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzRE.zzWr(FileFormatUtil.zzFV(saveFormat));
        if (zzBC.zzYe(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzFZ(zzRE.zzZZ(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzRE.zzWr(FileFormatUtil.zzFU(imageType));
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzG0(int n) {
        return zzRE.toString(FileFormatUtil.zzFV(n));
    }

    static int zzFZ(int n) {
        return zzX.zzZ(zzZ5o, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzFY(int n) {
        return zzX.zzZ(zzZ5n, Integer.valueOf(n), Integer.valueOf(1));
    }

    static boolean zzFX(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzFW(int n) {
        return zzX.zzZ(zzZ5s, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzFV(int n) {
        return zzX.zzZ(zzZ5r, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzFU(int n) {
        return zzX.zzZ(zzZ5q, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzFT(int n) {
        return zzX.zzZ(zzZ5p, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzN(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzX.zzY(zzZ5o, Integer.valueOf(n), Integer.valueOf(n2));
            zzX.zzY(zzZ5r, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZ5p.containsKey(n)) {
                zzX.zzY(zzZ5p, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzX.zzY(zzZ5s, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzX.zzY(zzZ5n, Integer.valueOf(n), Integer.valueOf(n4));
            zzX.zzY(zzZ5q, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzN(11, 10, 10, 1);
        FileFormatUtil.zzN(11, 0, 0, 1);
        FileFormatUtil.zzN(12, 11, 11, 1);
        FileFormatUtil.zzN(13, 20, 20, 1);
        FileFormatUtil.zzN(13, 0, 254, 1);
        FileFormatUtil.zzN(14, 21, 21, 1);
        FileFormatUtil.zzN(15, 22, 22, 1);
        FileFormatUtil.zzN(16, 23, 23, 1);
        FileFormatUtil.zzN(18, 24, 24, 1);
        FileFormatUtil.zzN(19, 25, 25, 1);
        FileFormatUtil.zzN(20, 26, 26, 1);
        FileFormatUtil.zzN(21, 27, 27, 1);
        FileFormatUtil.zzN(24, 30, 30, 1);
        FileFormatUtil.zzN(17, 31, 31, 1);
        FileFormatUtil.zzN(25, 50, 50, 1);
        FileFormatUtil.zzN(26, 45, 255, 1);
        FileFormatUtil.zzN(27, 51, 51, 1);
        FileFormatUtil.zzN(28, 0, 52, 1);
        FileFormatUtil.zzN(22, 60, 60, 1);
        FileFormatUtil.zzN(23, 61, 61, 1);
        FileFormatUtil.zzN(32, 40, 255, 1);
        FileFormatUtil.zzN(39, 47, 255, 1);
        FileFormatUtil.zzN(40, 48, 255, 1);
        FileFormatUtil.zzN(33, 41, 255, 1);
        FileFormatUtil.zzN(34, 46, 255, 1);
        FileFormatUtil.zzN(36, 42, 255, 1);
        FileFormatUtil.zzN(35, 44, 255, 1);
        FileFormatUtil.zzN(29, 52, 255, 1);
        FileFormatUtil.zzN(30, 70, 62, 1);
        FileFormatUtil.zzN(31, 73, 63, 1);
        FileFormatUtil.zzN(37, 71, 255, 1);
        FileFormatUtil.zzN(8, 100, 255, 1);
        FileFormatUtil.zzN(9, 105, 255, 1);
        FileFormatUtil.zzN(6, 101, 255, 6);
        FileFormatUtil.zzN(7, 102, 255, 7);
        FileFormatUtil.zzN(5, 104, 255, 5);
        FileFormatUtil.zzN(4, 0, 255, 4);
        FileFormatUtil.zzN(3, 0, 255, 3);
        FileFormatUtil.zzN(38, 72, 255, 1);
        FileFormatUtil.zzN(2, 103, 255, 2);
    }
}

