/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zz1O;
import com.aspose.words.internal.zz6C;
import com.aspose.words.internal.zz6D;
import com.aspose.words.internal.zz6E;
import com.aspose.words.internal.zz7N;
import com.aspose.words.internal.zz9G;
import com.aspose.words.internal.zz9H;
import com.aspose.words.internal.zzAU;
import com.aspose.words.internal.zzBC;
import com.aspose.words.internal.zzYB;
import com.aspose.words.internal.zzYN;
import com.aspose.words.internal.zzYO;
import com.aspose.words.zz2P;
import com.aspose.words.zz2U;
import com.aspose.words.zz7;
import com.aspose.words.zz8S;
import com.aspose.words.zzCW;
import com.aspose.words.zzDL;
import com.aspose.words.zzDR;
import com.aspose.words.zzFJ;
import com.aspose.words.zzHY;
import com.aspose.words.zzM8;
import com.aspose.words.zzX;
import com.aspose.words.zzYE;
import com.aspose.words.zzYNF;
import com.aspose.words.zzYPY;
import com.aspose.words.zzYSI;
import com.aspose.words.zzYT0;
import com.aspose.words.zzYTQ;
import com.aspose.words.zzYU3;
import com.aspose.words.zzYWH;
import com.aspose.words.zzYXQ;
import com.aspose.words.zzYYX;
import com.aspose.words.zzZ5V;
import com.aspose.words.zzZ6U;
import com.aspose.words.zzZ6Y;
import com.aspose.words.zzZFY;
import com.aspose.words.zzZG;
import com.aspose.words.zzZNE;
import com.aspose.words.zzZNU;
import com.aspose.words.zzZNX;
import com.aspose.words.zzZP8;
import com.aspose.words.zzZPY;
import com.aspose.words.zzZR0;
import com.aspose.words.zzZR2;
import com.aspose.words.zzZTO;
import com.aspose.words.zzZUA;
import com.aspose.words.zzZZ5;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzZNU,
zzZNX,
zzZR2 {
    private Document zzZnv;
    private Node zzZm0;
    private Node zzZlZ;
    private zzYYX zzZPX;
    private Font zzZlY;
    private zz7N<zzYYX> zzZlX;
    private zzYSI zzZPW = zzYSI.zzYEn();
    private zzYE zzZVl = new zzYE();
    private RowFormat zzZlW;
    private CellFormat zzZVk;
    private zz7N<zzYT0> zzZlV;
    private int zzZlU = 0;
    private int zzZlT = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzO(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzO(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzO(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.zzZ(this.getCurrentSection(), zzYNF.zzp3(headerFooterType), 0, 0);
    }

    private void zzO(int n, int n2, int n3, int n4) {
        this.zzZnv.ensureMinimum();
        Section section = (Section)this.zzZnv.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYNF.zzp2(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZnv, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZnv));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzW(paragraph, n2);
    }

    final void zzW(Paragraph paragraph, int n) {
        if (n == 0) {
            this.zzY(paragraph, paragraph.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzY(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzZOi().isRemoved() ? zzZFY.zzS(this.zzZnv, fieldName) : zzZFY.zzR(this.zzZOi(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZP8 zzZP82 = field.getFormat().zzZEG();
        Inline inline = zzZP82.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzgC(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZG.zzX(this.zzZnv, bookmarkName) : zzZG.zzW(this.zzZnv, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZbI() == 6) {
            this.zzY((Paragraph)node.zzZbW(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzX.zzu(node);
            if (paragraph == null) {
                return false;
            }
            this.zzY(paragraph, paragraph.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzYo(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzW(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzW(cell.getLastParagraph(), -1);
        }
    }

    private void zzY(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZbI() == 6) {
            this.zzZM(node);
        } else if (zzX.zzG(node)) {
            Paragraph paragraph = zzX.zzu(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzZM(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzZbI() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzZM(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzZOu();
            return;
        }
        if (!this.zzZOv()) {
            this.zzZOu();
        }
    }

    private boolean zzZOv() {
        Node node = this.zzZOi();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzZOi(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ(inline.zzgC(), true);
            return true;
        }
        return false;
    }

    private void zzZOu() {
        this.zzZ(this.getCurrentParagraph().zzZ14(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYo(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZOl() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZOi().zzYu(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZbP();
                this.zzW(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzE(text, false);
    }

    public void writeln(String text) {
        this.zzE(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYTQ zzYTQ2 = new zzYTQ(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZnv, this.zzZOq(), this.zzZOr());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zzZOi(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYTQ2.dispose();
        }
        if (this.getDocument().zzZOU()) {
            zzX.zzX((zzZNE)paragraph, this.getDocument().zzZP0());
        }
        return this.getCurrentParagraph();
    }

    public void insertStyleSeparator() {
        zzYU3.zzU(this);
    }

    public void insertBreak(int breakType) {
        this.zze(breakType, true);
    }

    final void zze(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzX7(bl)) {
                    this.zzRb(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzX7(bl)) {
                    this.zzRb(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzX7(bl)) {
                    this.zzJa(1);
                }
                return;
            }
            case 5: {
                if (this.zzX7(bl)) {
                    this.zzJa(2);
                }
                return;
            }
            case 3: {
                if (this.zzX7(bl)) {
                    this.zzJa(0);
                }
                return;
            }
            case 6: {
                if (this.zzX7(bl)) {
                    this.zzJa(3);
                }
                return;
            }
            case 7: {
                if (this.zzX7(bl)) {
                    this.zzJa(4);
                }
                return;
            }
            case 8: {
                this.zzRb(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzBC.zzYe(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz1O.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX.zzZ(fieldType, updateField, this.zzZOr(), this.zzZOi(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX.zzZ(fieldCode, this.zzZOr(), this.zzZOi(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX.zzZ(fieldCode, fieldValue, this.zzZOr(), this.zzZOi(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        com.aspose.words.internal.zzX.zzZ((Object)displayText, "displayText");
        com.aspose.words.internal.zzX.zzZ((Object)urlOrBookmark, "hrefOrBookmark");
        zz2U zz2U2 = this.zzY(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zz2U2.zzY(documentBuilder.zzd(88, true));
        return zzX.zzZ(zz2U2.getStart(), zz2U2.getSeparator(), zz2U2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzJ9(70);
        if (zzBC.zzYe(name)) {
            this.startBookmark(name);
        }
        this.zzRa(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzJ8(70);
        String string = zzBC.zzYe(fieldValue) ? fieldValue : FormField.zzZ2F;
        Run run = new Run(this.zzZnv, string, this.zzZOr());
        this.insertNode(run);
        this.zzd(70, true);
        if (zzBC.zzYe(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZN(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        return this.insertCheckBox(name, checkedValue, checkedValue, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzJ9(71);
        if (zzBC.zzYe(name)) {
            this.startBookmark(name);
        }
        this.zzRa(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzd(71, false);
        if (zzBC.zzYe(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZN(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzJ9(83);
        if (zzBC.zzYe(name)) {
            this.startBookmark(name);
        }
        this.zzRa(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzd(83, false);
        if (zzBC.zzYe(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZN(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZnv, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX.zzRn(footnoteType));
        if (zzBC.zzYe(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZnv);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX.zzRm(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZnv, '\u0002', new zzYYX()) : new Run(this.zzZnv, footnote.getReferenceMark(), new zzYYX());
        inline.getFont().setStyleIdentifier(zzX.zzRn(footnoteType));
        paragraph.appendChild(inline);
        if (zzBC.zzYe(footnoteText)) {
            Node node = this.zzZOi();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZM(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZU(zz6C zz6C2) throws Exception {
        return this.zzZ(zz6C2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZU(zz6C.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz6C zz6C2, double d, double d2) throws Exception {
        return this.zzZ(zz6C2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz6C.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zz6E zz6E2 = new zz6E();
        try {
            zzYB.zzZ(image, zz6E2);
            Shape shape = this.zzZ(zz6E2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zz6E2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        com.aspose.words.internal.zzX.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzAU.zzXZ(fileName);
        try {
            Shape shape = this.zzZ((zz6C)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz6C)object).close();
            }
        }
    }

    private Shape zzZ(zz6C zz6C2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz6C2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = com.aspose.words.internal.zzX.zzY(zz6C2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz6C.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZnv.getCompatibilityOptions().getMswVersion() > 12 || this.zzZnv.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzZnv, 0);
            zzCW zzCW2 = new zzCW();
            zzCW2.zzZ(zzFJ.zzRz("rect"));
            zzCW2.zzZ(new zzM8());
            zzDL zzDL2 = new zzDL();
            zzDL2.zzY(new zzDR(shape.getId(), ""));
            zzDL2.zzZ(new zzHY());
            zzCW2.zzZ(zzDL2);
            shape.zzHw(75);
            shape.zzU(zzCW2);
        } else {
            shape = new Shape((DocumentBase)this.zzZnv, 75);
        }
        shape.zzY(this.zzZOr());
        if (shape.getImageData().zzZJ(imageBytes)) {
            imageBytes = shape.getImageData().zzZ(imageBytes, new zzYWH(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()));
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzq(width, height);
        return shape;
    }

    private Shape zzH(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz6E zz6E2 = new zz6E();
        try {
            zzYB.zzZ(bufferedImage, zz6E2);
            byArray = com.aspose.words.internal.zzX.zzY(zz6E2);
        }
        finally {
            zz6E2.close();
        }
        return this.zzYX(byArray);
    }

    private Shape zzYX(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZnv, 1);
        shape.zzHw(75);
        shape.zzY(this.zzZOr());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzq(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private Shape zzZ(zz6C zz6C2, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        zzZ6Y zzZ6Y2 = zzZ6Y.zzI5(string);
        Shape shape = bufferedImage != null ? this.zzH(bufferedImage) : this.zzYX(zzZ6U.zzZ(zzZ6Y2, bl));
        shape.zzHw(-2);
        shape.getOleFormat().setProgId(zzZ6Y2.zzYn1);
        shape.getOleFormat().zzY(zzZ6U.zzZ(zz6C2, string, bl));
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        return this.zzZ(zz6C.zzY(stream), progId, asIcon, presentation);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ6Y zzZ6Y2 = zzZ6Y.zzI4(zz6D.zzWZ(fileName));
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ6Y2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ6Y zzZ6Y2 = zzZ6Y.zzI5(progId);
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ6Y2);
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZ6Y zzZ6Y2) throws Exception {
        Shape shape = bufferedImage != null ? this.zzH(bufferedImage) : this.zzYX(zzZ6U.zzZ(zzZ6Y2, bl2));
        shape.zzHw(-2);
        shape.getOleFormat().setProgId(zzZ6Y2.zzYn1);
        shape.getOleFormat().zzY(zzZ6U.zzZ(string, bl, bl2, zzZ6Y2));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzZ(zzZTO zzZTO2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzH(bufferedImage);
        shape.zzHw(201);
        shape.getOleFormat().zzY(zzZTO2.zzZum());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZUA zzZUA2 = new zzZUA();
        zzZUA2.zzW3(useBuilderFormatting);
        zzZUA2.zzW2(useBuilderFormatting);
        this.zzZ(html, zzZUA2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzX.zzZ(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzX.zzZ(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZR0 zzZR02 = new zzZR0();
        return zzZR02.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYPY(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYPY(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZnv, 75);
        shape.zzY(this.zzZOr());
        shape.zzRc(true);
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzq(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public void insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzf(this.zzZnv);
        this.insertNode(shape);
    }

    private void zzZ(String string, zzZUA zzZUA2) throws Exception {
        if (this.zzZOt()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzRc(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZPY zzZPY2 = zzX.zzZ(string, zzZUA2, this);
        zzZPY2.read();
    }

    private boolean zzZOt() {
        boolean bl = false;
        if (this.zzZOi().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZOi().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzRc(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zzZOl() == null) {
            this.startTable();
        }
        if (this.zzZOl().zzYG3() == 1) {
            this.zzZOl().zzYG6();
        }
        if (this.zzZOl().zzYG3() == 3) {
            this.zzZOl().zzYG4();
        }
        return this.zzZOl().zzYG5();
    }

    public Table startTable() {
        this.zzZlV.push(new zzYT0(this));
        return this.zzZOl().startTable();
    }

    public Table endTable() {
        if (this.zzZOl() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZOl().endTable();
        this.zzZlV.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZOl() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZOl().endRow();
        if (this.zzZlY != null && this.zzZlY.getHidden()) {
            row.zzgA().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZnv, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZnv, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZnv);
        this.zzZlT = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZlT == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZnv, this.zzZlT);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZnv, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        com.aspose.words.internal.zzX.zzZ((Object)importFormatOptions, "ImportFormatOptions");
        return zz8S.zzZ(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZnv;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZnv) {
            return;
        }
        this.zzZnv = value;
        this.zzZM(null);
        this.zzZPX = new zzYYX();
        this.zzZlX = null;
        this.zzZlY = null;
        this.zzZlV = new zz7N();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZlY == null) {
            this.zzZlY = new Font(this, this.getDocument());
        }
        return this.zzZlY;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZlW == null) {
            this.zzZlW = new RowFormat(this);
        }
        return this.zzZlW;
    }

    public CellFormat getCellFormat() {
        if (this.zzZVk == null) {
            this.zzZVk = new CellFormat(this);
        }
        return this.zzZVk;
    }

    final void zzZO(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        this.zzZOj().push(this.zzZOr());
    }

    public void popFont() {
        zz7N<zzYYX> zz7N2 = this.zzZOj();
        if (zz7N2.size() > 0) {
            this.zzZ((zzYYX)this.zzZOj().pop(), false);
        }
    }

    private zz2U zzY(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzJ9(88);
        zz2P zz2P2 = new zz2P();
        zz2P2.setTarget(string2);
        zz2P2.setScreenTip(string3);
        if (bl) {
            zz2P2.setSubAddress(string);
        } else {
            zz2P2.setAddress(zz9G.zzXL(string));
            zz2P2.setSubAddress(zz9G.zzXK(string));
        }
        this.zzRa(zz2P2.toString());
        FieldSeparator fieldSeparator = this.zzJ8(88);
        return new zz2U(fieldStart, fieldSeparator, null);
    }

    final zz2U zzQ(String string, String string2, String string3) {
        boolean bl = zz9G.zzXC(string);
        String string4 = bl ? zz9G.zzXK(string) : string;
        return this.zzY(string4, bl, string2, string3);
    }

    final FieldEnd zzZOs() {
        return this.zzd(88, true);
    }

    final zzYYX zzZOr() {
        return (zzYYX)this.zzZPX.zzqw();
    }

    final zzZ5V zzZOq() {
        return (zzZ5V)this.getCurrentParagraph().zzgE().zzqw();
    }

    final zzYSI zzZOp() {
        return (zzYSI)this.zzgA().zzqw();
    }

    final zzYE zzZOo() {
        return (zzYE)this.zznj().zzqw();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZOi(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZOi().getNodeType() == 8;
    }

    private void zzE(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYNF.zzDW(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzR9(string2.substring(n, n + n2));
                }
                switch (this.zzZlU) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzRb(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzR9(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzRb(String string) {
        Run run = new Run(this.zzZnv, string, this.zzZOr());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zzZOl() != null && this.zzZOl().zzYG3() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzZOi().getParentNode().insertBefore(node, this.zzZOi());
    }

    final void zzJb(int n) {
        this.zzX7(true);
        this.zzJa(n);
    }

    private void zzJa(int n) {
        this.insertParagraph();
        zzYTQ zzYTQ2 = new zzYTQ(this.getDocument());
        try {
            zzYXQ zzYXQ2 = (zzYXQ)this.getCurrentSection().zzZ6Z().zzqw();
            Section section = new Section(this.zzZnv, zzYXQ2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZnv));
            this.zzZnv.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYTQ2.dispose();
        }
    }

    final FieldStart zzJ9(int n) {
        return zzX.zzZ(n, this.zzZOr(), this.zzZOi(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzRa(String string) {
        return zzX.zzY(string, this.zzZOr(), this.zzZOi(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzd(int n, boolean bl) {
        return zzX.zzY(n, bl, this.zzZOr(), this.zzZOi(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzJ8(int n) {
        return zzX.zzY(n, this.zzZOr(), this.zzZOi(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZN(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZnv, new zzZZ5(), this.zzZOr());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzX7(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZOl() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYo(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzR9(String string) {
        if (this.zzR8(string)) {
            zzYO zzYO10 = new zzYO(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYN zzYN10 : zzYO10.zzI(this.getParagraphFormat().getBidi())) {
                zz7 zz710 = zz7.zzZc(zzYN10.zzYe());
                zzYYX zzYYX2 = this.zzZOr();
                zzYYX2.zzS(265, zz710);
                if (zzYN10.zzYb()) {
                    zzYYX2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZnv, zzYN10.getText(), zzYYX2);
                this.insertNode(run);
            }
            return;
        }
        this.zzRb(string);
    }

    private boolean zzR8(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zz9H.zzi(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 3 || n == 4;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzZ(zzYYX zzYYX2, boolean bl) {
        this.zzZPX = bl ? (zzYYX)zzYYX2.zzqw() : zzYYX2;
    }

    final void zzZOn() {
        this.zzZPX.clear();
    }

    final void zzZOm() {
        if (this.zzZOk() != null) {
            zzYE zzYE2 = this.zzZOk().zznj();
            this.zzZVl = (zzYE)zzYE2.zzqw();
            zzYE2.zzV(this.zzZVl);
        }
    }

    final boolean zzZWm() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final void zzJ7(int n) {
        this.zzZlU = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzZOi();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZOi();
        }
        return (Paragraph)this.zzZOi().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYT0 zzZOl() {
        zz7N<zzYT0> zz7N2 = this.zzZlV;
        if (zz7N2.size() > 0) {
            return (zzYT0)this.zzZlV.peek();
        }
        return null;
    }

    private Cell zzZOk() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZF4();
    }

    private zz7N<zzYYX> zzZOj() {
        if (this.zzZlX == null) {
            this.zzZlX = new zz7N();
        }
        return this.zzZlX;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZPX.zzQt(fontAttr);
    }

    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZPX.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZk(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZk(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZPX.zzS(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZ0S()) {
            this.getCurrentParagraph().zzZ14().zzS(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZPX.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZPX.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZ0S()) {
            this.getCurrentParagraph().zzZ14().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzgA().zzQt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzgA().zzQs(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzgA().zzQr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzgA().zzS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzgA().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzgA().clear();
        zzYSI.zzYEn().zzY(this.zzgA());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zznj().zzQt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zznj().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zznj().zzQr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = com.aspose.words.internal.zzX.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZOk() != null ? this.zzZOk().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zznj().zzS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zznj().clear();
    }

    private Node zzZOi() {
        Node node = this.zzZm0 != null && this.zzZm0.getParentNode() == null ? this.zzZlZ : this.zzZm0;
        if (node != null && node.zzZbI() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzZM(Node node) {
        this.zzZm0 = node;
        if (this.zzZm0 != null) {
            this.zzZlZ = this.zzZm0.getParentNode();
        }
    }

    private zzYSI zzgA() {
        if (this.zzZOl() != null && this.zzZOl().zzYG3() == 1) {
            return this.zzZPW;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzgA();
        }
        return this.zzZPW;
    }

    private zzYE zznj() {
        if (this.zzZOl() != null && this.zzZOl().zzYG3() != 3) {
            return this.zzZVl;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZF4().zznj();
        }
        return this.zzZVl;
    }
}

