/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz1G;
import com.aspose.words.internal.zz6C;
import com.aspose.words.internal.zz6E;
import com.aspose.words.internal.zz6F;
import com.aspose.words.internal.zzIF;
import com.aspose.words.internal.zzIH;
import com.aspose.words.internal.zzIJ;
import com.aspose.words.internal.zzRD;
import com.aspose.words.internal.zzUX;
import com.aspose.words.internal.zzX;
import com.aspose.words.internal.zzZPS;
import com.aspose.words.zz0M;
import com.aspose.words.zzNR;
import com.aspose.words.zzYMY;
import com.aspose.words.zzYWM;
import com.aspose.words.zzZ6M;
import com.aspose.words.zzZ6N;
import com.aspose.words.zzZ6O;
import com.aspose.words.zzZ6P;
import com.aspose.words.zzZ95;
import com.aspose.words.zzZ98;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZ(zz6C zz6C2, zz6C zz6C3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzX.zzZ((Object)zz6C2, "srcStream");
        zzX.zzZ((Object)zz6C3, "dstStream");
        zzX.zzZ((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzY(zz6C2, zz6C3, certificateHolder, signOptions);
        zz6C3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZ(zz6C.zzY(srcStream), (zz6C)zz6C.zzY(dstStream), certHolder, signOptions);
    }

    private static void zzY(zz6C zz6C2, zz6C zz6C3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzX(digitalSignature);
        }
        if (zz0M.zzZO(zz6C2)) {
            DigitalSignatureUtil.zzZ(zz6C2, zz6C3, digitalSignature, true);
            return;
        }
        zz0M zz0M2 = new zz0M();
        zz6C zz6C4 = zz6C2;
        zz0M zz0M3 = zz0M2;
        FileFormatInfo fileFormatInfo = zz0M2.zzY(zz6C4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzRD zzRD2 = new zzRD(zz6C2);
                int n = fileFormatInfo.zzZBs() == 1 ? 1 : 2;
                zzYWM.zzZ(zzRD2, digitalSignature, n);
                zz6C3.setLength(0L);
                zzRD2.zzM(zz6C3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZ(fileFormatInfo.zzZBr(), zz6C3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZ(zz6C2, zz6C3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzZ(zz6C2, zz6C3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzX.zzZ(srcFileName, "srcFileName");
        zzX.zzZ(dstFileName, "dstFileName");
        zz6F zz6F2 = zzX.zzY(srcFileName, 3, 1);
        try {
            zz6F zz6F3 = zzX.zzY(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzZ((zz6C)zz6F2, (zz6C)zz6F3, certHolder, signOptions);
            }
            finally {
                zz6F3.close();
            }
            return;
        }
        finally {
            zz6F2.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zz1G zz1G2 = zz6C.zzY(dstStream);
        zz6C zz6C2 = zz6C.zzY(srcStream);
        DigitalSignatureUtil.zzZ(zz6C2, (zz6C)zz1G2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zz6F zz6F2 = zzX.zzY(srcFileName, 3, 1);
        try {
            zz6F zz6F3 = zzX.zzY(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzW(zz6F2, zz6F3);
            }
            finally {
                zz6F3.close();
            }
            return;
        }
        finally {
            zz6F2.close();
        }
    }

    private static void zzW(zz6C zz6C2, zz6C zz6C3) throws Exception {
        zz0M zz0M2 = new zz0M();
        zz6C zz6C4 = zz6C2;
        zz0M zz0M3 = zz0M2;
        FileFormatInfo fileFormatInfo = zz0M2.zzY(zz6C4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzRD zzRD2 = new zzRD(zz6C2);
                zzRD2.zzNk().remove("_xmlsignatures");
                zzRD2.zzNk().remove("_signatures");
                zz6C3.zzl(0L);
                zzRD2.zzM(zz6C3);
                zz6C3.setLength(zz6C3.getPosition());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzIJ zzIJ2 = new zzIJ(zz6C2);
                zzIH zzIH2 = zzIJ2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzIH2 != null) {
                    for (zzIF zzIF2 : zzIH2.zzFb()) {
                        String string = zzIH2.zzZ(zzIF2);
                        zzIJ2.zzFc().remove(string);
                    }
                    zzIJ2.zzFc().remove(zzIH2.getName());
                    zzIF zzIF3 = zzIJ2.zzFb().zzYK("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzIJ2.zzFb().remove(zzIF3.getId());
                    zzIJ2.zzFf();
                }
                zz6C3.zzl(0L);
                zzIJ2.zzM(zz6C3);
                zz6C3.setLength(zz6C3.getPosition());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzW(zz6C.zzY(srcStream), zz6C.zzY(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zz6F zz6F2 = zzX.zzY(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzZY(zz6F2);
            return digitalSignatureCollection;
        }
        finally {
            zz6F2.close();
        }
    }

    private static DigitalSignatureCollection zzZY(zz6C zz6C2) throws Exception {
        if (zz0M.zzZO(zz6C2)) {
            return DigitalSignatureUtil.zzZX(zz6C2);
        }
        zz0M zz0M2 = new zz0M();
        zz6C zz6C3 = zz6C2;
        zz0M zz0M3 = zz0M2;
        FileFormatInfo fileFormatInfo = zz0M2.zzY(zz6C3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zz6C2);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzZY(zz6C.zzY(stream));
    }

    static zz6E zzZ(zzRD zzRD2, String string) throws Exception {
        zzNR zzNR2 = new zzNR(zzRD2);
        if (zzNR2.zzbi()) {
            zz6E zz6E2 = zzNR2.zzU8(string);
            return zz6E2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    private static void zzZ(zz6C zz6C2, zz6C zz6C3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzIJ zzIJ2 = new zzIJ(zz6C2);
        zzZ6O zzZ6O2 = bl ? new zzZ6M(zzIJ2) : new zzZ6N(zzIJ2);
        zzZ6O2.zzY(digitalSignature);
        zz6C3.setLength(0L);
        zzIJ2.zzM(zz6C3);
    }

    private static void zzZ(zz6C zz6C2, zz6C zz6C3, DigitalSignature digitalSignature) throws Exception {
        zzZ98 zzZ982 = new zzZ98(zz6C2);
        zzZ95 zzZ952 = new zzZ95(zzZ982);
        zzZ952.zzY(digitalSignature);
        zz6C3.setLength(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zz6C zz6C4 = zz6C3;
        zzZ98 zzZ983 = zzZ982;
        zzZ983.zzZ(zz6C4, string, null);
    }

    private static void zzZ(zzRD zzRD2, zz6C zz6C2, DigitalSignature digitalSignature, String string) throws Exception {
        zz6E zz6E2 = DigitalSignatureUtil.zzZ(zzRD2, string);
        zz6E zz6E3 = new zz6E();
        DigitalSignatureUtil.zzZ((zz6C)zz6E2, (zz6C)zz6E3, digitalSignature, false);
        zzRD zzRD3 = zzNR.zzX(zz6E3, string);
        zzRD3.zzM(zz6C2);
    }

    private static DigitalSignatureCollection zzZX(zz6C zz6C2) throws Exception {
        zz6C2.zzl(0L);
        zzIJ zzIJ2 = new zzIJ(zz6C2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzIH zzIH2 = zzIJ2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzIH2 != null) {
            for (zzIF zzIF2 : zzIH2.zzFb()) {
                String string = zzIH2.zzZ(zzIF2);
                zzIH zzIH3 = zzIJ2.zzYP(string);
                zzIH zzIH4 = zzIJ2.zzZ(zzIH3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZPS zzZPS2 = zzUX.zzv(zzIH4.zzF9().toArray());
                zzYMY.zzZ(zzIH3.zzTD(), zzZPS2, new zzZ6P(zzIJ2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

