/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzX;
import com.aspose.words.zzZDW;
import com.aspose.words.zzZEE;
import com.aspose.words.zzZOF;
import com.aspose.words.zzZOG;
import com.aspose.words.zzZOV;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZOF,
Iterable<T> {
    private Node zzZQv;
    private Node zzZQu;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzhk() {
        return this.zzhh() != null;
    }

    final boolean zzhj() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzhi() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof zzZOV)) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZQv;
    }

    public Node getLastChild() {
        return this.zzZQu;
    }

    final Node zzhh() {
        return zzX.zzU(this.getFirstChild(), false);
    }

    final Node zzhg() {
        return zzX.zzT(this.getLastChild(), false);
    }

    final CompositeNode zzhf() {
        return (CompositeNode)zzX.zzU(this.getFirstChild(), true);
    }

    final CompositeNode zzhe() {
        return (CompositeNode)zzX.zzT(this.getLastChild(), true);
    }

    final Node zzhd() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzX.zzG(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzhc() {
        Node node;
        for (node = this.getLastChild(); node != null && zzX.zzG(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ(boolean bl, zzZOG zzZOG2) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ(bl, zzZOG2);
        ((CompositeNode)super.zzZ(bl, zzZOG2)).zzZQu = null;
        compositeNode.zzZQv = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZR(node.zzZ(true, zzZOG2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzR(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzR(StringBuilder stringBuilder) {
        this.zzQ(stringBuilder);
        com.aspose.words.internal.zzX.zzY(stringBuilder, this.zzhb());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzY(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzX.zzR4(nodeType);
            Node node2 = node = bl ? this.zzhh() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZbR() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzX.zzZ((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzX.zzY((Node)this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZEE(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ(oldChild, this, null, 1);
        if (documentBase.zzZOU() && zzX.zzj(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        Node node = this.zzZQ(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzZDW.zzj(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZR(Node node) {
        node.getParentNode();
        if (this.zzZQu == null) {
            node.zzYw(null);
            node.zzYx(null);
            this.zzZQv = node;
        } else {
            node.zzYw(this.zzZQu);
            node.zzYx(null);
            this.zzZQu.zzYx(node);
        }
        this.zzZQu = node;
        node.zzYv(this);
        return node;
    }

    final void zzZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzP(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzX.zzG(node2)) continue;
            if (zzX.zzY(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzhb().length();
    }

    String zzhb() {
        return "";
    }

    final String zzha() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzQ(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzQ(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzR(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY(visitor));
    }

    abstract int zzZ(DocumentVisitor var1) throws Exception;

    abstract int zzY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZY(Node var1);

    final Node zzZ(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYu(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzZY(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
            if (!node.isRemoved()) {
                node.getParentNode().zzZQ(node);
            }
        }
        if ((nodeChangingArgs = documentBase.zzZ(node, null, this, 0)) != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (this.zzZQu == null) {
            node.zzYw(null);
            node.zzYx(null);
            this.zzZQv = node;
            this.zzZQu = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzV(node, node2);
            } else {
                this.zzU(node, this.zzZQv);
            }
        } else if (node2 != null) {
            this.zzU(node, node2);
        } else {
            this.zzV(node, this.zzZQu);
        }
        node.zzYv(this);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        if (documentBase.zzZOU()) {
            zzX.zzk(node);
        }
        return node;
    }

    private void zzV(Node node, Node node2) {
        Node node3 = node2.zzZbL();
        node.zzYw(node2);
        node.zzYx(node3);
        node2.zzYx(node);
        if (node3 == null) {
            this.zzZQu = node;
            return;
        }
        node3.zzYw(node);
    }

    private void zzU(Node node, Node node2) {
        Node node3 = node2.zzZbK();
        node.zzYw(node3);
        node.zzYx(node2);
        node2.zzYw(node);
        if (node3 == null) {
            this.zzZQv = node;
            return;
        }
        node3.zzYx(node);
    }

    private Node zzZQ(Node node) {
        if (node == this.zzZQv) {
            if (this.zzZQv == this.zzZQu) {
                this.zzZQv = null;
                this.zzZQu = null;
            } else {
                this.zzZQv = node.zzZbL();
                this.zzZQv.zzYw(null);
            }
        } else {
            Node node2 = node.zzZbK();
            Node node3 = node.zzZbL();
            node2.zzYx(node3);
            if (node3 == null) {
                this.zzZQu = node2;
            } else {
                node3.zzYw(node2);
            }
        }
        node.zzYx(null);
        node.zzYw(null);
        node.zzYv(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) {
        Node node = curNode.get();
        curNode.set(curNode.get() == this ? this.getFirstChild() : curNode.get().getNextSibling());
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

