/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zz7L;
import com.aspose.words.internal.zzX;
import com.aspose.words.zzAT;
import com.aspose.words.zzBW;
import com.aspose.words.zzDF;
import com.aspose.words.zzE0;
import com.aspose.words.zzIB;
import com.aspose.words.zzIW;
import com.aspose.words.zzIZ;
import com.aspose.words.zzJR;
import com.aspose.words.zzLU;
import com.aspose.words.zzZQU;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzLU zzZUf;

    ChartSeriesCollection(zzLU dmlChart) {
        this.zzZUf = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZUf.zz8R().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZUf.zz8R().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZUf.zz8R().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZUf.zz8R().clear();
        this.zzYL(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, values);
        chartSeries.zzk2().zzZ(ChartSeriesCollection.zzQ(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzk2().zzZ(ChartSeriesCollection.zzW(xValues));
        return chartSeries;
    }

    private ChartSeries zzZ(String string, zz7L[] zz7LArray, double[] dArray) {
        if (zz7LArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zz7LArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zz7LArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZ(string, dArray);
        chartSeries.zzk2().zzZ(ChartSeriesCollection.zzZ(zz7LArray));
        if (!this.zzZUf.zz8L()) {
            this.zzYL(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZ(seriesName, zz7L.zzZ(dates), values);
    }

    private void zzYL(boolean bl) {
        zzZQU zzZQU2 = zzX.zzZ((Object)this.zzZUf, zzZQU.class);
        if (zzZQU2 != null && zzZQU2.zz9T().zzkX()) {
            zzZQU2.zz9T().zzlm().zzM(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZUf.zz9Y() != 15) {
            this.zzZUf.zzT(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZ(seriesName, yValues);
        chartSeries.zzkc().zzkn().zzM(3, this.zzZUf.zz8O());
        chartSeries.zzk2().zzZ(ChartSeriesCollection.zzW(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzjX().zzZ(ChartSeriesCollection.zzW(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzZ(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZUf);
        chartSeries.setName(string);
        this.zzR(chartSeries);
        chartSeries.setIndex(this.zzZUf.zz8R().size());
        chartSeries.zzPu(chartSeries.getIndex());
        chartSeries.zzk0().zzZ(ChartSeriesCollection.zzW(dArray));
        chartSeries.zzk1().zzZ(chartSeries.zzk0().zz7m());
        this.zzZUf.zzO(chartSeries);
        return chartSeries;
    }

    private void zzR(ChartSeries chartSeries) {
        chartSeries.zzkc().zzkn().zzM(5, new zzIZ());
        switch (this.zzZUf.zz9Y()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZ(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzZ(chartSeries, 5);
                ChartSeriesCollection.zzP(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzZ(chartSeries, 1);
                ChartSeriesCollection.zzP(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzQ(chartSeries);
            }
        }
    }

    private static void zzQ(ChartSeries chartSeries) {
        zzIZ zzIZ2 = new zzIZ();
        zzIZ2.zzY(new zzDF());
        zzBW zzBW2 = new zzBW();
        zzBW2.setValue(1);
        zzIZ2.zzaZ().zzY(new zzAT(zzBW2));
        zzIZ2.zzaZ().zzYy(19050.0);
        chartSeries.zzkc().zzkn().zzM(5, zzIZ2);
    }

    private static void zzP(ChartSeries chartSeries) {
        zzIZ zzIZ2 = new zzIZ();
        zzIZ2.zzY(new zzDF());
        zzIZ2.zzaZ().zzY(new zzE0());
        zzIZ2.zzaZ().setEndCap(0);
        zzIZ2.zzaZ().zzYy(19050.0);
        chartSeries.zzkc().zzkn().zzM(5, zzIZ2);
    }

    private static void zzZ(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzke().zzM(0, n);
        chartSeries.zzkc().zzkn().zzM(4, chartMarker);
    }

    private static zzIB zzW(double[] dArray) {
        int n = 0;
        zzIB zzIB2 = new zzIB(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzIB2.zzR(new zzJR(n, d, "General"));
            }
            ++n;
        }
        zzIB2.zzMR(dArray.length);
        zzIB2.zz1k();
        return zzIB2;
    }

    private static zzIB zzZ(zz7L[] zz7LArray) {
        int n = 0;
        zzIB zzIB2 = new zzIB(2, false);
        zz7L[] zz7LArray2 = zz7LArray;
        int n2 = zz7LArray.length;
        for (int i = 0; i < n2; ++i) {
            zz7L zz7L2 = zz7LArray2[i];
            zzIB2.zzR(new zzJR(n++, zz7L2.zzwe(), "m/d/yyyy"));
        }
        zzIB2.zzMR(zz7LArray.length);
        zzIB2.zz1k();
        return zzIB2;
    }

    private static zzIB zzQ(String[] stringArray) {
        int n = 0;
        zzIB zzIB2 = new zzIB(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzIB2.zzR(new zzIW(n++, string));
        }
        zzIB2.zzMR(stringArray.length);
        zzIB2.zz1k();
        return zzIB2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZUf.zz8R().size();
    }
}

