/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzTO;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZR3;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzZR3 zzZXd;

    BorderCollection(zzZR3 parent) {
        this.zzZXd = parent;
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzZXd.getPossibleBorderKeys().zzZ(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzZXd.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzZXd, borderKey);
            this.zzZXd.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzZXd.getPossibleBorderKeys().zzwq().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzZXd.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzZXd.getPossibleBorderKeys().zzwq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzQ6(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzZXd.getPossibleBorderKeys().zzwq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzQ6(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzp2().zzSD();
    }

    public final void setColor(Color value) throws Exception {
        this.zzr(zzTO.zzV(value));
    }

    private zzTO zzp2() throws Exception {
        return this.get(0).zzp2();
    }

    private void zzr(zzTO zzTO2) throws Exception {
        Iterator iterator = this.zzZXd.getPossibleBorderKeys().zzwq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzQ6(n)) continue;
            this.getByBorderType(n).zzr(zzTO2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzZXd.getPossibleBorderKeys().zzwq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzQ6(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzZXd.getPossibleBorderKeys().zzwq().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzQ6(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzZ(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzQ6(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZ
    implements Iterator<Border> {
        private BorderCollection zzZWX;
        private int zzZWW;

        zzZ(BorderCollection borderCollection) {
            this.zzZWX = borderCollection;
            this.zzZWW = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZWW >= this.zzZWX.getCount() - 1) {
                return false;
            }
            ++this.zzZWW;
            return true;
        }

        private Border zzoN() {
            try {
                return this.zzZWX.get(this.zzZWW);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzoN();
        }
    }
}

