/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.IWarningCallback;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.Section;
import com.aspose.words.Table;
import com.aspose.words.WarningInfo;
import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzWri;
import com.aspose.words.internal.zzX79;
import com.aspose.words.internal.zzYIW;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.zzWXJ;
import com.aspose.words.zzX5M;
import com.aspose.words.zzYQ2;
import com.aspose.words.zzYd7;
import com.aspose.words.zzYei;
import com.aspose.words.zzZd4;

final class zzVOU {
    private zzWri<Table> zzVTD = new zzWri();
    private boolean zzXdh;
    private boolean zzWLs;
    private boolean zzWdR;
    private static int zzZws = zzZ23.zzWCX(ConvertUtil.millimeterToPoint(1.0));
    private IWarningCallback zzWch;

    zzVOU(int n, IWarningCallback iWarningCallback) {
        this.zzWdR = (n & 0x800) != 0;
        this.zzXdh = (n & 0x20) != 0;
        this.zzWLs = (n & 0x100) != 0;
        this.zzWch = iWarningCallback;
    }

    final int visitTableStart(Table table) throws Exception {
        if (table.zzZyk()) {
            if (this.zzXdh) {
                boolean bl = false;
                for (Row row : table.getRows()) {
                    for (Cell cell : row.getCells()) {
                        bl |= cell.zzXe3().zzYrY();
                    }
                }
                if (bl) {
                    this.zzZ5Y(table);
                }
                table.zzY9q();
            } else {
                zzZd4 zzZd42 = new zzZd4(table);
                if (zzZd42.zzkN().length == 0) {
                    this.zzZ5Y(table);
                }
            }
            table.zzVQa();
            this.zzXoI(table);
            zzVOU.zzN0(table);
        }
        return 0;
    }

    private boolean zzZ5Y(Table table) {
        if (this.zzVTD.contains(table)) {
            return false;
        }
        table.zzWkC();
        this.zzVTD.add(table);
        return true;
    }

    private static void zzN0(Table table) throws Exception {
        if (table.getFirstRow() == null) {
            return;
        }
        zzYQ2 zzYQ22 = table.getFirstRow().zzXr5();
        if (!zzVOU.zzXU4(zzYQ22)) {
            int n = 0;
            Document document = zzYQ22.getVerticalAlignment() == 5 ? zzZ23.zzWGp((Object)table.getDocument(), Document.class) : null;
            if (document != null && !document.getCompatibilityOptions().zzYRQ()) {
                n = -2;
            }
            table.zzkv(4190, n);
            table.zzZzX(4200);
        }
    }

    private static boolean zzXU4(zzYQ2 zzYQ22) {
        if (zzYQ22.getRelativeVerticalPosition() != 2) {
            return true;
        }
        return zzYQ22.getVerticalAlignment() == -1 || zzYQ22.getVerticalAlignment() == 0;
    }

    final int visitRowStart(Row row) {
        IWarningCallback iWarningCallback;
        String string;
        Object[] objectArray;
        if (this.zzWdR && row.getCells().getCount() > 63) {
            throw new IllegalStateException("More than 63 cells per row is not supported for this file format.");
        }
        if (row.zzXr5().zzWk0() > 31680) {
            row.zzXr5().zzWnx(31680);
            objectArray = new Object[]{};
            string = "Table row height exceed maximum allowed, corrected.";
            iWarningCallback = this.zzWch;
            zzYei.zzWGp(iWarningCallback, 0, string, objectArray);
        }
        if (row.getCells().getCount() >= 63) {
            objectArray = new Object[]{};
            string = "Cell count per row must not exceed 63, document can have problem while opened in MS Word.";
            iWarningCallback = this.zzWch;
            zzYei.zzWGp(iWarningCallback, 0, string, objectArray);
        }
        zzX5M.zzZuT(row);
        zzVOU.zzWW(row);
        return 0;
    }

    static void zzWW(Row row) {
        zzVOU.zzWGp(row.zzXr5(), 5104);
        zzVOU.zzWGp(row.zzXr5(), 5105);
    }

    private static void zzWGp(zzYQ2 zzYQ22, int n) {
        Object object = zzYQ22.zzYx3(n);
        if (object != null && (Integer)object < 0) {
            zzVQq.zz2z("Invalid value {0} of attribute {1} removed from a row.", object, n);
            zzYQ22.remove(n);
        }
    }

    final int visitTableEnd(Table table) {
        if (table.getFirstRow() == null) {
            this.zzVTF(65536, "Empty table was removed.");
            table.remove();
        }
        return 0;
    }

    final int visitRowEnd(Row row) {
        Cell cell;
        if (row.getFirstCell() == null) {
            this.zzVTF(65536, "Empty table row was removed.");
            row.remove();
            return 0;
        }
        Cell cell2 = row.getFirstCell();
        if (cell2.zzXe3().getHorizontalMerge() == 2) {
            cell2.zzXe3().setHorizontalMerge(1);
        }
        if ((cell = row.getLastCell()).zzXe3().getHorizontalMerge() == 1) {
            cell.zzXe3().setHorizontalMerge(0);
        }
        zzVOU.zzZp7(row);
        zzVOU.zzXit(row.zzXr5());
        return 0;
    }

    private static void zzXit(zzYQ2 zzYQ22) {
        if (zzYQ22.getHorizontalAlignment() == 1) {
            zzYQ22.remove(4180);
        }
        if (!zzYQ22.zzAl()) {
            zzYQ22.remove(4160);
            zzYQ22.remove(4210);
            zzYQ22.remove(4220);
            zzYQ22.remove(4270);
            zzYQ22.remove(4280);
        }
    }

    private static void zzZp7(Row row) {
        zzYQ2 zzYQ22;
        zzYd7 zzYd72;
        boolean bl = true;
        boolean bl2 = true;
        for (Cell cell : row.getCells()) {
            bl &= cell.getLastParagraph().zzZeP().zzZgz();
            bl2 &= cell.getLastParagraph().zzZeP().zzdF();
        }
        if (bl && !row.zzXr5().zzZgz()) {
            zzYd72 = new zzYd7(0, row.getFirstCell().getLastParagraph().zzZeP().getInsertRevision().getAuthor(), row.getFirstCell().getLastParagraph().zzZeP().getInsertRevision().zzJI());
            zzYQ22 = row.zzXr5();
            zzYQ22.zzXIh(14, zzYd72);
        }
        if (bl2 && !row.zzXr5().zzdF()) {
            zzYd72 = new zzYd7(1, row.getFirstCell().getLastParagraph().zzZeP().getDeleteRevision().getAuthor(), row.getFirstCell().getLastParagraph().zzZeP().getDeleteRevision().zzJI());
            zzYQ22 = row.zzXr5();
            zzYQ22.zzXIh(12, zzYd72);
        }
    }

    final int visitCellStart(Cell cell) throws Exception {
        if (this.zzWLs && !cell.zzXe3().zzEa(3020)) {
            cell.zzXe3().setPreferredWidth(PreferredWidth.AUTO);
        }
        cell.ensureMinimum();
        if (cell.zzXe3().zzYrY()) {
            this.zzVTF(65536, "Invalid cell width, table layout updated.");
            Cell cell2 = cell;
            if (this.zzZ5Y(cell2.getParentRow().getParentTable())) {
                cell2 = cell;
                this.zzXoI(cell2.getParentRow().getParentTable());
            }
        }
        zzVOU.zzZPq(cell);
        zzX5M.zzv9(cell);
        return 0;
    }

    private static void zzZPq(Cell cell) {
        zzWXJ zzWXJ2 = cell.zzXe3();
        zzVOU.zzXfK(zzWXJ2, 3090);
        zzVOU.zzXfK(zzWXJ2, 3100);
        zzVOU.zzXfK(zzWXJ2, 3070);
        zzVOU.zzXfK(zzWXJ2, 3080);
    }

    private static void zzXfK(zzWXJ zzWXJ2, int n) {
        if (!zzWXJ2.zzEa(n)) {
            return;
        }
        zzWXJ2.set(n, zzX79.zzWyC((Integer)zzWXJ2.get(n)));
    }

    private static boolean zzWn9(Table table) {
        if (table.getRows().getCount() == 0) {
            return false;
        }
        if (table.zzAl()) {
            return false;
        }
        if (table.zzYGR()) {
            return table.getPreferredWidth().zzXmR() || table.getPreferredWidth().isAuto();
        }
        if (table.getAllowAutoFit()) {
            return !table.getDocument().zzX7j().zzZY4.getGrowAutofit();
        }
        return table.getPreferredWidth().zzXmR();
    }

    private void zzXoI(Table table) {
        int n;
        int n2 = table.zzvX();
        Section section = (Section)table.getAncestor(2);
        int n3 = n = section != null ? section.zzXGb().zzm5() : 0;
        if ((this.zzWdR || n <= 31680) && n2 > 31680) {
            this.zzXfK(table, 31680);
            n2 = table.zzvX();
        }
        if (!zzVOU.zzWn9(table)) {
            return;
        }
        int n4 = n2;
        if (table.getAllowAutoFit() || table.getPreferredWidth().getType() == 2) {
            n4 = zzYei.zzZkD(table);
        }
        if (table.getPreferredWidth().zzYbu() && table.getPreferredWidth().zz9Y() >= n4) {
            int n5 = n4 = n2 < 31680 ? n2 : 31680;
        }
        if (n2 > n4 + zzZws) {
            this.zzXfK(table, n4);
        }
    }

    private void zzXfK(Table table, int n) {
        double d;
        int n2 = table.zzvX();
        double d2 = (double)n / (double)n2;
        if (d < 1.0) {
            if (table.zzZ0Y()) {
                return;
            }
            this.zzVTF(65536, "Table width exceed maximum allowed, table was resized.");
            for (Row row : table.getRows()) {
                int n3 = 0;
                for (Cell cell : row.getCells()) {
                    cell.zzXe3().zzW5N((int)zzYIW.zzXas(d2 * (double)cell.zzXe3().zzXPW()));
                    n3 += cell.zzXe3().zzXPW();
                }
                int n4 = row.getLastCell().zzXe3().zzXPW() + (n - n3);
                if (n4 < 0) continue;
                row.getLastCell().zzXe3().zzW5N(n4);
            }
        }
    }

    private void zzVTF(int n, String string) {
        if (this.zzWch != null) {
            this.zzWch.warning(new WarningInfo(65536, 17, string));
        }
    }
}

