/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzUa;
import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzXop;
import com.aspose.words.internal.zzY6t;
import com.aspose.words.internal.zzi5;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zz2z;
import com.aspose.words.net.System.Data.zzXfK;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzYT1;
    private Object[] zzWm7;
    private int zzYs = 1;
    private int zzZUf;
    private String zzW4v;
    private Map<String, Object> zzWb8 = new HashMap<String, Object>();
    private Map<String, String> zzWoK = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzYT1 = table;
        this.zzWm7 = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzWm7, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zz2z.zzZuG(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzYT1.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzYT1.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzYT1;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzYT1.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzYT1.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzYT1.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzYT1.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzYT1.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzYT1.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzYT1) {
            throw new IllegalStateException(zzVQq.zz2z("Table {0} is not the child table in the relation {1}", this.zzYT1.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzWGp(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzZ7S(columnIndex, value);
        this.zzYT1.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzYT1.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzYs;
    }

    public void setRowState(int state) {
        this.zzYs = state;
    }

    public void delete() {
        zzXfK.zz2z(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzWb8.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzWb8.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzWm7.length];
        System.arraycopy(this.zzWm7, 0, objectArray, 0, this.zzWm7.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzWm7.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzWm7.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzZ7S(i, array[i]);
        }
        this.zzYT1.onDataRowChanged(this);
    }

    final int zzZcC() {
        return this.zzZUf;
    }

    final void zzzU(String string, String string2) {
        this.zzWoK.put(string, string2);
    }

    final void zzWXa(String string, String string2) {
        this.zzW4v = zzVQq.zz2z(string, string2);
    }

    final String zzYBI() {
        return this.zzW4v;
    }

    final void zzXlf(int n) {
        this.zzZUf = n;
    }

    final Object[] zzZ9o() {
        return this.zzWm7;
    }

    static boolean zzWGp(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzZik(index)) {
            return null;
        }
        return this.zzWm7[index];
    }

    private void zzZ7S(int n, Object object) {
        if (!this.zzZik(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzWGp((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzWGp((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzWGp(clazz, object)))));
        this.zzWm7[n] = object2;
    }

    private static Object zzWGp(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzi5.class) {
                return zzi5.zzWGp(string, zzUa.zzXmf(), 128).zzng();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzY6t.zzZuG(exception);
        }
        return object;
    }

    private boolean zzZik(int n) {
        this.zzXoZ();
        return this.zzWm7 != null && n >= 0 && n < this.zzWm7.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzYT1.getColumns().getCount();
        if (this.zzWm7.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWm7.length - index];
        System.arraycopy(this.zzWm7, index, objectArray, 0, this.zzWm7.length - index);
        System.arraycopy(objectArray, 1, this.zzWm7, index, objectArray.length - 1);
    }

    private void zzXoZ() {
        if (this.zzYT1 == null || this.zzYT1.getColumns() == null || this.zzWm7 == null) {
            return;
        }
        int n = this.zzYT1.getColumns().getCount();
        if (this.zzWm7.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWm7.length];
        System.arraycopy(this.zzWm7, 0, objectArray, 0, this.zzWm7.length);
        this.zzWm7 = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzWm7.length);
        System.arraycopy(objectArray, 0, this.zzWm7, 0, n2);
        for (int i = n2; i < this.zzWm7.length; ++i) {
            this.zzWm7[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzWGp(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block11;
            return null;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzXop.zzWGp(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzY6t.zzZuG(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzY6t.zzZuG(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzY6t.zzZuG(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzY6t.zzZuG(iOException);
            }
            return byArray;
        }
    }

    private static String zzWGp(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzY6t.zzZuG(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzY6t.zzZuG(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzWm7;
        int n = dataRow.zzWm7.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

