/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzVQq;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzZkD;

public class DataRelation {
    private DataKey zzXB5;
    private DataKey zzLC;
    private String zzXxQ;
    private String[] zz51;
    private String[] zzX1S;
    private DataColumn[] zzWMI;
    private DataColumn[] zzfS;
    private UniqueConstraint zzZNd;
    private ForeignKeyConstraint zzYQh;
    private boolean zzXhN = true;
    private DataSet zzX7k;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        DataColumn[] dataColumnArray = DataRelation.zz2z(parentTable, parentColumnNames);
        DataColumn[] dataColumnArray2 = DataRelation.zz2z(childTable, childColumnNames);
        this.zzWGp(relationName, dataColumnArray, dataColumnArray2, true);
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        this.zzWGp(relationName, parentColumns, childColumns, createConstraints);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    private static DataColumn[] zz2z(DataTable dataTable, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Column names need to have at least one column name.");
        }
        if (dataTable == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        DataColumn[] dataColumnArray = new DataColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DataColumn dataColumn = dataTable.getColumns().get(stringArray[i]);
            if (dataColumn == null) {
                throw new IllegalArgumentException(zzVQq.zz2z("The given column {0} does not exist in {1}", stringArray[i], dataTable.getTableName()));
            }
            dataColumnArray[i] = dataColumn;
        }
        return dataColumnArray;
    }

    private void zzWGp(String string, DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, boolean bl) {
        int n;
        DataColumn dataColumn;
        int n2;
        if (dataColumnArray == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        if (dataColumnArray2 == null) {
            throw new IllegalArgumentException("childColumns");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Key Length mismatch");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            if (dataColumnArray[i].getTable().getDataSet() != null && dataColumnArray2[i].getTable().getDataSet() != null) continue;
            throw new IllegalArgumentException("Parent or Child columns do not have DataSet");
        }
        DataColumn[] dataColumnArray3 = dataColumnArray;
        int n3 = dataColumnArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray3 = dataColumnArray2;
        n3 = dataColumnArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < dataColumnArray2.length; ++n) {
            if (dataColumnArray[n].zz2z(dataColumnArray2[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzWMI = dataColumnArray;
        this.zzfS = dataColumnArray2;
        this.zzXxQ = string == null ? "" : string;
        this.zzXhN = bl;
        this.zzLC = new DataKey(dataColumnArray, true);
        this.zzXB5 = new DataKey(dataColumnArray2, true);
        this.zzX7k = dataTable.getDataSet();
        this.zz51 = new String[this.zzWMI.length];
        for (n = 0; n < this.zzWMI.length; ++n) {
            this.zz51[n] = this.zzWMI[n].getColumnName();
        }
        this.zzX1S = new String[this.zzfS.length];
        for (n = 0; n < this.zzfS.length; ++n) {
            this.zzX1S[n] = this.zzfS[n].getColumnName();
        }
    }

    public String getRelationName() {
        return this.zzXxQ;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        return this.getParentKey().getTable();
    }

    public DataTable getChildTable() {
        return this.getChildKey().getTable();
    }

    public String[] getParentColumnNames() {
        return this.zz51;
    }

    public String[] getChildColumnNames() {
        return this.zzX1S;
    }

    public DataColumn[] getParentColumns() {
        return this.zzWMI;
    }

    public DataColumn[] getChildColumns() {
        return this.zzfS;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzZNd;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzZNd = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzYQh;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzYQh = childKeyConstraint;
    }

    public DataKey getChildKey() {
        return this.zzXB5;
    }

    public DataKey getParentKey() {
        return this.zzLC;
    }

    public DataSet getDataSet() {
        return this.zzX7k;
    }

    public int hashCode() {
        int n = 31 + this.zzXxQ.hashCode();
        n = n * 31 + ((String)null).hashCode();
        n = n * 31 + ((String)null).hashCode();
        for (int i = 0; i < this.zz51.length; ++i) {
            n = n * 31 + this.zz51[i].hashCode();
            n = n * 31 + this.zzX1S[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    static DataRow[] zzWGp(DataKey dataKey, DataKey dataKey2, DataRow dataRow) {
        Object[] objectArray = dataRow.getKeyValues(dataKey2);
        if (DataRelation.zzZsu(objectArray)) {
            return new DataRow[0];
        }
        zzZkD zzZkD2 = dataKey.getSortIndex();
        return zzZkD2.zzqZ(objectArray);
    }

    private static boolean zzZsu(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            if (DataRelation.zzWFt(object)) continue;
            return false;
        }
        return true;
    }

    private static boolean zzWFt(Object object) {
        return object == null || DBNull.Value == object;
    }

    final void zzbe() throws InvalidConstraintException, DataException {
        if (!this.zzXhN) {
            return;
        }
        DataRelation dataRelation = this;
        ForeignKeyConstraint foreignKeyConstraint = dataRelation.zzZuG(dataRelation.getChildTable().getConstraints());
        DataRelation dataRelation2 = this;
        UniqueConstraint uniqueConstraint = dataRelation2.zz2z(dataRelation2.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zz2z(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzWGp(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzZuG(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzWGp(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzWGp(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzWGp(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

