/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzLV;
import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzXip;
import com.aspose.words.internal.zzYIW;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.internal.zzZdI;
import com.aspose.words.internal.zzx5;
import com.aspose.words.zzWOe;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzXEz;
    private zzWOe zzX0i;

    Watermark(Document doc, zzWOe watermarkProvider) {
        this.zzXEz = doc;
        this.zzX0i = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzWPo(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzWGp(text, textWatermarkOptions, this.zzXEz);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZ23.zz2z((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzXEz, 75);
        shape.getImageData().setImage(image);
        this.zzWGp(shape, options, this.zzXEz);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZ23.zz2z((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzXEz, 75);
        shape.getImageData().setImage(imagePath);
        this.zzWGp(shape, options, this.zzXEz);
    }

    public final int getType() {
        Shape shape = this.zzX0i.get();
        if (shape == null) {
            return 2;
        }
        shape.zzfY();
        if (shape.zzY8E()) {
            return 0;
        }
        if (shape.zzVX6()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzX0i.add(shape);
    }

    public final void remove() {
        this.zzX0i.remove();
    }

    private static void zzWPo(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzXip.zzYnM(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZ23.zzWGp(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzWGp(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zz2z(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzZUE(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zz2z(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzpe() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzX8i()) / d2) > (double)(f = pageSetup.zzXWu())) {
            d = (double)f / d3;
        }
        shape.zzYaz(zzYIW.zzWGp(d2 * d, 2, zzZdI.zzY7A));
        shape.zzVPs(zzYIW.zzWGp(d3 * d, 2, zzZdI.zzY7A));
    }

    private Shape zzWGp(String string, TextWatermarkOptions textWatermarkOptions, Document document) throws Exception {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzWGp(shape, textWatermarkOptions, document);
        shape.getFill().setColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzZUE(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzWGp(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYN7() ? 1.0f : textWatermarkOptions.getFontSize();
        zzLV zzLV2 = document.zz0z().zzZuG(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzLV2.zzkJ(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYN7()) {
            l = Watermark.zzWGp(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzYaz(zzYIW.zzWGp(Float.intBitsToFloat(n), 2, zzZdI.zzY7A));
        shape.zzVPs(zzYIW.zzWGp(zzx5.zzZk6(l), 2, zzZdI.zzY7A));
    }

    private static long zzWGp(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzX8i();
        float f2 = pageSetup.zzXWu();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzx5.zzZk6(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzx5.zzzp(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzx5.zzZk6(l) >= Float.intBitsToFloat(n)) {
            return zzx5.zzzp(f2 / f3, f2);
        }
        float f6 = f;
        return zzx5.zzzp(f6, f6 * f3);
    }

    private static void zzZUE(Shape shape, String string) {
        shape.setName(zzVQq.zz2z("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

