/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzXip;
import com.aspose.words.internal.zzXop;
import com.aspose.words.internal.zzXwu;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.internal.zzZMu;
import com.aspose.words.internal.zzZcq;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zz9z;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzY65 = new HashMap();
    private static HashMap<Integer, Integer> zzYel = new HashMap();
    private static HashMap<Integer, Integer> zzYYK = new HashMap();
    private static HashMap<Integer, Integer> zzXYd = new HashMap();
    private static HashMap<Integer, Integer> zzsE = new HashMap();
    private static HashMap<Integer, Integer> zzXw = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ23.zzWGp(fileName, "fileName");
        try (zzXwu zzXwu2 = zzZ23.zzW5w(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzXFj(zzXwu2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzXFj(zzXop.zzWGp(stream));
    }

    static FileFormatInfo zzXFj(zzZMu zzZMu2) throws Exception {
        if (zzZMu2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz9z zz9z2 = new zz9z();
            zzZMu zzZMu3 = zzZMu2;
            zz9z zz9z3 = zz9z2;
            return zz9z2.zz2z(zzZMu3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zz2z(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzXOz(zzZcq.zzWs9(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzVYi(zzZcq.zzWs9(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXip.zzWf8(string = zzZcq.zzZQO(FileFormatUtil.zzXQy(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzXOz(FileFormatUtil.zzj2(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzVYi(FileFormatUtil.zzXQy(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzZcq.zzZQO(FileFormatUtil.zzj2(saveFormat));
        if (zzXip.zzWf8(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzVYi(zzZcq.zzZ5Y(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzZcq.zzZQO(FileFormatUtil.zzYu3(imageType));
    }

    static Exception zz2z(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzBq(int n) {
        return zzZcq.toString(FileFormatUtil.zzj2(n));
    }

    static int zzVYi(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZ23.zzWGp(zzsE, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzYR6(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZ23.zzWGp(zzXw, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzY0p(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzXQy(int n) {
        return zzZ23.zzWGp(zzY65, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzj2(int n) {
        return zzZ23.zzWGp(zzYel, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYu3(int n) {
        return zzZ23.zzWGp(zzYYK, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXOz(int n) {
        return zzZ23.zzWGp(zzXYd, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXIh(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZ23.zz2z(zzsE, Integer.valueOf(n), Integer.valueOf(n2));
            zzZ23.zz2z(zzYel, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXYd.containsKey(n)) {
                zzZ23.zz2z(zzXYd, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZ23.zz2z(zzY65, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZ23.zz2z(zzXw, Integer.valueOf(n), Integer.valueOf(n4));
            zzZ23.zz2z(zzYYK, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXIh(11, 10, 10, 1);
        FileFormatUtil.zzXIh(11, 0, 0, 1);
        FileFormatUtil.zzXIh(12, 11, 11, 1);
        FileFormatUtil.zzXIh(13, 20, 20, 1);
        FileFormatUtil.zzXIh(13, 0, 254, 1);
        FileFormatUtil.zzXIh(14, 21, 21, 1);
        FileFormatUtil.zzXIh(15, 22, 22, 1);
        FileFormatUtil.zzXIh(16, 23, 23, 1);
        FileFormatUtil.zzXIh(18, 24, 24, 1);
        FileFormatUtil.zzXIh(19, 25, 25, 1);
        FileFormatUtil.zzXIh(20, 26, 26, 1);
        FileFormatUtil.zzXIh(21, 27, 27, 1);
        FileFormatUtil.zzXIh(24, 30, 30, 1);
        FileFormatUtil.zzXIh(17, 31, 31, 1);
        FileFormatUtil.zzXIh(25, 50, 50, 1);
        FileFormatUtil.zzXIh(26, 45, 255, 1);
        FileFormatUtil.zzXIh(27, 51, 51, 1);
        FileFormatUtil.zzXIh(28, 0, 52, 1);
        FileFormatUtil.zzXIh(29, 0, 53, 1);
        FileFormatUtil.zzXIh(22, 60, 60, 1);
        FileFormatUtil.zzXIh(23, 61, 61, 1);
        FileFormatUtil.zzXIh(33, 40, 64, 1);
        FileFormatUtil.zzXIh(40, 47, 255, 1);
        FileFormatUtil.zzXIh(41, 48, 255, 1);
        FileFormatUtil.zzXIh(34, 41, 255, 1);
        FileFormatUtil.zzXIh(35, 46, 255, 1);
        FileFormatUtil.zzXIh(37, 42, 255, 1);
        FileFormatUtil.zzXIh(36, 44, 255, 1);
        FileFormatUtil.zzXIh(30, 52, 255, 1);
        FileFormatUtil.zzXIh(31, 70, 62, 1);
        FileFormatUtil.zzXIh(32, 73, 63, 1);
        FileFormatUtil.zzXIh(38, 71, 255, 1);
        FileFormatUtil.zzXIh(8, 100, 255, 1);
        FileFormatUtil.zzXIh(9, 105, 255, 1);
        FileFormatUtil.zzXIh(6, 101, 255, 6);
        FileFormatUtil.zzXIh(7, 102, 255, 7);
        FileFormatUtil.zzXIh(5, 104, 255, 5);
        FileFormatUtil.zzXIh(4, 0, 255, 4);
        FileFormatUtil.zzXIh(3, 0, 255, 3);
        FileFormatUtil.zzXIh(39, 72, 255, 1);
        FileFormatUtil.zzXIh(2, 103, 255, 2);
    }
}

