/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zzMg;
import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzVUQ;
import com.aspose.words.internal.zzWE8;
import com.aspose.words.internal.zzXSX;
import com.aspose.words.internal.zzXhl;
import com.aspose.words.internal.zzXiQ;
import com.aspose.words.internal.zzXip;
import com.aspose.words.internal.zzXr8;
import com.aspose.words.internal.zzYG1;
import com.aspose.words.internal.zzYZy;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.internal.zzZMu;
import com.aspose.words.internal.zzap;
import com.aspose.words.internal.zzg1;
import com.aspose.words.internal.zzt;
import com.aspose.words.zz17;
import com.aspose.words.zz54;
import com.aspose.words.zzBU;
import com.aspose.words.zzGG;
import com.aspose.words.zzNq;
import com.aspose.words.zzOR;
import com.aspose.words.zzVRG;
import com.aspose.words.zzVSE;
import com.aspose.words.zzVSk;
import com.aspose.words.zzW6g;
import com.aspose.words.zzWCQ;
import com.aspose.words.zzWCe;
import com.aspose.words.zzWHg;
import com.aspose.words.zzWS7;
import com.aspose.words.zzWU6;
import com.aspose.words.zzWXJ;
import com.aspose.words.zzWax;
import com.aspose.words.zzWl;
import com.aspose.words.zzXZu;
import com.aspose.words.zzXm5;
import com.aspose.words.zzXnm;
import com.aspose.words.zzXxs;
import com.aspose.words.zzY2C;
import com.aspose.words.zzYIs;
import com.aspose.words.zzYKv;
import com.aspose.words.zzYMP;
import com.aspose.words.zzYQ2;
import com.aspose.words.zzYSv;
import com.aspose.words.zzYbi;
import com.aspose.words.zzYei;
import com.aspose.words.zzZBW;
import com.aspose.words.zzZE2;
import com.aspose.words.zzZIr;
import com.aspose.words.zzZSM;
import com.aspose.words.zzZfo;
import com.aspose.words.zzZmI;
import com.aspose.words.zzZpI;
import com.aspose.words.zzZzU;
import com.aspose.words.zzoy;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zz17,
zzWl,
zzYKv {
    private Document zzXEz;
    private Node zzYQG;
    private Node zzWVd;
    private zzWCe zzXGp;
    private Font zzX9N;
    private zzg1<zzWCe> zzYdn;
    private zzg1<zzWGp> zzge;
    private zzYQ2 zzVZX = zzYQ2.zzZAh();
    private zzWXJ zzgx = new zzWXJ();
    private RowFormat zzVSL;
    private CellFormat zzW5O;
    private zzg1<zzXnm> zzYfv;
    private int zzXnS = 0;
    private int zzg9 = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) throws Exception {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() throws Exception {
        this.zzqZ(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() throws Exception {
        this.zzqZ(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) throws Exception {
        this.zzqZ(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) throws Exception {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWGp(documentBuilder.getCurrentSection(), zzWHg.zzW5K(headerFooterType), 0, 0);
    }

    private void zzqZ(int n, int n2, int n3, int n4) throws Exception {
        this.zzXEz.ensureMinimum();
        Section section = (Section)this.zzXEz.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzWGp(section, 1, n3, n4);
    }

    private void zzWGp(Section section, int n, int n2, int n3) throws Exception {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzWHg.zzYaj(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzXEz, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzXEz));
            }
        }
        this.zzWGp(story, n2, n3);
    }

    private void zzWGp(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        this.zzZuG(paragraph, n2);
    }

    final void zzZuG(Paragraph paragraph, int n) {
        if (n == 0) {
            Paragraph paragraph2 = paragraph;
            this.zz2z(paragraph2, paragraph2.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zz2z(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzcv().zzWu1() ? zzVRG.zzVTF(this.zzXEz, fieldName) : zzVRG.zzZU6(this.zzcv(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzWGp(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzWGp(field, isAfter, false);
    }

    private boolean zzWGp(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzNq zzNq2 = field.getFormat().zzYLD();
        Inline inline = zzNq2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzWGp(inline.zzYHh(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYSv.zzWGp(this.zzXEz, bookmarkName) : zzYSv.zz2z(this.zzXEz, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZAb() == 6) {
            this.zz2z((Paragraph)node.zzZzK(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYei.zzEW(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zz2z(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWGp(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) throws Exception {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: characterIndex");
        }
        Row row = this.zzZqj(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzZuG(cell.getFirstParagraph(), 0);
            return;
        }
        this.zzZuG(cell.getLastParagraph(), -1);
    }

    private void zz2z(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZAb() == 6) {
            this.zzZKt(node);
        } else if (zzYei.zzWnx(node)) {
            Paragraph paragraph = zzYei.zzEW(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzZKt(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzZAb() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzZKt(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzib();
            return;
        }
        if (!this.zzWuK()) {
            this.zzib();
        }
    }

    private boolean zzWuK() {
        Node node = this.zzcv();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzcv(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzWGp(inline.zzYHh(), true);
            return true;
        }
        return false;
    }

    private void zzib() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWGp(documentBuilder.getCurrentParagraph().zzZeP(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) throws Exception {
        Row row = this.zzZqj(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzWQ1() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzcv().zzya(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzX1d();
                this.zzZuG(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) throws Exception {
        this.zzXit(text, false);
    }

    public void writeln(String text) throws Exception {
        this.zzXit(text, true);
    }

    public void writeln() throws Exception {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() throws Exception {
        Paragraph paragraph = this.getCurrentParagraph();
        zzZE2 zzZE22 = new zzZE2(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzXEz, this.zz3D(), this.zzWK7());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zz2z(this.zzcv(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzZE22.dispose();
        }
        if (this.getDocument().zzXue()) {
            zzYbi.zzZuG(paragraph, this.getDocument().zzlq());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzVQL() throws Exception {
        zzWCe zzWCe2;
        Run run;
        Run run2;
        Cloneable cloneable;
        Node node = this.zzcv();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzXXU(false);
        } else {
            run2 = run = (Run)node.zzZj7(21);
        }
        if (run2 == null && zzZ23.zzMu(node, paragraph.zzYBT())) {
            run = paragraph.zzYBT();
        }
        if (run != null) {
            cloneable = run.zzYHh();
            zzWCe2 = (zzWCe)((zzZIr)cloneable).zzXc8();
        } else {
            cloneable = paragraph.zzZeP();
            zzWCe2 = (zzWCe)((zzZIr)cloneable).zzXc8();
        }
        zzWCe zzWCe3 = zzWCe2;
        Paragraph paragraph2 = new Paragraph(this.zzXEz, this.zz3D(), zzWCe3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzZE2 zzZE22 = new zzZE2(this.zzXEz);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zz2z(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzZE22.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() throws Exception {
        zzOR.zzZkD(this);
    }

    public void insertBreak(int breakType) throws Exception {
        this.zzZZn(breakType, true);
    }

    final void zzZZn(int n, boolean bl) throws Exception {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzMW(bl)) {
                    this.zzZnO(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzMW(bl)) {
                    this.zzZnO(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzMW(bl)) {
                    this.zzw0(1);
                }
                return;
            }
            case 5: {
                if (this.zzMW(bl)) {
                    this.zzw0(2);
                }
                return;
            }
            case 3: {
                if (this.zzMW(bl)) {
                    this.zzw0(0);
                }
                return;
            }
            case 6: {
                if (this.zzMW(bl)) {
                    this.zzw0(3);
                }
                return;
            }
            case 7: {
                if (this.zzMW(bl)) {
                    this.zzw0(4);
                }
                return;
            }
            case 8: {
                this.zzZnO(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) throws Exception {
        if (!zzXip.zzWf8(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzVQq.zz2z("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzYei.zzWGp(fieldType, updateField, this.zzWK7(), this.zzcv(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzYei.zzWGp(fieldCode, this.zzWK7(), this.zzcv(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) throws Exception {
        return zzYei.zzWGp(fieldCode, fieldValue, this.zzWK7(), this.zzcv(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) throws Exception {
        zzZ23.zz2z((Object)displayText, "displayText");
        zzZ23.zz2z((Object)urlOrBookmark, "hrefOrBookmark");
        zzXZu zzXZu2 = this.zz2z(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzXZu2.zz2z(documentBuilder.zzkJ(88, true));
        return zzYei.zzWGp(zzXZu2.getStart(), zzXZu2.getSeparator(), zzXZu2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzVR2(70);
        if (zzXip.zzWf8(name)) {
            this.startBookmark(name);
        }
        this.zzWFb(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzYPv(70);
        String string = zzXip.zzWf8(fieldValue) ? fieldValue : FormField.zzXOZ;
        Run run = new Run(this.zzXEz, string, this.zzWK7());
        this.insertNode(run);
        Node node = this.zzkJ(70, true);
        if (zzXip.zzWf8(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzWFg(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zz2z((Paragraph)node.zzZzK(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzVR2(71);
        if (zzXip.zzWf8(name)) {
            this.startBookmark(name);
        }
        this.zzWFb(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzkJ(71, false);
        if (zzXip.zzWf8(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWFg(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzVR2(83);
        if (zzXip.zzWf8(name)) {
            this.startBookmark(name);
        }
        this.zzWFb(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzkJ(83, false);
        if (zzXip.zzWf8(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWFg(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) throws Exception {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) throws Exception {
        Footnote footnote = new Footnote((DocumentBase)this.zzXEz, footnoteType);
        footnote.getFont().setStyleIdentifier(zzYei.zzYi(footnoteType));
        if (zzXip.zzWf8(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzXEz);
        paragraph.getParagraphFormat().setStyleIdentifier(zzYei.zzZRR(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzXEz, '\u0002', new zzWCe()) : new Run(this.zzXEz, footnote.getReferenceMark(), new zzWCe());
        inline.getFont().setStyleIdentifier(zzYei.zzYi(footnoteType));
        paragraph.appendChild(inline);
        if (zzXip.zzWf8(footnoteText)) {
            Node node = this.zzcv();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZKt(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzXjX(zzZMu zzZMu2) throws Exception {
        return this.zzWGp(zzZMu2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzXjX(zzZMu.zz2z(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzWGp(zzZMu zzZMu2, double d, double d2) throws Exception {
        return this.zzWGp(zzZMu2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzWGp(zzZMu.zz2z(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzWE8 zzWE82 = new zzWE8();){
            zzVUQ.zzWGp(image, zzWE82);
            Shape shape = this.zzWGp(zzWE82, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ23.zzWGp(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzXSX.zzZ29(fileName);
        try {
            Shape shape = this.zzWGp((zzZMu)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZMu)object).close();
            }
        }
    }

    private Shape zzWGp(zzZMu zzZMu2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZMu2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZ23.zzZU6(zzZMu2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWGp(zzZMu.zz2z(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl = zzYG1.zzWwn(imageBytes);
        boolean bl2 = this.zzXEz.getCompatibilityOptions().getMswVersion() > 12 || this.zzXEz.getCompatibilityOptions().getMswVersion() == 0;
        if (bl2) {
            shape = new Shape((DocumentBase)this.zzXEz, 0);
            zzYIs zzYIs2 = new zzYIs();
            zzYIs2.zzWGp(zzWCQ.zzYJZ("rect"));
            zzYIs2.zzWGp(new zzZfo());
            zzYIs2.zzYM4().zzWNu().zz2z(this.zzXEz);
            zzZSM zzZSM2 = new zzZSM();
            zzZSM2.zz2z(new zzWS7(this.zzXEz.zzX03(), ""));
            zzZSM2.zzWGp(new zzZpI());
            zzYIs2.zzWGp(zzZSM2);
            shape.zzXY0(75);
            shape.zzZkD(zzYIs2);
            if (bl) {
                zzYIs2.zzYM4().zzWNu().setExtensions(new zzt<zzVSk>());
                zzVSk zzVSk2 = zzVSk.zzWGp(imageBytes, this.zzXEz);
                zzYIs2.zzYM4().zzWNu().getExtensions().zzZUE(zzVSk2.getUri(), zzVSk2);
            }
        } else {
            shape = new Shape((DocumentBase)this.zzXEz, 75);
        }
        shape.zzWGp(this.zzWK7());
        if (bl) {
            imageBytes = shape.getImageData().zzWGp(imageBytes, new zzZBW(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), bl2 ? 6 : 2);
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzW5N(width, height);
        return shape;
    }

    private Shape zzWGp(zzZMu zzZMu2, String string, boolean bl, zzZMu zzZMu3) throws Exception {
        zzWax zzWax2 = zzWax.zzZdI(string);
        Shape shape = this.zzWGp(zzZMu3, bl, zzWax2, null);
        zzWU6 zzWU62 = zzY2C.zzWGp(zzZMu2, string, bl);
        return DocumentBuilder.zzWGp(null, false, shape, zzWax2.zzZq2, zzWU62);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWGp(zzZMu.zz2z(stream), progId, asIcon, zzZMu.zz2z(presentation));
    }

    private Shape zzWGp(String string, boolean bl, boolean bl2, zzZMu zzZMu2) throws Exception {
        zzWax zzWax2 = zzWax.zzZey(zzXiQ.zz9E(string));
        return this.zzWGp(string, bl, bl2, zzZMu2, zzWax2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWGp(fileName, isLinked, asIcon, zzZMu.zz2z(presentation));
    }

    private Shape zzWGp(String string, String string2, boolean bl, boolean bl2, zzZMu zzZMu2) throws Exception {
        zzWax zzWax2 = zzWax.zzZdI(string2);
        return this.zzWGp(string, bl, bl2, zzZMu2, zzWax2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWGp(fileName, progId, isLinked, asIcon, zzZMu.zz2z(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWax zzWax2 = zzWax.zzZey(zzXiQ.zz9E(fileName));
        return this.zzWGp(fileName, isLinked, iconFile, iconCaption, zzWax2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWax zzWax2 = zzWax.zzZdI(progId);
        return this.zzWGp(fileName, isLinked, iconFile, iconCaption, zzWax2);
    }

    private Shape zzWGp(zzZMu zzZMu2, String string, String string2, String string3) throws Exception {
        zzWax zzWax2 = zzWax.zzZdI(string);
        Shape shape = this.zzWGp(string2, string3, zzWax2);
        zzWU6 zzWU62 = zzY2C.zzWGp(zzZMu2, string, true);
        return DocumentBuilder.zzWGp(null, false, shape, zzWax2.zzZq2, zzWU62);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWGp(zzZMu.zz2z(stream), progId, iconFile, iconCaption);
    }

    final Shape zzWGp(zzW6g zzW6g2, zzZMu zzZMu2) throws Exception {
        Shape shape = this.zziE(zzZMu2);
        shape.zzXY0(201);
        shape.getOleFormat().zz2z(zzW6g2.zzWUw());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzWGp(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzVSE zzVSE2 = new zzVSE();
        zzVSE2.zzXzQ(useBuilderFormatting);
        zzVSE2.zzYCH(useBuilderFormatting);
        this.zzWGp(html, zzVSE2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzYei.zzWGp(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzYei.zzWGp(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzGG zzGG2 = new zzGG();
        return zzGG2.zzWGp(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZzU(this).zzWGp(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZzU(this).zzWGp(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzXEz, 75);
        shape.zzWGp(this.zzWK7());
        shape.zzZyF(true);
        shape.getSignatureLine().zzWGp(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzW5N(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZuA(this.zzXEz);
        this.insertNode(shape);
        return shape;
    }

    private void zzWGp(String string, zzVSE zzVSE2) throws Exception {
        if (this.zzZR3()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzZ6k(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzoy zzoy2 = zzYei.zzWGp(string, zzVSE2, this);
        zzoy2.zzZ61();
    }

    private boolean zzZR3() {
        boolean bl = false;
        if (this.zzcv().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzcv().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZ6k(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() throws Exception {
        if (this.zzWQ1() == null) {
            this.startTable();
        }
        if (this.zzWQ1().zzXbO() == 1) {
            this.zzWQ1().zzYjo();
        }
        if (this.zzWQ1().zzXbO() == 3) {
            this.zzWQ1().zzXJi();
        }
        return this.zzWQ1().zzBC();
    }

    public Table startTable() throws Exception {
        this.zzYfv.push(new zzXnm(this));
        return this.zzWQ1().startTable();
    }

    public Table endTable() {
        if (this.zzWQ1() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzWQ1().endTable();
        this.zzYfv.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzWQ1() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzWQ1().endRow();
        if (this.zzX9N != null && this.zzX9N.getHidden()) {
            row.zzXr5().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) throws Exception {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXEz, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) throws Exception {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXEz, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) throws Exception {
        Cell cell = this.zzVOM();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        Paragraph paragraph = cell2.getFirstParagraph();
        if (paragraph == null) {
            paragraph = new Paragraph(this.getDocument());
            cell2.appendChild(paragraph);
        }
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzXEz, bookmarkName);
        paragraph.insertAfter(bookmarkStart, null);
        int n = cell.zzVTO();
        bookmarkStart.zzZUU(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) throws Exception {
        Cell cell = this.zzVOM();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzVTO();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzXEz, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZ71(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() throws Exception {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzXEz);
        this.zzg9 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() throws Exception {
        if (this.zzg9 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXEz, this.zzg9);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) throws Exception {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzXEz, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) throws Exception {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) throws Exception {
        zzZ23.zz2z((Object)importFormatOptions, "ImportFormatOptions");
        return zzZmI.zzWGp(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzXEz;
    }

    public void setDocument(Document value) throws Exception {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzXEz) {
            return;
        }
        this.zzXEz = value;
        this.zzZKt(null);
        this.zzXGp = new zzWCe();
        this.zzYdn = null;
        this.zzX9N = null;
        this.zzYfv = new zzg1();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzX9N == null) {
            DocumentBuilder documentBuilder = this;
            this.zzX9N = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzX9N;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) throws Exception {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) throws Exception {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) throws Exception {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzVSL == null) {
            this.zzVSL = new RowFormat(this);
        }
        return this.zzVSL;
    }

    public CellFormat getCellFormat() {
        if (this.zzW5O == null) {
            this.zzW5O = new CellFormat(this);
        }
        return this.zzW5O;
    }

    final void zzZ9Z(Node node) throws Exception {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzWCe zzWCe2 = this.getCurrentParagraph().zzZeP();
        this.zzxn().push(new zzWGp(this.zzWK7(), (zzWCe)zzWCe2.zzXc8()));
    }

    public void popFont() {
        zzg1<zzWGp> zzg12 = this.zzxn();
        if (zzg12.size() > 0) {
            zzWGp zzWGp2 = (zzWGp)this.zzxn().pop();
            this.zzWGp(zzWGp2.zzYHh(), false);
            this.getCurrentParagraph().zzWS4(zzWGp2.zzZx());
        }
    }

    final void zzYsa() {
        this.zzZtl().push(this.zzWK7());
    }

    final void zzYz3() {
        zzg1<zzWCe> zzg12 = this.zzZtl();
        if (zzg12.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzWGp((zzWCe)documentBuilder.zzZtl().pop(), false);
        }
    }

    final zzXZu zz2z(String string, boolean bl, String string2, String string3) throws Exception {
        FieldStart fieldStart = this.zzVR2(88);
        zzXm5 zzXm52 = new zzXm5();
        zzXm52.setTarget(string2);
        zzXm52.setScreenTip(string3);
        if (bl) {
            zzXm52.setSubAddress(string);
        } else {
            zzXm52.setAddress(zzXr8.zzZvD(string));
            zzXm52.setSubAddress(zzXr8.zzzq(string));
        }
        this.zzWFb(zzXm52.toString());
        FieldSeparator fieldSeparator = this.zzYPv(88);
        return new zzXZu(fieldStart, fieldSeparator, null);
    }

    final zzXZu zzXIh(String string, String string2, String string3) throws Exception {
        boolean bl = zzXr8.zzXdw(string);
        String string4 = bl ? zzXr8.zzzq(string) : string;
        return this.zz2z(string4, bl, string2, string3);
    }

    final FieldEnd zzQl() throws Exception {
        return this.zzkJ(88, true);
    }

    final zzWCe zzWK7() {
        zzWCe zzWCe2 = this.zzXGp;
        return (zzWCe)zzWCe2.zzXc8();
    }

    final zzYMP zz3D() {
        zzYMP zzYMP2 = this.getCurrentParagraph().zzcq();
        return (zzYMP)zzYMP2.zzXc8();
    }

    final zzYQ2 zzXPw() {
        zzYQ2 zzYQ22 = this.zzXr5();
        return (zzYQ2)zzYQ22.zzXc8();
    }

    final zzWXJ zziz() {
        zzWXJ zzWXJ2 = this.zzXe3();
        return (zzWXJ)zzWXJ2.zzXc8();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzcv(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzcv().getNodeType() == 8;
    }

    private void zzXit(String string, boolean bl) throws Exception {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzWHg.zzYJx(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXrN(string2.substring(n4, n4 + n2));
                }
                switch (this.zzXnS) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZnO(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXrN(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzZnO(String string) throws Exception {
        Run run = new Run(this.zzXEz, string, this.zzWK7());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) throws Exception {
        if (this.zzWQ1() != null && this.zzWQ1().zzXbO() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzcv().getParentNode().insertBefore(node, this.zzcv());
    }

    final void zzWGk(int n) throws Exception {
        this.zzMW(true);
        this.zzw0(n);
    }

    private void zzw0(int n) throws Exception {
        this.insertParagraph();
        zzZE2 zzZE22 = new zzZE2(this.getDocument());
        try {
            zz54 zz542 = this.getCurrentSection().zzXGb();
            zz54 zz543 = (zz54)zz542.zzXc8();
            Section section = new Section(this.zzXEz, zz543);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzXEz));
            this.zzXEz.insertAfter(section, this.getCurrentSection());
            section.getBody().zz2z(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzZE22.dispose();
        }
    }

    final FieldStart zzVR2(int n) throws Exception {
        return zzYei.zzWGp(n, this.zzWK7(), this.zzcv(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzWFb(String string) throws Exception {
        return zzYei.zz2z(string, this.zzWK7(), this.zzcv(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzkJ(int n, boolean bl) throws Exception {
        return zzYei.zz2z(n, bl, this.zzWK7(), this.zzcv(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzYPv(int n) throws Exception {
        return zzYei.zz2z(n, this.zzWK7(), this.zzcv(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzWFg(Node node) throws Exception {
        FormField formField = new FormField((DocumentBase)this.zzXEz, new zzBU(), this.zzWK7());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzMW(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzWQ1() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZqj(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXrN(String string) throws Exception {
        if (this.zzZBM(string)) {
            zzMg zzMg2 = new zzMg(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXhl zzXhl2 : zzMg2.zzXBc(this.getParagraphFormat().getBidi())) {
                zzXxs zzXxs2 = zzXxs.zzX7x(zzXhl2.zzYAX());
                zzWCe zzWCe2 = this.zzWK7();
                zzWCe2.zzXIh(265, zzXxs2);
                if (zzXhl2.zzZgp()) {
                    zzWCe2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzXEz, zzXhl2.getText(), zzWCe2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZnO(string);
    }

    private boolean zzZBM(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzap.zzek(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzWGp(zzWCe zzWCe2, boolean bl) {
        zzWCe zzWCe3;
        if (bl) {
            zzWCe zzWCe4 = zzWCe2;
            zzWCe3 = (zzWCe)zzWCe4.zzXc8();
        } else {
            zzWCe3 = zzWCe2;
        }
        this.zzXGp = zzWCe3;
    }

    final void zzZqH() {
        this.zzXGp.clear();
    }

    final void zzWeQ() {
        if (this.zzVOM() != null) {
            zzWXJ zzWXJ2;
            zzWXJ zzWXJ3 = zzWXJ2 = this.zzVOM().zzXe3();
            this.zzgx = (zzWXJ)zzWXJ3.zzXc8();
            zzWXJ2.zz2z(this.zzgx);
        }
    }

    private Shape zzWGp(String string, boolean bl, boolean bl2, zzZMu zzZMu2, zzWax zzWax2) throws Exception {
        if (zzWax2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzWGp(zzZMu2, bl2, zzWax2, string);
        zzWU6 zzWU62 = zzY2C.zzWGp(string, bl, bl2, zzWax2);
        return DocumentBuilder.zzWGp(string, bl, shape, zzWax2.zzZq2, zzWU62);
    }

    private Shape zzWGp(String string, boolean bl, String string2, String string3, zzWax zzWax2) throws Exception {
        if (zzWax2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzXiQ.zzp3(string);
        }
        Shape shape = string2 != null ? this.zzpa(string2, string3) : this.zzWGp(null, string3, zzWax2);
        zzWU6 zzWU62 = zzY2C.zzWGp(string, bl, true, zzWax2);
        return DocumentBuilder.zzWGp(string, bl, shape, zzWax2.zzZq2, zzWU62);
    }

    private static Shape zzWGp(String string, boolean bl, Shape shape, String string2, zzWU6 zzWU62) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzXY0(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zz2z(zzWU62);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzWGp(zzZMu zzZMu2, boolean bl, zzWax zzWax2, String string) throws Exception {
        if (zzWax2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzZMu2 != null) {
            return this.zziE(zzZMu2);
        }
        if (!bl) {
            return this.zzXPW(zzY2C.zzYhV().get("normal"));
        }
        String string2 = string != null ? zzXiQ.zzp3(string) : zzY2C.zz8D(zzWax2.zzXtU);
        return this.zzWGp(zzWax2, string2);
    }

    private Shape zzWGp(String string, String string2, zzWax zzWax2) throws Exception {
        if (zzWax2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzY2C.zz8D(zzWax2.zzXtU);
        }
        if (string != null) {
            return this.zzpa(string, string2);
        }
        return this.zzWGp(zzWax2, string2);
    }

    private Shape zzWGp(zzWax zzWax2, String string) throws Exception {
        if (zzWax2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzY2C.zzYHz(zzWax2.zzXtU);
        zzYZy zzYZy2 = new zzYZy(byArray, null, string, this.getDocument().zz0z());
        return this.zzXPW(zzYZy2.zzWlI());
    }

    private Shape zzpa(String string, String string2) throws Exception {
        zzYZy zzYZy2 = new zzYZy(string, string2, this.getDocument().zz0z());
        return this.zzXPW(zzYZy2.zzWlI());
    }

    private Shape zziE(zzZMu zzZMu2) throws Exception {
        byte[] byArray = zzZ23.zzZU6(zzZMu2);
        return this.zzXPW(byArray);
    }

    private Shape zzXPW(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzXEz, 1);
        shape.zzXY0(75);
        shape.zzWGp(this.zzWK7());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzW5N(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    final boolean zzYpc() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZFP() {
        return this.zzXnS;
    }

    final void zzWge(int n) {
        this.zzXnS = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzcv();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzcv();
        }
        return (Paragraph)this.zzcv().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzXnm zzWQ1() {
        zzg1<zzXnm> zzg12 = this.zzYfv;
        if (zzg12.size() > 0) {
            return (zzXnm)this.zzYfv.peek();
        }
        return null;
    }

    private Cell zzVOM() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzWVe();
    }

    private zzg1<zzWCe> zzZtl() {
        if (this.zzYdn == null) {
            this.zzYdn = new zzg1();
        }
        return this.zzYdn;
    }

    private zzg1<zzWGp> zzxn() {
        if (this.zzge == null) {
            this.zzge = new zzg1();
        }
        return this.zzge;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXGp.zzYx3(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZsv(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZsv(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXGp.zzXIh(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWui()) {
            this.getCurrentParagraph().zzZeP().zzXIh(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXGp.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXGp.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWui()) {
            this.getCurrentParagraph().zzZeP().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzXr5().zzYx3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzXr5().zzYCx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzXr5().zzZfT(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzXr5().zzXIh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzXr5().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzXr5().clear();
        zzYQ2.zzZAh().zz2z(this.zzXr5());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXe3().zzYx3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzXe3().zzYCx(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzXe3().zzZfT(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ23.zzWGp(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzVOM() != null ? this.zzVOM().getCellFormat() : this.getCellFormat();
            border.zzWGp(cellFormat);
        }
        this.zzXe3().zzXIh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXe3().clear();
    }

    private Node zzcv() {
        Node node = this.zzYQG != null && this.zzYQG.getParentNode() == null ? this.zzWVd : this.zzYQG;
        if (node != null && node.zzZAb() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzZKt(Node node) {
        this.zzYQG = node;
        if (this.zzYQG != null) {
            this.zzWVd = this.zzYQG.getParentNode();
        }
    }

    private zzYQ2 zzXr5() {
        if (this.zzWQ1() != null && this.zzWQ1().zzXbO() == 1) {
            return this.zzVZX;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzXr5();
        }
        return this.zzVZX;
    }

    private zzWXJ zzXe3() {
        if (this.zzWQ1() != null && this.zzWQ1().zzXbO() != 3) {
            return this.zzgx;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzWVe().zzXe3();
        }
        return this.zzgx;
    }

    static final class zzWGp {
        private zzWCe zzXGp;
        private zzWCe zzX0l;

        public zzWGp(zzWCe zzWCe2, zzWCe zzWCe3) {
            this.zzXGp = zzWCe2;
            this.zzX0l = zzWCe3;
        }

        public final zzWCe zzYHh() {
            return this.zzXGp;
        }

        public final zzWCe zzZx() {
            return this.zzX0l;
        }
    }
}

