/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzT5;
import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzW1x;
import com.aspose.words.internal.zzWE8;
import com.aspose.words.internal.zzWSE;
import com.aspose.words.internal.zzWY1;
import com.aspose.words.internal.zzXDx;
import com.aspose.words.internal.zzXhp;
import com.aspose.words.internal.zzXwu;
import com.aspose.words.internal.zzYe5;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.internal.zzZMu;
import com.aspose.words.zz4d;
import com.aspose.words.zz9z;
import com.aspose.words.zzB2;
import com.aspose.words.zzVUt;
import com.aspose.words.zzW9B;
import com.aspose.words.zzXGr;
import com.aspose.words.zzXnV;
import com.aspose.words.zzYHS;
import com.aspose.words.zzZ0g;
import com.aspose.words.zzZEW;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzWGp(zzZMu zzZMu2, zzZMu zzZMu3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZ23.zz2z((Object)zzZMu2, "srcStream");
        zzZ23.zz2z((Object)zzZMu3, "dstStream");
        zzZ23.zz2z((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zz2z(zzZMu2, zzZMu3, certificateHolder, signOptions);
        zzZMu3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzWGp(zzZMu.zz2z(srcStream), (zzZMu)zzZMu.zzZuG(dstStream), certHolder, signOptions);
    }

    private static void zz2z(zzZMu zzZMu2, zzZMu zzZMu3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZuG(digitalSignature);
        }
        if (zz9z.zzW3Y(zzZMu2)) {
            DigitalSignatureUtil.zzWGp(zzZMu2, zzZMu3, digitalSignature, true);
            return;
        }
        zz9z zz9z2 = new zz9z();
        zzZMu zzZMu4 = zzZMu2;
        zz9z zz9z3 = zz9z2;
        FileFormatInfo fileFormatInfo = zz9z2.zz2z(zzZMu4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYe5 zzYe52 = new zzYe5(zzZMu2);
                int n = fileFormatInfo.zzYIf() == 1 ? 1 : 2;
                zzYHS.zzWGp(zzYe52, digitalSignature, n);
                zzZMu3.zzWO1(0L);
                zzYe52.zzW5w(zzZMu3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzWGp(fileFormatInfo.zzXD9(), zzZMu3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzWGp(zzZMu2, zzZMu3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzWGp(zzZMu2, zzZMu3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZ23.zzWGp(srcFileName, "srcFileName");
        zzZ23.zzWGp(dstFileName, "dstFileName");
        try (zzXwu zzXwu2 = zzZ23.zz2z(srcFileName, 3, 1);){
            try (zzXwu zzXwu3 = zzZ23.zz2z(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWGp((zzZMu)zzXwu2, (zzZMu)zzXwu3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzXhp zzXhp2 = zzZMu.zzZuG(dstStream);
        zzZMu zzZMu2 = zzZMu.zz2z(srcStream);
        DigitalSignatureUtil.zzWGp(zzZMu2, (zzZMu)zzXhp2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzXwu zzXwu2 = zzZ23.zz2z(srcFileName, 3, 1);){
            try (zzXwu zzXwu3 = zzZ23.zz2z(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZUE(zzXwu2, zzXwu3);
            }
            return;
        }
    }

    private static void zzZUE(zzZMu zzZMu2, zzZMu zzZMu3) throws Exception {
        zz9z zz9z2 = new zz9z();
        zzZMu zzZMu4 = zzZMu2;
        zz9z zz9z3 = zz9z2;
        FileFormatInfo fileFormatInfo = zz9z2.zz2z(zzZMu4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYe5 zzYe52 = new zzYe5(zzZMu2);
                zzYe52.zzW0U().zzWxx("_xmlsignatures");
                zzYe52.zzW0U().zzWxx("_signatures");
                zzZMu3.zzWW(0L);
                zzYe52.zzW5w(zzZMu3);
                zzZMu zzZMu5 = zzZMu3;
                zzZMu5.zzWO1(zzZMu5.zzXzQ());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzT5 zzT52 = new zzT5(zzZMu2);
                zzWSE zzWSE2 = zzT52.zzWGp(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzWSE2 != null) {
                    for (zzXDx zzXDx2 : zzWSE2.zzWb2()) {
                        String string = zzWSE2.zzWGp(zzXDx2);
                        zzT52.zzWAM().remove(string);
                    }
                    zzT52.zzWAM().remove(zzWSE2.getName());
                    zzXDx zzXDx3 = zzT52.zzWb2().zzXIc("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzT52.zzWb2().remove(zzXDx3.getId());
                    zzT52.zzfo();
                }
                zzZMu3.zzWW(0L);
                zzT52.zzW5w(zzZMu3);
                zzZMu zzZMu6 = zzZMu3;
                zzZMu6.zzWO1(zzZMu6.zzXzQ());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzZUE(zzZMu.zz2z(srcStream), zzZMu.zzZuG(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzXwu zzXwu2 = zzZ23.zz2z(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzX23(zzXwu2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzX23(zzZMu zzZMu2) throws Exception {
        if (zz9z.zzW3Y(zzZMu2)) {
            return DigitalSignatureUtil.zzWxm(zzZMu2);
        }
        zz9z zz9z2 = new zz9z();
        zzZMu zzZMu3 = zzZMu2;
        zz9z zz9z3 = zz9z2;
        FileFormatInfo fileFormatInfo = zz9z2.zz2z(zzZMu3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZMu2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzX23(zzZMu.zz2z(stream));
    }

    static zzWE8 zzWGp(zzYe5 zzYe52, String string) throws Exception {
        zzB2 zzB22 = new zzB2(zzYe52);
        if (zzB22.zzJS()) {
            zzWE8 zzWE82 = zzB22.zzGy(string);
            return zzWE82;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXBX(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzVQq.zz2z("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZIr(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzXBX(n);
    }

    private static void zzWGp(zzZMu zzZMu2, zzZMu zzZMu3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzT5 zzT52 = new zzT5(zzZMu2);
        zzXnV zzXnV2 = bl ? new zzZ0g(zzT52) : new zzVUt(zzT52);
        zzXnV2.zz2z(digitalSignature);
        zzZMu3.zzWO1(0L);
        zzT52.zzW5w(zzZMu3);
    }

    private static void zzWGp(zzZMu zzZMu2, zzZMu zzZMu3, DigitalSignature digitalSignature) throws Exception {
        zzXGr zzXGr2 = new zzXGr(zzZMu2);
        zzW9B zzW9B2 = new zzW9B(zzXGr2);
        zzW9B2.zz2z(digitalSignature);
        zzZMu3.zzWO1(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZMu zzZMu4 = zzZMu3;
        zzXGr zzXGr3 = zzXGr2;
        zzXGr3.zzWGp(zzZMu4, string, null);
    }

    private static void zzWGp(zzYe5 zzYe52, zzZMu zzZMu2, DigitalSignature digitalSignature, String string) throws Exception {
        zzWE8 zzWE82 = DigitalSignatureUtil.zzWGp(zzYe52, string);
        zzWE8 zzWE83 = new zzWE8();
        DigitalSignatureUtil.zzWGp((zzZMu)zzWE82, (zzZMu)zzWE83, digitalSignature, false);
        zzYe5 zzYe53 = zzB2.zzZuG(zzWE83, string);
        zzYe53.zzW5w(zzZMu2);
    }

    private static DigitalSignatureCollection zzWxm(zzZMu zzZMu2) throws Exception {
        zzZMu2.zzWW(0L);
        zzT5 zzT52 = new zzT5(zzZMu2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzWSE zzWSE2 = zzT52.zzWGp(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzWSE2 != null) {
            for (zzXDx zzXDx2 : zzWSE2.zzWb2()) {
                String string = zzWSE2.zzWGp(zzXDx2);
                zzWSE zzWSE3 = zzT52.zzWML(string);
                zzWSE zzWSE4 = zzT52.zzWGp(zzWSE3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzW1x zzW1x2 = zzWY1.zzZo1(zzWSE4.zzIG().zzZ1a());
                zzZEW.zzWGp(zzWSE3.zzYop(), zzW1x2, new zz4d(zzT52), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

