/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairzset;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairzset.LeaderBoard;
import com.aliyun.tair.tairzset.params.ExzaddParams;
import com.aliyun.tair.tairzset.params.ExzrangeParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairZsetCluster {
    private JedisCluster jc;

    public TairZsetCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public Long exzadd(String key, String member, double ... scores) {
        return this.exzadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), SafeEncoder.encode((String)member));
    }

    public Long exzadd(byte[] key, byte[] member, double ... scores) {
        return this.exzadd(key, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), member);
    }

    public Long exzadd(String key, String score, String member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, new String[]{key, score, member});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzadd(byte[] key, byte[] score, byte[] member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, (byte[][])new byte[][]{key, score, member});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzadd(String key, String score, String member, ExzaddParams params) {
        return this.exzadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)score), SafeEncoder.encode((String)member), params);
    }

    public Long exzadd(byte[] key, byte[] score, byte[] member, ExzaddParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(key, score, member));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    @Deprecated
    public Long exzadd(String key, Map<String, String> scoreMembers) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(SafeEncoder.encode((String)key));
        for (Map.Entry<String, String> entry : scoreMembers.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
        }
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzaddMembers(String key, Map<String, String> members) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(SafeEncoder.encode((String)key));
        for (Map.Entry<String, String> entry : members.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
        }
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    @Deprecated
    public Long exzadd(byte[] key, Map<byte[], byte[]> scoreMembers) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(key);
        for (Map.Entry<byte[], byte[]> entry : scoreMembers.entrySet()) {
            bparams.add(entry.getKey());
            bparams.add(entry.getValue());
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzaddMembers(byte[] key, Map<byte[], byte[]> members) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(key);
        for (Map.Entry<byte[], byte[]> entry : members.entrySet()) {
            bparams.add(entry.getValue());
            bparams.add(entry.getKey());
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    @Deprecated
    public Long exzadd(String key, Map<String, String> scoreMembers, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : scoreMembers.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
        }
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(SafeEncoder.encode((String)key), (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzaddMembers(String key, Map<String, String> members, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : members.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
        }
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(SafeEncoder.encode((String)key), (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    @Deprecated
    public Long exzadd(byte[] key, Map<byte[], byte[]> scoreMembers, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<byte[], byte[]> entry : scoreMembers.entrySet()) {
            bparams.add(entry.getKey());
            bparams.add(entry.getValue());
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(key, (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzaddMembers(byte[] key, Map<byte[], byte[]> members, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<byte[], byte[]> entry : members.entrySet()) {
            bparams.add(entry.getValue());
            bparams.add(entry.getKey());
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(key, (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String exzincrBy(String key, String increment, String member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZINCRBY, new String[]{key, increment, member});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] exzincrBy(byte[] key, byte[] increment, byte[] member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZINCRBY, (byte[][])new byte[][]{key, increment, member});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public String exzincrBy(String key, String member, double ... scores) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZINCRBY, new String[]{key, LeaderBoard.joinScoresToString(scores), member});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] exzincrBy(byte[] key, byte[] member, double ... scores) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZINCRBY, (byte[][])new byte[][]{key, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), member});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public Long exzrem(String key, String ... member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREM, JoinParameters.joinParameters(key, member));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrem(byte[] key, byte[] ... member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREM, JoinParameters.joinParameters(key, member));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzremrangeByScore(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, new String[]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzremrangeByScore(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, (byte[][])new byte[][]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzremrangeByRank(String key, long start, long stop) {
        return this.exzremrangeByRank(SafeEncoder.encode((String)key), start, stop);
    }

    public Long exzremrangeByRank(byte[] key, long start, long stop) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREMRANGEBYRANK, (byte[][])new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzremrangeByLex(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREMRANGEBYLEX, new String[]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzremrangeByLex(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREMRANGEBYLEX, (byte[][])new byte[][]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String exzscore(String key, String member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZSCORE, new String[]{key, member});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] exzscore(byte[] key, byte[] member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZSCORE, (byte[][])new byte[][]{key, member});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public List<String> exzrange(String key, long min, long max) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrange(byte[] key, long min, long max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrangeWithScores(String key, long min, long max) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrangeWithScores(byte[] key, long min, long max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrevrange(String key, long min, long max) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrevrange(byte[] key, long min, long max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrevrangeWithScores(String key, long min, long max) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrevrangeWithScores(byte[] key, long min, long max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrangeByScore(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, new String[]{key, min, max});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrangeByScore(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, (byte[][])new byte[][]{key, min, max});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrangeByScore(String key, String min, String max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrangeByScore(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, params.getByteParams(key, min, max));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrevrangeByScore(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, new String[]{key, min, max});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrevrangeByScore(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, (byte[][])new byte[][]{key, min, max});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrevrangeByScore(String key, String min, String max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrevrangeByScore(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, params.getByteParams(key, min, max));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrangeByLex(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, new String[]{key, min, max});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrangeByLex(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, (byte[][])new byte[][]{key, min, max});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrangeByLex(String key, String min, String max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrangeByLex(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, params.getByteParams(key, min, max));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrevrangeByLex(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, new String[]{key, min, max});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrevrangeByLex(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, (byte[][])new byte[][]{key, min, max});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> exzrevrangeByLex(String key, String min, String max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> exzrevrangeByLex(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, params.getByteParams(key, min, max));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public Long exzcard(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZCARD, new String[]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzcard(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZCARD, (byte[][])new byte[][]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrank(String key, String member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANK, new String[]{key, member});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrank(byte[] key, byte[] member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANK, (byte[][])new byte[][]{key, member});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrevrank(String key, String member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANK, new String[]{key, member});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrevrank(byte[] key, byte[] member) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANK, (byte[][])new byte[][]{key, member});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrankByScore(String key, String score) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANKBYSCORE, new String[]{key, score});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrankByScore(byte[] key, byte[] score) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZRANKBYSCORE, (byte[][])new byte[][]{key, score});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrevrankByScore(String key, String score) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE, new String[]{key, score});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzrevrankByScore(byte[] key, byte[] score) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE, (byte[][])new byte[][]{key, score});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzcount(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZCOUNT, new String[]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzcount(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZCOUNT, (byte[][])new byte[][]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzlexcount(String key, String min, String max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZLEXCOUNT, new String[]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exzlexcount(byte[] key, byte[] min, byte[] max) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXZLEXCOUNT, (byte[][])new byte[][]{key, min, max});
        return (Long)BuilderFactory.LONG.build(obj);
    }
}

