/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairzset;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairzset.LeaderBoard;
import com.aliyun.tair.tairzset.params.ExzaddParams;
import com.aliyun.tair.tairzset.params.ExzrangeParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairZset {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairZset(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairZset(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    public Long exzadd(String key, String member, double ... scores) {
        return this.exzadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), SafeEncoder.encode((String)member));
    }

    public Long exzadd(byte[] key, byte[] member, double ... scores) {
        return this.exzadd(key, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzadd(String key, String score, String member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, new String[]{key, score, member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzadd(byte[] key, byte[] score, byte[] member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])new byte[][]{key, score, member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exzadd(String key, String score, String member, ExzaddParams params) {
        return this.exzadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)score), SafeEncoder.encode((String)member), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzadd(byte[] key, byte[] score, byte[] member, ExzaddParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(key, score, member));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Long exzadd(String key, Map<String, String> scoreMembers) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(SafeEncoder.encode((String)key));
        for (Map.Entry<String, String> entry : scoreMembers.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzaddMembers(String key, Map<String, String> members) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(SafeEncoder.encode((String)key));
        for (Map.Entry<String, String> entry : members.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Long exzadd(byte[] key, Map<byte[], byte[]> scoreMembers) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(key);
        for (Map.Entry<byte[], byte[]> entry : scoreMembers.entrySet()) {
            bparams.add(entry.getKey());
            bparams.add(entry.getValue());
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzaddMembers(byte[] key, Map<byte[], byte[]> members) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(key);
        for (Map.Entry<byte[], byte[]> entry : members.entrySet()) {
            bparams.add(entry.getValue());
            bparams.add(entry.getKey());
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Long exzadd(String key, Map<String, String> scoreMembers, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : scoreMembers.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(SafeEncoder.encode((String)key), (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzaddMembers(String key, Map<String, String> members, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : members.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(SafeEncoder.encode((String)key), (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Long exzadd(byte[] key, Map<byte[], byte[]> scoreMembers, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<byte[], byte[]> entry : scoreMembers.entrySet()) {
            bparams.add(entry.getKey());
            bparams.add(entry.getValue());
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(key, (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzaddMembers(byte[] key, Map<byte[], byte[]> members, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<byte[], byte[]> entry : members.entrySet()) {
            bparams.add(entry.getValue());
            bparams.add(entry.getKey());
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, params.getByteParams(key, (byte[][])bparams.toArray((T[])new byte[bparams.size()][])));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exzincrBy(String key, String increment, String member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZINCRBY, new String[]{key, increment, member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exzincrBy(byte[] key, byte[] increment, byte[] member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZINCRBY, (byte[][])new byte[][]{key, increment, member});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exzincrBy(String key, String member, double ... scores) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZINCRBY, new String[]{key, LeaderBoard.joinScoresToString(scores), member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exzincrBy(byte[] key, byte[] member, double ... scores) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZINCRBY, (byte[][])new byte[][]{key, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), member});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrem(String key, String ... member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREM, JoinParameters.joinParameters(key, member));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrem(byte[] key, byte[] ... member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREM, JoinParameters.joinParameters(key, member));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzremrangeByScore(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, new String[]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzremrangeByScore(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, (byte[][])new byte[][]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exzremrangeByRank(String key, long start, long stop) {
        return this.exzremrangeByRank(SafeEncoder.encode((String)key), start, stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzremrangeByRank(byte[] key, long start, long stop) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYRANK, (byte[][])new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzremrangeByLex(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYLEX, new String[]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzremrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYLEX, (byte[][])new byte[][]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exzscore(String key, String member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZSCORE, new String[]{key, member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exzscore(byte[] key, byte[] member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZSCORE, (byte[][])new byte[][]{key, member});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrange(String key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrange(byte[] key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrangeWithScores(String key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrangeWithScores(byte[] key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrevrange(String key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrevrange(byte[] key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max)});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrevrangeWithScores(String key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrevrangeWithScores(byte[] key, long min, long max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{key, Protocol.toByteArray((long)min), Protocol.toByteArray((long)max), SafeEncoder.encode((String)"WITHSCORES")});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrangeByScore(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, new String[]{key, min, max});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrangeByScore(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, (byte[][])new byte[][]{key, min, max});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrangeByScore(String key, String min, String max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrangeByScore(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE, params.getByteParams(key, min, max));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrevrangeByScore(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, new String[]{key, min, max});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrevrangeByScore(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, (byte[][])new byte[][]{key, min, max});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrevrangeByScore(String key, String min, String max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrevrangeByScore(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE, params.getByteParams(key, min, max));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrangeByLex(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, new String[]{key, min, max});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, (byte[][])new byte[][]{key, min, max});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrangeByLex(String key, String min, String max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrangeByLex(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX, params.getByteParams(key, min, max));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrevrangeByLex(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, new String[]{key, min, max});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrevrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, (byte[][])new byte[][]{key, min, max});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exzrevrangeByLex(String key, String min, String max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max)));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exzrevrangeByLex(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX, params.getByteParams(key, min, max));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzcard(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCARD, new String[]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzcard(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCARD, (byte[][])new byte[][]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrank(String key, String member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANK, new String[]{key, member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrank(byte[] key, byte[] member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANK, (byte[][])new byte[][]{key, member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrevrank(String key, String member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANK, new String[]{key, member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrevrank(byte[] key, byte[] member) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANK, (byte[][])new byte[][]{key, member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrankByScore(String key, String score) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANKBYSCORE, new String[]{key, score});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrankByScore(byte[] key, byte[] score) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANKBYSCORE, (byte[][])new byte[][]{key, score});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrevrankByScore(String key, String score) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE, new String[]{key, score});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzrevrankByScore(byte[] key, byte[] score) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE, (byte[][])new byte[][]{key, score});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzcount(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCOUNT, new String[]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzcount(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCOUNT, (byte[][])new byte[][]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzlexcount(String key, String min, String max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZLEXCOUNT, new String[]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exzlexcount(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZLEXCOUNT, (byte[][])new byte[][]{key, min, max});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

