/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairvector;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairvector.factory.VectorBuilderFactory;
import com.aliyun.tair.tairvector.params.DistanceMethod;
import com.aliyun.tair.tairvector.params.HscanParams;
import com.aliyun.tair.tairvector.params.IndexAlgorithm;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairVector {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairVector(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairVector(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    @Deprecated
    public void quit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tvscreateindex(String index, int dims, IndexAlgorithm algorithm, DistanceMethod method, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSCREATEINDEX, JoinParameters.joinParameters(SafeEncoder.encode((String)index), Protocol.toByteArray((int)dims), SafeEncoder.encode((String)algorithm.name()), SafeEncoder.encode((String)method.name()), SafeEncoder.encodeMany((String[])params)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] tvscreateindex(byte[] index, int dims, IndexAlgorithm algorithm, DistanceMethod method, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSCREATEINDEX, JoinParameters.joinParameters(index, Protocol.toByteArray((int)dims), SafeEncoder.encode((String)algorithm.name()), SafeEncoder.encode((String)method.name()), params));
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> tvsgetindex(String index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSGETINDEX, (byte[][])new byte[][]{SafeEncoder.encode((String)index)});
            Map map = (Map)BuilderFactory.STRING_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> tvsgetindex(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSGETINDEX, (byte[][])new byte[][]{index});
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvsdelindex(String index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSDELINDEX, (byte[][])new byte[][]{SafeEncoder.encode((String)index)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvsdelindex(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSDELINDEX, (byte[][])new byte[][]{index});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> tvsscanindex(Long cursor, HscanParams params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((long)cursor));
            args.addAll(params.getParams());
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSSCANINDEX, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)VectorBuilderFactory.SCAN_CURSOR_STRING.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshset(String index, String entityid, String vector, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHSET, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)"VECTOR"), SafeEncoder.encode((String)vector), SafeEncoder.encodeMany((String[])params)));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshset(byte[] index, byte[] entityid, byte[] vector, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHSET, JoinParameters.joinParameters(index, entityid, SafeEncoder.encode((String)"VECTOR"), vector, params));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> tvshgetall(String index, String entityid) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHGETALL, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid)});
            Map map = (Map)BuilderFactory.STRING_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> tvshgetall(byte[] index, byte[] entityid) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHGETALL, (byte[][])new byte[][]{index, entityid});
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> tvshmget(String index, String entityid, String ... attrs) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHMGET, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encodeMany((String[])attrs)));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> tvshmget(byte[] index, byte[] entityid, byte[] ... attrs) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHMGET, JoinParameters.joinParameters(index, entityid, attrs));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvsdel(String index, String entityid) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSDEL, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvsdel(byte[] index, byte[] entityid) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSDEL, (byte[][])new byte[][]{index, entityid});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvsdel(String index, String ... entityids) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSDEL, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encodeMany((String[])entityids)));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvsdel(byte[] index, byte[] ... entityids) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSDEL, JoinParameters.joinParameters(index, entityids));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshdel(String index, String entityid, String attr, String ... attrs) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHDEL, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)attr), SafeEncoder.encodeMany((String[])attrs)));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshdel(byte[] index, byte[] entityid, byte[] attr, byte[] ... attrs) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHDEL, JoinParameters.joinParameters(index, entityid, attr, attrs));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> tvsscan(String index, Long cursor, HscanParams params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(SafeEncoder.encode((String)index));
            args.add(Protocol.toByteArray((long)cursor));
            args.addAll(params.getParams());
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)VectorBuilderFactory.SCAN_CURSOR_STRING.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<byte[]> tvsscan(byte[] index, Long cursor, HscanParams params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(index);
            args.add(Protocol.toByteArray((long)cursor));
            args.addAll(params.getParams());
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)VectorBuilderFactory.SCAN_CURSOR_BYTE.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public VectorBuilderFactory.Knn<String> tvsknnsearch(String index, Long topn, String vector, String ... params) {
        return this.tvsknnsearchfilter(index, topn, vector, "", params);
    }

    public VectorBuilderFactory.Knn<byte[]> tvsknnsearch(byte[] index, Long topn, byte[] vector, byte[] ... params) {
        return this.tvsknnsearchfilter(index, topn, vector, SafeEncoder.encode((String)""), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.Knn<String> tvsknnsearchfilter(String index, Long topn, String vector, String pattern, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSKNNSEARCH, JoinParameters.joinParameters(SafeEncoder.encode((String)index), Protocol.toByteArray((long)topn), SafeEncoder.encode((String)vector), SafeEncoder.encode((String)pattern), SafeEncoder.encodeMany((String[])params)));
            VectorBuilderFactory.Knn knn = (VectorBuilderFactory.Knn)VectorBuilderFactory.STRING_KNN_RESULT.build(obj);
            return knn;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.Knn<byte[]> tvsknnsearchfilter(byte[] index, Long topn, byte[] vector, byte[] pattern, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSKNNSEARCH, JoinParameters.joinParameters(index, Protocol.toByteArray((long)topn), vector, pattern, params));
            VectorBuilderFactory.Knn knn = (VectorBuilderFactory.Knn)VectorBuilderFactory.BYTE_KNN_RESULT.build(obj);
            return knn;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public VectorBuilderFactory.KnnField<String> tvsknnsearchfield(String index, Long topn, String vector, Collection<String> fields, String ... params) {
        return this.tvsknnsearchfilterfield(index, topn, vector, fields, "", params);
    }

    public VectorBuilderFactory.KnnField<byte[]> tvsknnsearchfield(byte[] index, Long topn, byte[] vector, Collection<byte[]> fields, byte[] ... params) {
        return this.tvsknnsearchfilterfield(index, topn, vector, fields, SafeEncoder.encode((String)""), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.KnnField<String> tvsknnsearchfilterfield(String index, Long topn, String vector, Collection<String> fields, String pattern, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(SafeEncoder.encode((String)index));
            args.add(Protocol.toByteArray((long)topn));
            args.add(SafeEncoder.encode((String)vector));
            args.add(Protocol.toByteArray((int)fields.size()));
            if (!fields.isEmpty()) {
                args.addAll(fields.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
            }
            args.add(SafeEncoder.encode((String)pattern));
            args.addAll(Arrays.stream(params).map(SafeEncoder::encode).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSKNNSEARCHFIELD, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.KnnField knnField = (VectorBuilderFactory.KnnField)VectorBuilderFactory.STRING_KNNFIELD_RESULT.build(obj);
            return knnField;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.KnnField<byte[]> tvsknnsearchfilterfield(byte[] index, Long topn, byte[] vector, Collection<byte[]> fields, byte[] pattern, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(index);
            args.add(Protocol.toByteArray((long)topn));
            args.add(vector);
            args.add(Protocol.toByteArray((int)fields.size()));
            if (!fields.isEmpty()) {
                args.addAll(fields);
            }
            args.add(pattern);
            args.addAll(Arrays.stream(params).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSKNNSEARCHFIELD, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.KnnField knnField = (VectorBuilderFactory.KnnField)VectorBuilderFactory.BYTE_KNNFIELD_RESULT.build(obj);
            return knnField;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Collection<VectorBuilderFactory.Knn<String>> tvsmknnsearch(String index, Long topn, Collection<String> vectors, String ... params) {
        return this.tvsmknnsearchfilter(index, topn, vectors, "", params);
    }

    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmknnsearch(byte[] index, Long topn, Collection<byte[]> vectors, byte[] ... params) {
        return this.tvsmknnsearchfilter(index, topn, vectors, SafeEncoder.encode((String)""), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VectorBuilderFactory.Knn<String>> tvsmknnsearchfilter(String index, Long topn, Collection<String> vectors, String pattern, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(SafeEncoder.encode((String)index));
            args.add(Protocol.toByteArray((long)topn));
            args.add(Protocol.toByteArray((int)vectors.size()));
            args.addAll(vectors.stream().map(vector -> SafeEncoder.encode((String)vector)).collect(Collectors.toList()));
            args.add(SafeEncoder.encode((String)pattern));
            args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Collection collection = (Collection)VectorBuilderFactory.STRING_KNN_BATCH_RESULT.build(obj);
            return collection;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmknnsearchfilter(byte[] index, Long topn, Collection<byte[]> vectors, byte[] pattern, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(index);
            args.add(Protocol.toByteArray((long)topn));
            args.add(Protocol.toByteArray((int)vectors.size()));
            args.addAll(vectors);
            args.add(pattern);
            args.addAll(Arrays.stream(params).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Collection collection = (Collection)VectorBuilderFactory.BYTE_KNN_BATCH_RESULT.build(obj);
            return collection;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public VectorBuilderFactory.Knn<String> tvsmindexknnsearch(Collection<String> indexs, Long topn, String vector, String ... params) {
        return this.tvsmindexknnsearchfilter(indexs, topn, vector, "", params);
    }

    public VectorBuilderFactory.Knn<byte[]> tvsmindexknnsearch(Collection<byte[]> indexs, Long topn, byte[] vector, byte[] ... params) {
        return this.tvsmindexknnsearchfilter(indexs, topn, vector, SafeEncoder.encode((String)""), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.Knn<String> tvsmindexknnsearchfilter(Collection<String> indexs, Long topn, String vector, String pattern, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((int)indexs.size()));
            args.addAll(indexs.stream().map(index -> SafeEncoder.encode((String)index)).collect(Collectors.toList()));
            args.add(Protocol.toByteArray((long)topn));
            args.add(SafeEncoder.encode((String)vector));
            args.add(SafeEncoder.encode((String)pattern));
            args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.Knn knn = (VectorBuilderFactory.Knn)VectorBuilderFactory.STRING_KNN_RESULT.build(obj);
            return knn;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.Knn<byte[]> tvsmindexknnsearchfilter(Collection<byte[]> indexs, Long topn, byte[] vector, byte[] pattern, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((int)indexs.size()));
            args.addAll(indexs);
            args.add(Protocol.toByteArray((long)topn));
            args.add(vector);
            args.add(pattern);
            args.addAll(Arrays.stream(params).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.Knn knn = (VectorBuilderFactory.Knn)VectorBuilderFactory.BYTE_KNN_RESULT.build(obj);
            return knn;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public VectorBuilderFactory.KnnField<String> tvsmindexknnsearchField(Collection<String> indexs, Long topn, String vector, Collection<String> fields, String ... params) {
        return this.tvsmindexknnsearchfilterfield(indexs, topn, vector, fields, "", params);
    }

    public VectorBuilderFactory.KnnField<byte[]> tvsmindexknnsearchField(Collection<byte[]> indexs, Long topn, byte[] vector, Collection<byte[]> fields, byte[] ... params) {
        return this.tvsmindexknnsearchfilterfield(indexs, topn, vector, fields, SafeEncoder.encode((String)""), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.KnnField<String> tvsmindexknnsearchfilterfield(Collection<String> indexs, Long topn, String vector, Collection<String> fields, String pattern, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((int)indexs.size()));
            args.addAll(indexs.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
            args.add(Protocol.toByteArray((long)topn));
            args.add(SafeEncoder.encode((String)vector));
            args.add(Protocol.toByteArray((int)fields.size()));
            if (!fields.isEmpty()) {
                args.addAll(fields.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
            }
            args.add(SafeEncoder.encode((String)pattern));
            args.addAll(Arrays.stream(params).map(SafeEncoder::encode).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCHFIELD, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.KnnField knnField = (VectorBuilderFactory.KnnField)VectorBuilderFactory.STRING_KNNFIELD_RESULT.build(obj);
            return knnField;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.KnnField<byte[]> tvsmindexknnsearchfilterfield(Collection<byte[]> indexs, Long topn, byte[] vector, Collection<byte[]> fields, byte[] pattern, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((int)indexs.size()));
            args.addAll(indexs);
            args.add(Protocol.toByteArray((long)topn));
            args.add(vector);
            args.add(Protocol.toByteArray((int)fields.size()));
            if (!fields.isEmpty()) {
                args.addAll(fields);
            }
            args.add(pattern);
            args.addAll(Arrays.stream(params).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCHFIELD, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.KnnField knnField = (VectorBuilderFactory.KnnField)VectorBuilderFactory.BYTE_KNNFIELD_RESULT.build(obj);
            return knnField;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Collection<VectorBuilderFactory.Knn<String>> tvsmindexmknnsearch(Collection<String> indexs, Long topn, Collection<String> vectors, String ... params) {
        return this.tvsmindexmknnsearchfilter(indexs, topn, vectors, "", params);
    }

    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmindexmknnsearch(Collection<byte[]> indexs, Long topn, Collection<byte[]> vectors, byte[] ... params) {
        return this.tvsmindexmknnsearchfilter(indexs, topn, vectors, SafeEncoder.encode((String)""), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VectorBuilderFactory.Knn<String>> tvsmindexmknnsearchfilter(Collection<String> indexs, Long topn, Collection<String> vectors, String pattern, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((int)indexs.size()));
            args.addAll(indexs.stream().map(index -> SafeEncoder.encode((String)index)).collect(Collectors.toList()));
            args.add(Protocol.toByteArray((long)topn));
            args.add(Protocol.toByteArray((int)vectors.size()));
            args.addAll(vectors.stream().map(vector -> SafeEncoder.encode((String)vector)).collect(Collectors.toList()));
            args.add(SafeEncoder.encode((String)pattern));
            args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMINDEXMKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Collection collection = (Collection)VectorBuilderFactory.STRING_KNN_BATCH_RESULT.build(obj);
            return collection;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmindexmknnsearchfilter(Collection<byte[]> indexs, Long topn, Collection<byte[]> vectors, byte[] pattern, byte[] ... params) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(Protocol.toByteArray((int)indexs.size()));
            args.addAll(indexs);
            args.add(Protocol.toByteArray((long)topn));
            args.add(Protocol.toByteArray((int)vectors.size()));
            args.addAll(vectors);
            args.add(pattern);
            args.addAll(Arrays.stream(params).collect(Collectors.toList()));
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSMINDEXMKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
            Collection collection = (Collection)VectorBuilderFactory.BYTE_KNN_BATCH_RESULT.build(obj);
            return collection;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.Knn<String> tvsgetdistance(String index, String vector, Collection<String> keys, Long topn, Float max_dist, String filter) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(SafeEncoder.encode((String)index));
            args.add(SafeEncoder.encode((String)vector));
            args.add(Protocol.toByteArray((int)keys.size()));
            args.addAll(keys.stream().map(key -> SafeEncoder.encode((String)key)).collect(Collectors.toList()));
            if (topn != null) {
                args.add(SafeEncoder.encode((String)"TOPN"));
                args.add(Protocol.toByteArray((long)topn));
            }
            if (max_dist != null) {
                args.add(SafeEncoder.encode((String)"MAX_DIST"));
                args.add(Protocol.toByteArray((double)max_dist.floatValue()));
            }
            if (filter != null) {
                args.add(SafeEncoder.encode((String)"FILTER"));
                args.add(SafeEncoder.encode((String)filter));
            }
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSGETDISTANCE, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.Knn knn = (VectorBuilderFactory.Knn)VectorBuilderFactory.STRING_KNN_RESULT.build(obj);
            return knn;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorBuilderFactory.Knn<byte[]> tvsgetdistance(byte[] index, byte[] vector, Collection<byte[]> keys, Long topn, Float max_dist, byte[] filter) {
        Jedis jedis = this.getJedis();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            args.add(index);
            args.add(vector);
            args.add(Protocol.toByteArray((int)keys.size()));
            args.addAll(keys);
            if (topn != null) {
                args.add(SafeEncoder.encode((String)"TOPN"));
                args.add(Protocol.toByteArray((long)topn));
            }
            if (max_dist != null) {
                args.add(SafeEncoder.encode((String)"MAX_DIST"));
                args.add(Protocol.toByteArray((double)max_dist.floatValue()));
            }
            if (filter != null) {
                args.add(SafeEncoder.encode((String)"FILTER"));
                args.add(filter);
            }
            Object obj = this.getJedis().sendCommand((ProtocolCommand)ModuleCommand.TVSGETDISTANCE, (byte[][])args.toArray((T[])new byte[args.size()][]));
            VectorBuilderFactory.Knn knn = (VectorBuilderFactory.Knn)VectorBuilderFactory.BYTE_KNN_RESULT.build(obj);
            return knn;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshincrby(String index, String entityid, String field, long value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)field), Protocol.toByteArray((long)value)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshincrby(byte[] index, byte[] entityid, byte[] field, long value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHINCRBY, (byte[][])new byte[][]{index, entityid, field, Protocol.toByteArray((long)value)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double tvshincrbyfloat(String index, String entityid, String field, double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHINCRBYFLOAT, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)field), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double tvshincrbyfloat(byte[] index, byte[] entityid, byte[] field, double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHINCRBYFLOAT, (byte[][])new byte[][]{index, entityid, field, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean tvshexpire(String index, String key, int seconds) {
        return this.tvshexpire(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tvshexpire(byte[] index, byte[] key, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHEXPIRE, (byte[][])new byte[][]{index, key, Protocol.toByteArray((int)seconds)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean tvshpexpire(String index, String key, int milliseconds) {
        return this.tvshpexpire(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), milliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tvshpexpire(byte[] index, byte[] key, int milliseconds) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHPEXPIRE, (byte[][])new byte[][]{index, key, Protocol.toByteArray((int)milliseconds)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean tvshexpireAt(String index, String key, long unixTime) {
        return this.tvshexpireAt(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), unixTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tvshexpireAt(byte[] index, byte[] key, long unixTime) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHEXPIREAT, (byte[][])new byte[][]{index, key, Protocol.toByteArray((long)unixTime)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean tvshpexpireAt(String index, String key, long unixTime) {
        return this.tvshpexpireAt(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), unixTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tvshpexpireAt(byte[] index, byte[] key, long unixTime) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHPEXPIREAT, (byte[][])new byte[][]{index, key, Protocol.toByteArray((long)unixTime)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tvshttl(String index, String key) {
        return this.tvshttl(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshttl(byte[] index, byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHTTL, (byte[][])new byte[][]{index, key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tvshpttl(String index, String key) {
        return this.tvshpttl(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshpttl(byte[] index, byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHPTTL, (byte[][])new byte[][]{index, key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tvshexpiretime(String index, String key) {
        return this.tvshexpiretime(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshexpiretime(byte[] index, byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHEXPIRETIME, (byte[][])new byte[][]{index, key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tvshpexpiretime(String index, String key) {
        return this.tvshpexpiretime(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tvshpexpiretime(byte[] index, byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TVSHPEXPIRETIME, (byte[][])new byte[][]{index, key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

