/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.bucket.terms;

import com.aliyun.tair.tairsearch.search.aggregations.bucket.MultiBucketsAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.InternalTerms;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.StringTerms;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class InternalMappedTerms<A extends InternalTerms<A, B>, B extends InternalTerms.Bucket<B>>
extends InternalTerms<A, B> {
    protected final List<B> buckets;
    protected Map<String, B> bucketMap;

    protected InternalMappedTerms(String name, JsonObject in) {
        super(name, in);
        ArrayList<B> buckets = new ArrayList<B>();
        JsonArray bucketsArray = in.get("buckets").getAsJsonArray();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            buckets.add(new StringTerms.Bucket(bucketsArray.get(i).getAsJsonObject()));
        }
        this.buckets = buckets;
    }

    @Override
    public List<B> getBuckets() {
        return this.buckets;
    }

    @Override
    public B getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = this.buckets.stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, Function.identity()));
        }
        return (B)((InternalTerms.Bucket)this.bucketMap.get(term));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMappedTerms that = (InternalMappedTerms)obj;
        return Objects.equals(this.buckets, that.buckets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets);
    }
}

