/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class AuxInfo {
    public static final String INDEX_CRC64 = "index_crc64";
    public static final String KEYS_CURSOR = "keys_cursor";
    private final JsonObject auxInfo;
    private Map<String, Integer> keysCursors;
    private long crc64;

    public AuxInfo(JsonObject in) {
        this.auxInfo = in;
        this.crc64 = Long.parseUnsignedLong(in.get(INDEX_CRC64).getAsString());
        this.keysCursors = new HashMap<String, Integer>();
        JsonObject cursorsJson = in.getAsJsonObject(KEYS_CURSOR);
        if (cursorsJson != null) {
            for (Map.Entry entry : cursorsJson.entrySet()) {
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonPrimitive()) {
                    this.keysCursors.put((String)entry.getKey(), value.getAsInt());
                    continue;
                }
                throw new IllegalArgumentException("Error aux_info format");
            }
        }
    }

    public long getCrc64() {
        return this.crc64;
    }

    public Map<String, Integer> getKeysCursorsAsMap() {
        return this.keysCursors;
    }
}

