/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairsearch.action.search.MSearchResponse;
import com.aliyun.tair.tairsearch.action.search.SearchResponse;
import com.aliyun.tair.tairsearch.params.DocInfo;
import com.aliyun.tair.tairsearch.params.DocInfoByte;
import com.aliyun.tair.tairsearch.params.TFTAddDocParams;
import com.aliyun.tair.tairsearch.params.TFTAddSugParams;
import com.aliyun.tair.tairsearch.params.TFTAnalyzerParams;
import com.aliyun.tair.tairsearch.params.TFTDelDocParams;
import com.aliyun.tair.tairsearch.params.TFTExplainScoreParams;
import com.aliyun.tair.tairsearch.params.TFTGetIndexParams;
import com.aliyun.tair.tairsearch.params.TFTGetSugParams;
import com.aliyun.tair.tairsearch.params.TFTMSearchParams;
import com.aliyun.tair.tairsearch.params.TFTMaddDocParams;
import com.aliyun.tair.tairsearch.params.TFTScanParams;
import com.aliyun.tair.tairsearch.search.builder.MSearchSourceBuilder;
import com.aliyun.tair.tairsearch.search.builder.SearchSourceBuilder;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairSearch {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairSearch(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairSearch(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    public String tftmappingindex(String index, String request) {
        return this.tftmappingindex(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftmappingindex(byte[] index, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMAPPINGINDEX, (byte[][])new byte[][]{index, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftcreateindex(String index, String request) {
        return this.tftcreateindex(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftcreateindex(byte[] index, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTCREATEINDEX, (byte[][])new byte[][]{index, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftupdateindex(String index, String request) {
        return this.tftupdateindex(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftupdateindex(byte[] index, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTUPDATEINDEX, (byte[][])new byte[][]{index, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    @Deprecated
    public String tftgetindexmappings(String index) {
        return this.tftgetindexmappings(SafeEncoder.encode((String)index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String tftgetindexmappings(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index, SafeEncoder.encode((String)"mappings")});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftgetindex(String index) {
        return this.tftgetindex(SafeEncoder.encode((String)index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftgetindex(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftgetindex(String index, TFTGetIndexParams params) {
        return this.tftgetindex(SafeEncoder.encode((String)index), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftgetindex(byte[] index, TFTGetIndexParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = params.getParams() == null ? jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index, params.getParams()});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftadddoc(String index, String request) {
        return this.tftadddoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftadddoc(byte[] index, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTADDDOC, (byte[][])new byte[][]{index, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftadddoc(String index, String request, String docId) {
        return this.tftadddoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request), SafeEncoder.encode((String)docId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftadddoc(byte[] index, byte[] request, byte[] docId) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTADDDOC, (byte[][])new byte[][]{index, request, SafeEncoder.encode((String)"WITH_ID"), docId});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String tftmadddoc(String index, Map<String, String> docs) {
        TFTAddDocParams params = new TFTAddDocParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String tftmadddoc(byte[] index, Map<byte[], byte[]> docs) {
        TFTAddDocParams params = new TFTAddDocParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftmadddoc(String index, List<DocInfo> docs) {
        TFTMaddDocParams params = new TFTMaddDocParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftmadddoc(byte[] index, List<DocInfoByte> docs) {
        TFTMaddDocParams params = new TFTMaddDocParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    @Deprecated
    public String tftupdatedoc(String index, String docId, String docContent) {
        return this.tftupdatedoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)docContent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String tftupdatedoc(byte[] index, byte[] docId, byte[] docContent) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTUPDATEDOC, (byte[][])new byte[][]{index, docId, docContent});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftupdatedocfield(String index, String docId, String docContent) {
        return this.tftupdatedoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)docContent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftupdatedocfield(byte[] index, byte[] docId, byte[] docContent) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTUPDATEDOCFIELD, (byte[][])new byte[][]{index, docId, docContent});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tftincrlongdocfield(String index, String docId, String field, long value) {
        return this.tftincrlongdocfield(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)field), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftincrlongdocfield(byte[] index, byte[] docId, byte[] field, long value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTINCRLONGDOCFIELD, (byte[][])new byte[][]{index, docId, field, Protocol.toByteArray((long)value)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Double tftincrfloatdocfield(String index, String docId, String field, double value) {
        return this.tftincrfloatdocfield(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)field), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double tftincrfloatdocfield(byte[] index, byte[] docId, byte[] field, double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTINCRFLOATDOCFIELD, (byte[][])new byte[][]{index, docId, field, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tftdeldocfield(String index, String docId, String ... field) {
        return this.tftdeldocfield(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encodeMany((String[])field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftdeldocfield(byte[] index, byte[] docId, byte[] ... field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTDELDOCFIELD, JoinParameters.joinParameters(index, docId, field));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftgetdoc(String index, String docId) {
        return this.tftgetdoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftgetdoc(byte[] index, byte[] docId) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETDOC, (byte[][])new byte[][]{index, docId});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftgetdoc(String index, String docId, String request) {
        return this.tftgetdoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftgetdoc(byte[] index, byte[] docId, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETDOC, (byte[][])new byte[][]{index, docId, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftdeldoc(String index, String ... docId) {
        TFTDelDocParams params = new TFTDelDocParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTDELDOC, params.getByteParams(index, docId));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftdeldoc(byte[] index, byte[] ... docId) {
        TFTDelDocParams params = new TFTDelDocParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTDELDOC, params.getByteParams(index, docId));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftdelall(String index) {
        return this.tftdelall(SafeEncoder.encode((String)index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftdelall(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTDELALL, (byte[][])new byte[][]{index});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public SearchResponse tftsearch(String index, SearchSourceBuilder ssb) {
        return new SearchResponse(this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)ssb.toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse tftsearch(byte[] index, SearchSourceBuilder ssb) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, SafeEncoder.encode((String)ssb.toString())});
            SearchResponse searchResponse = new SearchResponse((String)BuilderFactory.STRING.build(obj));
            return searchResponse;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public SearchResponse tftsearch(String index, SearchSourceBuilder ssb, boolean use_cache) {
        return new SearchResponse(this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)ssb.toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse tftsearch(byte[] index, SearchSourceBuilder ssb, boolean use_cache) {
        Object obj;
        Jedis jedis = this.getJedis();
        try {
            obj = use_cache ? jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, SafeEncoder.encode((String)ssb.toString()), SafeEncoder.encode((String)"use_cache")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, SafeEncoder.encode((String)ssb.toString())});
        }
        finally {
            this.releaseJedis(jedis);
        }
        return new SearchResponse((String)BuilderFactory.STRING.build(obj));
    }

    public String tftsearch(String index, String request) {
        return this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftsearch(byte[] index, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftsearch(String index, String request, boolean use_cache) {
        return this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request), use_cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftsearch(byte[] index, byte[] request, boolean use_cache) {
        Object obj;
        Jedis jedis = this.getJedis();
        try {
            obj = use_cache ? jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, request, SafeEncoder.encode((String)"use_cache")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, request});
        }
        finally {
            this.releaseJedis(jedis);
        }
        return (String)BuilderFactory.STRING.build(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftmsearch(String request, String ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(request, indexes));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftmsearch(byte[] request, byte[] ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(request, indexes));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MSearchResponse tftmsearch(MSearchSourceBuilder ssb, String ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(ssb.toString(), indexes));
            MSearchResponse mSearchResponse = new MSearchResponse((String)BuilderFactory.STRING.build(obj));
            return mSearchResponse;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MSearchResponse tftmsearch(MSearchSourceBuilder ssb, byte[] ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(SafeEncoder.encode((String)ssb.toString()), indexes));
            MSearchResponse mSearchResponse = new MSearchResponse((String)BuilderFactory.STRING.build(obj));
            return mSearchResponse;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tftexists(String index, String docId) {
        return this.tftexists(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftexists(byte[] index, byte[] docId) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTEXISTS, (byte[][])new byte[][]{index, docId});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tftdocnum(String index) {
        return this.tftdocnum(SafeEncoder.encode((String)index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftdocnum(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTDOCNUM, (byte[][])new byte[][]{index});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> tftscandocid(String index, String cursor) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSCANDOCID, new String[]{index, cursor});
            List result = (List)obj;
            String newcursor = new String((byte[])result.get(0));
            ArrayList<String> results = new ArrayList<String>();
            List rawResults = (List)result.get(1);
            for (byte[] bs : rawResults) {
                results.add(SafeEncoder.encode((byte[])bs));
            }
            ScanResult scanResult = new ScanResult(newcursor, results);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<byte[]> tftscandocid(byte[] index, byte[] cursor) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSCANDOCID, (byte[][])new byte[][]{index, cursor});
            List result = (List)obj;
            byte[] newcursor = (byte[])result.get(0);
            List rawResults = (List)result.get(1);
            ScanResult<byte[]> scanResult = new ScanResult<byte[]>(newcursor, rawResults);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> tftscandocid(String index, String cursor, TFTScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(SafeEncoder.encode((String)cursor));
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSCANDOCID, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List result = (List)obj;
            String newcursor = new String((byte[])result.get(0));
            ArrayList<String> results = new ArrayList<String>();
            List rawResults = (List)result.get(1);
            for (byte[] bs : rawResults) {
                results.add(SafeEncoder.encode((byte[])bs));
            }
            ScanResult scanResult = new ScanResult(newcursor, results);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<byte[]> tftscandocid(byte[] index, byte[] cursor, TFTScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(cursor);
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSCANDOCID, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List result = (List)obj;
            byte[] newcursor = (byte[])result.get(0);
            List rawResults = (List)result.get(1);
            ScanResult<byte[]> scanResult = new ScanResult<byte[]>(newcursor, rawResults);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftanalyzer(String analyzerName, String text) {
        return this.tftanalyzer(SafeEncoder.encode((String)analyzerName), SafeEncoder.encode((String)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftanalyzer(byte[] analyzerName, byte[] text) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTANALYZER, (byte[][])new byte[][]{analyzerName, text});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftanalyzer(String analyzerName, String text, TFTAnalyzerParams params) {
        return this.tftanalyzer(SafeEncoder.encode((String)analyzerName), SafeEncoder.encode((String)text), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftanalyzer(byte[] analyzerName, byte[] text, TFTAnalyzerParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTANALYZER, params.getByteParams(analyzerName, text));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftexplaincost(String index, SearchSourceBuilder ssb) {
        return this.tftexplaincost(SafeEncoder.encode((String)index), SafeEncoder.encode((String)ssb.toString()));
    }

    public String tftexplaincost(byte[] index, SearchSourceBuilder ssb) {
        return this.tftexplaincost(index, SafeEncoder.encode((String)ssb.toString()));
    }

    public String tftexplaincost(String index, String request) {
        return this.tftexplaincost(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftexplaincost(byte[] index, byte[] request) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTEXPLAINCOST, (byte[][])new byte[][]{index, request});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String tftexplainscore(String index, SearchSourceBuilder ssb, String ... docId) {
        return this.tftexplainscore(index, ssb.toString(), docId);
    }

    public String tftexplainscore(byte[] index, SearchSourceBuilder ssb, byte[] ... docId) {
        return this.tftexplainscore(index, SafeEncoder.encode((String)ssb.toString()), docId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftexplainscore(String index, String request, String ... docId) {
        TFTExplainScoreParams params = new TFTExplainScoreParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTEXPLAINSCORE, params.getByteParams(index, request, docId));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tftexplainscore(byte[] index, byte[] request, byte[] ... docId) {
        TFTExplainScoreParams params = new TFTExplainScoreParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTEXPLAINSCORE, params.getByteParams(index, request, docId));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftaddsug(String index, Map<String, Integer> texts) {
        TFTAddSugParams params = new TFTAddSugParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTADDSUG, params.getByteParams(index, texts));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftaddsug(byte[] index, Map<byte[], Integer> texts) {
        TFTAddSugParams params = new TFTAddSugParams();
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTADDSUG, params.getByteParams(index, texts));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tftdelsug(String index, String ... text) {
        return this.tftdelsug(SafeEncoder.encode((String)index), SafeEncoder.encodeMany((String[])text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftdelsug(byte[] index, byte[] ... text) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTDELSUG, JoinParameters.joinParameters(index, text));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long tftsugnum(String index) {
        return this.tftsugnum(SafeEncoder.encode((String)index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long tftsugnum(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTSUGNUM, (byte[][])new byte[][]{index});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> tftgetsug(String index, String prefix) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETSUG, new String[]{index, prefix});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> tftgetsug(byte[] index, byte[] prefix) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETSUG, (byte[][])new byte[][]{index, prefix});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> tftgetsug(String index, String prefix, TFTGetSugParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(SafeEncoder.encode((String)prefix));
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETSUG, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> tftgetsug(byte[] index, byte[] prefix, TFTGetSugParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(prefix);
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETSUG, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> tftgetallsugs(String index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETALLSUGS, (byte[][])new byte[][]{SafeEncoder.encode((String)index)});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> tftgetallsugs(byte[] index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.TFTGETALLSUGS, (byte[][])new byte[][]{index});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

