/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairhash;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanParams;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairhash.factory.HashBuilderFactory;
import com.aliyun.tair.tairhash.params.ExhgetwithverResult;
import com.aliyun.tair.tairhash.params.ExhincrByFloatParams;
import com.aliyun.tair.tairhash.params.ExhincrByParams;
import com.aliyun.tair.tairhash.params.ExhmsetwithoptsParams;
import com.aliyun.tair.tairhash.params.ExhsetParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairHash {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairHash(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairHash(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhset(String key, String field, String value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSET, new String[]{key, field, value});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhset(byte[] key, byte[] field, byte[] value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSET, (byte[][])new byte[][]{key, field, value});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhset(String key, String field, String value, ExhsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), SafeEncoder.encode((String)value)));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhset(byte[] key, byte[] field, byte[] value, ExhsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSET, params.getByteParams(key, field, value));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhsetnx(String key, String field, String value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSETNX, new String[]{key, field, value});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhsetnx(byte[] key, byte[] field, byte[] value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSETNX, (byte[][])new byte[][]{key, field, value});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String exhmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(SafeEncoder.encode((String)entry.getKey()), SafeEncoder.encode((String)entry.getValue()));
        }
        return this.exhmset(SafeEncoder.encode((String)key), bhash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exhmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public String exhmsetwithopts(String key, List<ExhmsetwithoptsParams<String>> params) {
        ArrayList<ExhmsetwithoptsParams<byte[]>> bexhash = new ArrayList<ExhmsetwithoptsParams<byte[]>>();
        for (ExhmsetwithoptsParams<String> entry : params) {
            bexhash.add(new ExhmsetwithoptsParams<byte[]>(SafeEncoder.encode((String)entry.getField()), SafeEncoder.encode((String)entry.getValue()), entry.getVer(), entry.getExp()));
        }
        return this.exhmsetwithopts(SafeEncoder.encode((String)key), bexhash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exhmsetwithopts(byte[] key, List<ExhmsetwithoptsParams<byte[]>> params) {
        ArrayList<byte[]> p = new ArrayList<byte[]>();
        p.add(key);
        for (ExhmsetwithoptsParams<byte[]> entry : params) {
            p.add(entry.getField());
            p.add(entry.getValue());
            p.add(Protocol.toByteArray((long)entry.getVer()));
            p.add(Protocol.toByteArray((long)entry.getExp()));
        }
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHMSETWITHOPTS, (byte[][])p.toArray((T[])new byte[params.size()][]));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean exhpexpire(String key, String field, int milliseconds) {
        return this.exhpexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), milliseconds);
    }

    public Boolean exhpexpire(String key, String field, int milliseconds, boolean noactive) {
        return this.exhpexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), milliseconds, noactive);
    }

    public Boolean exhpexpire(byte[] key, byte[] field, int milliseconds) {
        return this.exhpexpire(key, field, milliseconds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exhpexpire(byte[] key, byte[] field, int milliseconds, boolean noactive) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = noactive ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHPEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)milliseconds), SafeEncoder.encode((String)"noactive")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHPEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)milliseconds)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean exhpexpireAt(String key, String field, long unixTime) {
        return this.exhpexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime);
    }

    public Boolean exhpexpireAt(String key, String field, long unixTime, boolean noactive) {
        return this.exhpexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, noactive);
    }

    public Boolean exhpexpireAt(byte[] key, byte[] field, long unixTime) {
        return this.exhpexpireAt(key, field, unixTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exhpexpireAt(byte[] key, byte[] field, long unixTime, boolean noactive) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = noactive ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHPEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime), SafeEncoder.encode((String)"noactive")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHPEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean exhexpire(String key, String field, int seconds) {
        return this.exhexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), seconds);
    }

    public Boolean exhexpire(String key, String field, int seconds, boolean noactive) {
        return this.exhexpire(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), seconds, noactive);
    }

    public Boolean exhexpire(byte[] key, byte[] field, int seconds) {
        return this.exhexpire(key, field, seconds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exhexpire(byte[] key, byte[] field, int seconds, boolean noactive) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = noactive ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)seconds), SafeEncoder.encode((String)"noactive")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHEXPIRE, (byte[][])new byte[][]{key, field, Protocol.toByteArray((int)seconds)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean exhexpireAt(String key, String field, long unixTime) {
        return this.exhexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime);
    }

    public Boolean exhexpireAt(String key, String field, long unixTime, boolean noactive) {
        return this.exhexpireAt(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), unixTime, noactive);
    }

    public Boolean exhexpireAt(byte[] key, byte[] field, long unixTime) {
        return this.exhexpireAt(key, field, unixTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exhexpireAt(byte[] key, byte[] field, long unixTime, boolean noactive) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = noactive ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime), SafeEncoder.encode((String)"noactive")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHEXPIREAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)unixTime)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhpttl(String key, String field) {
        return this.exhpttl(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhpttl(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHPTTL, (byte[][])new byte[][]{key, field});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhttl(String key, String field) {
        return this.exhttl(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhttl(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHTTL, (byte[][])new byte[][]{key, field});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhver(String key, String field) {
        return this.exhver(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhver(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHVER, (byte[][])new byte[][]{key, field});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean exhsetver(String key, String field, long version) {
        return this.exhsetver(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exhsetver(byte[] key, byte[] field, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSETVER, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)version)});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhincrBy(String key, String field, long value) {
        return this.exhincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhincrBy(byte[] key, byte[] field, long value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHINCRBY, (byte[][])new byte[][]{key, field, Protocol.toByteArray((long)value)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhincrBy(String key, String field, long value, ExhincrByParams params) {
        return this.exhincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhincrBy(byte[] key, byte[] field, long value, ExhincrByParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHINCRBY, params.getByteParams(key, field, Protocol.toByteArray((long)value)));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Double exhincrByFloat(String key, String field, double value) {
        return this.exhincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double exhincrByFloat(byte[] key, byte[] field, double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHINCRBYFLOAT, (byte[][])new byte[][]{key, field, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Double exhincrByFloat(String key, String field, double value, ExhincrByFloatParams params) {
        return this.exhincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double exhincrByFloat(byte[] key, byte[] field, double value, ExhincrByFloatParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHINCRBYFLOAT, params.getByteParams(key, field, Protocol.toByteArray((double)value)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exhget(String key, String field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHGET, new String[]{key, field});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exhget(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHGET, (byte[][])new byte[][]{key, field});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExhgetwithverResult<String> exhgetwithver(String key, String field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHGETWITHVER, new String[]{key, field});
            ExhgetwithverResult exhgetwithverResult = (ExhgetwithverResult)HashBuilderFactory.EXHGETWITHVER_RESULT_STRING.build(obj);
            return exhgetwithverResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExhgetwithverResult<byte[]> exhgetwithver(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHGETWITHVER, (byte[][])new byte[][]{key, field});
            ExhgetwithverResult exhgetwithverResult = (ExhgetwithverResult)HashBuilderFactory.EXHGETWITHVER_RESULT_BYTE.build(obj);
            return exhgetwithverResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exhmget(String key, String ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHMGET, JoinParameters.joinParameters(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])fields)));
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exhmget(byte[] key, byte[] ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHMGET, JoinParameters.joinParameters(key, fields));
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExhgetwithverResult<String>> exhmgetwithver(String key, String ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHMGETWITHVER, JoinParameters.joinParameters(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])fields)));
            List list = (List)HashBuilderFactory.EXHMGETWITHVER_RESULT_STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExhgetwithverResult<byte[]>> exhmgetwithver(byte[] key, byte[] ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHMGETWITHVER, JoinParameters.joinParameters(key, fields));
            List list = (List)HashBuilderFactory.EXHMGETWITHVER_RESULT_BYTE_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhdel(String key, String ... fields) {
        return this.exhdel(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhdel(byte[] key, byte[] ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHDEL, JoinParameters.joinParameters(key, fields));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhlen(String key) {
        return this.exhlen(SafeEncoder.encode((String)key));
    }

    public Long exhlen(String key, boolean noexp) {
        return this.exhlen(SafeEncoder.encode((String)key), noexp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhlen(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHLEN, (byte[][])new byte[][]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhlen(byte[] key, boolean noexp) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = noexp ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHLEN, (byte[][])new byte[][]{key, SafeEncoder.encode((String)"noexp")}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHLEN, (byte[][])new byte[][]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean exhexists(String key, String field) {
        return this.exhexists(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exhexists(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHEXISTS, (byte[][])new byte[][]{key, field});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exhstrlen(String key, String field) {
        return this.exhstrlen(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exhstrlen(byte[] key, byte[] field) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSTRLEN, (byte[][])new byte[][]{key, field});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> exhkeys(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHKEYS, new String[]{key});
            Set set = (Set)Jedis3BuilderFactory.STRING_ZSET.build(obj);
            return set;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> exhkeys(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHKEYS, (byte[][])new byte[][]{key});
            Set set = (Set)Jedis3BuilderFactory.BYTE_ARRAY_ZSET.build(obj);
            return set;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exhvals(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHVALS, new String[]{key});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> exhvals(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHVALS, (byte[][])new byte[][]{key});
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> exhgetAll(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHGETALL, new String[]{key});
            Map map = (Map)BuilderFactory.STRING_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> exhgetAll(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHGETALL, (byte[][])new byte[][]{key});
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public ScanResult<Map.Entry<String, String>> exhscan(String key, String op, String subkey) {
        return this.exhscan(key, op, subkey, new ScanParams());
    }

    public ScanResult<Map.Entry<byte[], byte[]>> exhscan(byte[] key, byte[] op, byte[] subkey) {
        return this.exhscan(key, op, subkey, new ScanParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<String, String>> exhscan(String key, String op, String subkey, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)op));
        args.add(SafeEncoder.encode((String)subkey));
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_STRING.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<byte[], byte[]>> exhscan(byte[] key, byte[] op, byte[] subkey, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(op);
        args.add(subkey);
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_BYTE.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public ScanResult<Map.Entry<String, String>> exhscanunorder(String key, String cursor) {
        return this.exhscanunorder(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<byte[], byte[]>> exhscanunorder(byte[] key, byte[] cursor) {
        return this.exhscanunorder(key, cursor, new ScanParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<String, String>> exhscanunorder(String key, String cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)key));
        args.add(SafeEncoder.encode((String)cursor));
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSCANUNORDER, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_STRING.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<Map.Entry<byte[], byte[]>> exhscanunorder(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXHSCANUNORDER, (byte[][])args.toArray((T[])new byte[args.size()][]));
            ScanResult scanResult = (ScanResult)HashBuilderFactory.EXHSCAN_RESULT_BYTE.build(obj);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

