/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpRequestFactory;
import com.aliyun.oss.common.comm.IdleConnectionReaper;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.Header;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.HttpHost;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.auth.AuthScope;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.auth.NTCredentials;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.AuthCache;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.CredentialsProvider;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.config.RequestConfig;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.protocol.HttpClientContext;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.config.Registry;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.config.RegistryBuilder;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.config.SocketConfig;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.conn.HttpClientConnectionManager;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.conn.ssl.TrustStrategy;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.impl.auth.BasicScheme;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.impl.client.BasicAuthCache;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.impl.client.HttpClients;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.hadoop.fs.aliyun.shaded.org.apache.http.ssl.SSLContextBuilder;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    private static Method setNormalizeUriMethod = null;
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager = this.createHttpClientConnectionManager();
    protected RequestConfig requestConfig;
    protected CredentialsProvider credentialsProvider;
    protected HttpHost proxyHttpHost;
    protected AuthCache authCache;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(config.getConnectionTimeout());
        requestConfigBuilder.setSocketTimeout(config.getSocketTimeout());
        requestConfigBuilder.setConnectionRequestTimeout(config.getConnectionRequestTimeout());
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            this.proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            requestConfigBuilder.setProxy(this.proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                this.credentialsProvider = new BasicCredentialsProvider();
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                this.authCache = new BasicAuthCache();
                this.authCache.put(this.proxyHttpHost, new BasicScheme());
            }
        }
        if (setNormalizeUriMethod != null) {
            try {
                setNormalizeUriMethod.invoke((Object)requestConfigBuilder, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.requestConfig = requestConfigBuilder.build();
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request, context);
        this.setProxyAuthorizationIfNeed(httpRequest);
        HttpClientContext httpContext = this.createHttpContext();
        httpContext.setRequestConfig(this.requestConfig);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    protected static ResponseMessage buildResponse(ServiceClient.Request request, CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage(request);
        response.setUrl(request.getUri());
        response.setHttpResponse(httpResponse);
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            if (response.isSuccessful()) {
                response.setContent(httpResponse.getEntity().getContent());
            } else {
                DefaultServiceClient.readAndSetErrorResponse(httpResponse.getEntity().getContent(), response);
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            if ("Content-Length".equals(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    private static void readAndSetErrorResponse(InputStream originalContent, ResponseMessage response) throws IOException {
        byte[] contentBytes = IOUtils.readStreamAsByteArray(originalContent);
        response.setErrorResponseAsString(new String(contentBytes));
        response.setContent(new ByteArrayInputStream(contentBytes));
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    protected CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).setUserAgent(this.config.getUserAgent()).disableContentCompression().disableAutomaticRetries().build();
    }

    protected HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage());
        }
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register(Protocol.HTTP.toString(), PlainConnectionSocketFactory.getSocketFactory()).register(Protocol.HTTPS.toString(), (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        connectionManager.setValidateAfterInactivity(this.config.getValidateAfterInactivity());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.config.getSocketTimeout()).setTcpNoDelay(true).build());
        if (this.config.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.config.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager(connectionManager);
        }
        return connectionManager;
    }

    protected HttpClientContext createHttpContext() {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        if (this.credentialsProvider != null) {
            httpContext.setCredentialsProvider(this.credentialsProvider);
            httpContext.setAuthCache(this.authCache);
        }
        return httpContext;
    }

    private void setProxyAuthorizationIfNeed(HttpRequestBase httpRequest) {
        if (this.credentialsProvider != null) {
            String auth = this.config.getProxyUsername() + ":" + this.config.getProxyPassword();
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes());
            String authHeader = "Basic " + new String(encodedAuth);
            httpRequest.addHeader("Proxy-Authorization", authHeader);
        }
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    private static Method getClassMethd(Class<?> clazz, String methodName) {
        try {
            Method[] method;
            for (Method m : method = clazz.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                return m;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            setNormalizeUriMethod = DefaultServiceClient.getClassMethd(Class.forName("org.apache.hadoop.fs.aliyun.shaded.org.apache.http.client.config.RequestConfig$Builder"), "setNormalizeUri");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException) {
                errorCode = ((ClientException)ex).getErrorCode();
                if (errorCode.equals("ConnectionTimeout") || errorCode.equals("SocketTimeout") || errorCode.equals("ConnectionRefused") || errorCode.equals("UnknownHost") || errorCode.equals("SocketException")) {
                    return true;
                }
                if (errorCode.equals("NonRepeatableRequest")) {
                    return false;
                }
            }
            if (ex instanceof OSSException && (errorCode = ((OSSException)ex).getErrorCode()).equals("InvalidResponse")) {
                return false;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

