/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.InconsistentException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CRC64;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.internal.OSSObjectOperation;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class OSSDownloadOperation {
    private OSSObjectOperation objectOperation;

    protected OSSObject getObjectWrap(GetObjectRequest getObjectRequest) {
        return this.objectOperation.getObject(getObjectRequest);
    }

    protected Long getInputStreamCRCWrap(InputStream inputStream) {
        return IOUtils.getCRCValue(inputStream);
    }

    public OSSDownloadOperation(OSSObjectOperation objectOperation) {
        this.objectOperation = objectOperation;
    }

    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws Throwable {
        CodingUtils.assertParameterNotNull(downloadFileRequest, "downloadFileRequest");
        String bucketName = downloadFileRequest.getBucketName();
        String key = downloadFileRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        if (downloadFileRequest.getDownloadFile() == null) {
            downloadFileRequest.setDownloadFile(downloadFileRequest.getKey());
        }
        if (downloadFileRequest.isEnableCheckpoint() && (downloadFileRequest.getCheckpointFile() == null || downloadFileRequest.getCheckpointFile().isEmpty())) {
            String versionId = downloadFileRequest.getVersionId();
            if (versionId != null) {
                downloadFileRequest.setCheckpointFile(downloadFileRequest.getDownloadFile() + "." + BinaryUtil.encodeMD5(versionId.getBytes()) + ".dcp");
            } else {
                downloadFileRequest.setCheckpointFile(downloadFileRequest.getDownloadFile() + ".dcp");
            }
        }
        return this.downloadFileWithCheckpoint(downloadFileRequest);
    }

    private DownloadFileResult downloadFileWithCheckpoint(DownloadFileRequest downloadFileRequest) throws Throwable {
        DownloadFileResult downloadFileResult = new DownloadFileResult();
        DownloadCheckPoint downloadCheckPoint = new DownloadCheckPoint();
        if (downloadFileRequest.isEnableCheckpoint()) {
            try {
                downloadCheckPoint.load(downloadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                this.remove(downloadFileRequest.getCheckpointFile());
            }
            if (!downloadCheckPoint.isValid(this.objectOperation, downloadFileRequest)) {
                this.prepare(downloadCheckPoint, downloadFileRequest);
                this.remove(downloadFileRequest.getCheckpointFile());
            }
        } else {
            this.prepare(downloadCheckPoint, downloadFileRequest);
        }
        ProgressListener listener = downloadFileRequest.getProgressListener();
        ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
        DownloadResult downloadResult = this.download(downloadCheckPoint, downloadFileRequest);
        Long serverCRC = null;
        for (PartResult partResult : downloadResult.getPartResults()) {
            if (partResult.getServerCRC() != null) {
                serverCRC = partResult.getServerCRC();
            }
            if (!partResult.isFailed()) continue;
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_PART_FAILED_EVENT);
            throw partResult.getException();
        }
        if (this.objectOperation.getInnerClient().getClientConfiguration().isCrcCheckEnabled() && !this.hasRangeInRequest(downloadFileRequest)) {
            Long clientCRC = OSSDownloadOperation.calcObjectCRCFromParts(downloadResult.getPartResults());
            try {
                OSSUtils.checkChecksum(clientCRC, serverCRC, downloadResult.getObjectMetadata().getRequestId());
            }
            catch (Exception e) {
                ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
                throw new InconsistentException(clientCRC, serverCRC, downloadResult.getObjectMetadata().getRequestId());
            }
        }
        ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        OSSDownloadOperation.renameTo(downloadFileRequest.getTempDownloadFile(), downloadFileRequest.getDownloadFile());
        if (downloadFileRequest.isEnableCheckpoint()) {
            this.remove(downloadFileRequest.getCheckpointFile());
        }
        downloadFileResult.setObjectMetadata(downloadResult.getObjectMetadata());
        return downloadFileResult;
    }

    private void prepare(DownloadCheckPoint downloadCheckPoint, DownloadFileRequest downloadFileRequest) throws IOException {
        long downloadSize;
        downloadCheckPoint.magic = "92611BED-89E2-46B6-89E5-72F273D4B0A3";
        downloadCheckPoint.downloadFile = downloadFileRequest.getDownloadFile();
        downloadCheckPoint.bucketName = downloadFileRequest.getBucketName();
        downloadCheckPoint.objectKey = downloadFileRequest.getKey();
        downloadCheckPoint.objectStat = ObjectStat.getFileStat(this.objectOperation, downloadFileRequest);
        if (downloadCheckPoint.objectStat.size > 0L) {
            long[] slice = this.getSlice(downloadFileRequest.getRange(), downloadCheckPoint.objectStat.size);
            downloadCheckPoint.downloadParts = this.splitFile(slice[0], slice[1], downloadFileRequest.getPartSize());
            downloadSize = slice[1];
        } else {
            downloadSize = 0L;
            downloadCheckPoint.downloadParts = this.splitOneFile();
        }
        OSSDownloadOperation.createFixedFile(downloadFileRequest.getTempDownloadFile(), downloadSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFixedFile(String filePath, long length) throws IOException {
        File file = new File(filePath);
        RandomAccessFile rf = null;
        try {
            rf = new RandomAccessFile(file, "rw");
            rf.setLength(length);
        }
        finally {
            if (rf != null) {
                rf.close();
            }
        }
    }

    private static Long calcObjectCRCFromParts(List<PartResult> partResults) {
        long crc = 0L;
        for (PartResult partResult : partResults) {
            if (partResult.getClientCRC() == null || partResult.getLength() <= 0L) {
                return null;
            }
            crc = CRC64.combine(crc, partResult.getClientCRC(), partResult.getLength());
        }
        return new Long(crc);
    }

    private DownloadResult download(DownloadCheckPoint downloadCheckPoint, DownloadFileRequest downloadFileRequest) throws Throwable {
        int i;
        DownloadResult downloadResult = new DownloadResult();
        ArrayList<PartResult> taskResults = new ArrayList<PartResult>();
        ExecutorService service = Executors.newFixedThreadPool(downloadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ArrayList<Task> tasks = new ArrayList<Task>();
        ProgressListener listener = downloadFileRequest.getProgressListener();
        long contentLength = 0L;
        for (i = 0; i < downloadCheckPoint.downloadParts.size(); ++i) {
            if (downloadCheckPoint.downloadParts.get((int)i).isCompleted) continue;
            long l = downloadCheckPoint.downloadParts.get((int)i).end - downloadCheckPoint.downloadParts.get((int)i).start + 1L;
            contentLength += l;
        }
        ProgressPublisher.publishResponseContentLength(listener, contentLength);
        downloadFileRequest.setProgressListener(null);
        for (i = 0; i < downloadCheckPoint.downloadParts.size(); ++i) {
            if (!downloadCheckPoint.downloadParts.get((int)i).isCompleted) {
                Task task = new Task(i, "download-" + i, downloadCheckPoint, i, downloadFileRequest, this.objectOperation, listener);
                futures.add(service.submit(task));
                tasks.add(task);
                continue;
            }
            taskResults.add(new PartResult(i + 1, downloadCheckPoint.downloadParts.get((int)i).start, downloadCheckPoint.downloadParts.get((int)i).end, downloadCheckPoint.downloadParts.get((int)i).length, downloadCheckPoint.downloadParts.get((int)i).crc));
        }
        service.shutdown();
        service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                taskResults.add(tr);
            }
            catch (ExecutionException e) {
                downloadFileRequest.setProgressListener(listener);
                throw e.getCause();
            }
        }
        Collections.sort(taskResults, new Comparator<PartResult>(){

            @Override
            public int compare(PartResult p1, PartResult p2) {
                return p1.getNumber() - p2.getNumber();
            }
        });
        downloadResult.setPartResults(taskResults);
        if (tasks.size() > 0) {
            downloadResult.setObjectMetadata(((Task)tasks.get(0)).GetobjectMetadata());
        }
        downloadFileRequest.setProgressListener(listener);
        return downloadResult;
    }

    private boolean hasRangeInRequest(DownloadFileRequest downloadFileRequest) {
        return downloadFileRequest.getRange() != null;
    }

    private ArrayList<DownloadPart> splitFile(long start, long objectSize, long partSize) {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        long partNum = objectSize / partSize;
        if (partNum >= 10000L) {
            partSize = objectSize / 9999L;
        }
        int i = 0;
        for (long offset = 0L; offset < objectSize; offset += partSize) {
            DownloadPart part = new DownloadPart();
            part.index = i++;
            part.start = offset + start;
            part.end = this.getPartEnd(offset, objectSize, partSize) + start;
            part.fileStart = offset;
            parts.add(part);
        }
        return parts;
    }

    private long getPartEnd(long begin, long total, long per) {
        if (begin + per > total) {
            return total - 1L;
        }
        return begin + per - 1L;
    }

    private ArrayList<DownloadPart> splitOneFile() {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        DownloadPart part = new DownloadPart();
        part.index = 0;
        part.start = 0L;
        part.end = -1L;
        part.fileStart = 0L;
        parts.add(part);
        return parts;
    }

    private long[] getSlice(long[] range, long totalSize) {
        long start = 0L;
        long size = totalSize;
        if (!(range == null || range.length != 2 || totalSize < 1L || range[0] < 0L && range[1] < 0L || range[0] > 0L && range[1] > 0L && range[0] > range[1] || range[0] >= totalSize)) {
            long begin = range[0];
            long end = range[1];
            if (range[0] < 0L) {
                begin = 0L;
            }
            if (range[1] < 0L || range[1] >= totalSize) {
                end = totalSize - 1L;
            }
            start = begin;
            size = end - begin + 1L;
        }
        return new long[]{start, size};
    }

    private boolean remove(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    private static void renameTo(String srcFilePath, String destFilePath) throws IOException {
        File srcfile = new File(srcFilePath);
        File destfile = new File(destFilePath);
        OSSDownloadOperation.moveFile(srcfile, destfile);
    }

    private static void moveFile(File srcFile, File destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' is a directory");
        }
        if (destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' is a directory");
        }
        if (destFile.exists() && !destFile.delete()) {
            throw new IOException("Failed to delete original file '" + srcFile + "'");
        }
        boolean rename = srcFile.renameTo(destFile);
        if (!rename) {
            OSSDownloadOperation.copyFile(srcFile, destFile);
            if (!srcFile.delete()) {
                throw new IOException("Failed to delete original file '" + srcFile + "' after copy to '" + destFile + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File dest) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    class Task
    implements Callable<PartResult> {
        private int id;
        private String name;
        private DownloadCheckPoint downloadCheckPoint;
        private int partIndex;
        private DownloadFileRequest downloadFileRequest;
        private OSSObjectOperation objectOperation;
        private ObjectMetadata objectMetadata;
        private ProgressListener progressListener;

        public Task(int id, String name, DownloadCheckPoint downloadCheckPoint, int partIndex, DownloadFileRequest downloadFileRequest, OSSObjectOperation objectOperation, ProgressListener progressListener) {
            this.id = id;
            this.name = name;
            this.downloadCheckPoint = downloadCheckPoint;
            this.partIndex = partIndex;
            this.downloadFileRequest = downloadFileRequest;
            this.objectOperation = objectOperation;
            this.progressListener = progressListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartResult call() throws Exception {
            PartResult tr = null;
            RandomAccessFile output = null;
            InputStream content = null;
            try {
                int limit;
                Payer payer;
                DownloadPart downloadPart = this.downloadCheckPoint.downloadParts.get(this.partIndex);
                tr = new PartResult(this.partIndex + 1, downloadPart.start, downloadPart.end);
                output = new RandomAccessFile(this.downloadFileRequest.getTempDownloadFile(), "rw");
                output.seek(downloadPart.fileStart);
                GetObjectRequest getObjectRequest = new GetObjectRequest(this.downloadFileRequest.getBucketName(), this.downloadFileRequest.getKey());
                getObjectRequest.setMatchingETagConstraints(this.downloadFileRequest.getMatchingETagConstraints());
                getObjectRequest.setNonmatchingETagConstraints(this.downloadFileRequest.getNonmatchingETagConstraints());
                getObjectRequest.setModifiedSinceConstraint(this.downloadFileRequest.getModifiedSinceConstraint());
                getObjectRequest.setUnmodifiedSinceConstraint(this.downloadFileRequest.getUnmodifiedSinceConstraint());
                getObjectRequest.setResponseHeaders(this.downloadFileRequest.getResponseHeaders());
                getObjectRequest.setRange(downloadPart.start, downloadPart.end);
                String versionId = this.downloadFileRequest.getVersionId();
                if (versionId != null) {
                    getObjectRequest.setVersionId(versionId);
                }
                if ((payer = this.downloadFileRequest.getRequestPayer()) != null) {
                    getObjectRequest.setRequestPayer(payer);
                }
                if ((limit = this.downloadFileRequest.getTrafficLimit()) > 0) {
                    getObjectRequest.setTrafficLimit(limit);
                }
                OSSObject ossObj = OSSDownloadOperation.this.getObjectWrap(getObjectRequest);
                this.objectMetadata = ossObj.getObjectMetadata();
                content = ossObj.getObjectContent();
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while ((bytesRead = content.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                if (this.objectOperation.getInnerClient().getClientConfiguration().isCrcCheckEnabled()) {
                    Long clientCRC = OSSDownloadOperation.this.getInputStreamCRCWrap(content);
                    tr.setClientCRC(clientCRC);
                    tr.setServerCRC(this.objectMetadata.getServerCRC());
                    tr.setLength(this.objectMetadata.getContentLength());
                    downloadPart.length = this.objectMetadata.getContentLength();
                    downloadPart.crc = clientCRC;
                }
                this.downloadCheckPoint.update(this.partIndex, true);
                if (this.downloadFileRequest.isEnableCheckpoint()) {
                    this.downloadCheckPoint.dump(this.downloadFileRequest.getCheckpointFile());
                }
                ProgressPublisher.publishResponseBytesTransferred(this.progressListener, downloadPart.end - downloadPart.start + 1L);
            }
            catch (Exception e) {
                tr.setFailed(true);
                tr.setException(e);
                LogUtils.logException(String.format("Task %d:%s upload part %d failed: ", this.id, this.name, this.partIndex), e);
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (content != null) {
                    content.close();
                }
            }
            return tr;
        }

        public ObjectMetadata GetobjectMetadata() {
            return this.objectMetadata;
        }
    }

    static class DownloadResult {
        private List<PartResult> partResults;
        private ObjectMetadata objectMetadata;

        DownloadResult() {
        }

        public List<PartResult> getPartResults() {
            return this.partResults;
        }

        public void setPartResults(List<PartResult> partResults) {
            this.partResults = partResults;
        }

        public ObjectMetadata getObjectMetadata() {
            return this.objectMetadata;
        }

        public void setObjectMetadata(ObjectMetadata objectMetadata) {
            this.objectMetadata = objectMetadata;
        }
    }

    static class PartResult {
        private int number;
        private long start;
        private long end;
        private boolean failed;
        private Exception exception;
        private Long clientCRC;
        private Long serverCRC;
        private long length;

        public PartResult(int number, long start, long end) {
            this.number = number;
            this.start = start;
            this.end = end;
        }

        public PartResult(int number, long start, long end, long length, long clientCRC) {
            this.number = number;
            this.start = start;
            this.end = end;
            this.length = length;
            this.clientCRC = clientCRC;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setFailed(boolean failed) {
            this.failed = failed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Long getClientCRC() {
            return this.clientCRC;
        }

        public void setClientCRC(Long clientCRC) {
            this.clientCRC = clientCRC;
        }

        public Long getServerCRC() {
            return this.serverCRC;
        }

        public void setServerCRC(Long serverCRC) {
            this.serverCRC = serverCRC;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }
    }

    static class DownloadPart
    implements Serializable {
        private static final long serialVersionUID = -3655925846487976207L;
        public int index;
        public long start;
        public long end;
        public boolean isCompleted;
        public long length;
        public long crc;
        public long fileStart;

        DownloadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.isCompleted ? 1231 : 1237);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            result = 31 * result + (int)(this.crc ^ this.crc >>> 32);
            result = 31 * result + (int)(this.fileStart ^ this.fileStart >>> 32);
            return result;
        }
    }

    static class ObjectStat
    implements Serializable {
        private static final long serialVersionUID = -2883494783412999919L;
        public long size;
        public Date lastModified;
        public String digest;

        ObjectStat() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public static ObjectStat getFileStat(OSSObjectOperation objectOperation, DownloadFileRequest downloadFileRequest) {
            String versionId;
            String bucketName = downloadFileRequest.getBucketName();
            String key = downloadFileRequest.getKey();
            GenericRequest genericRequest = new GenericRequest(bucketName, key);
            Payer payer = downloadFileRequest.getRequestPayer();
            if (payer != null) {
                genericRequest.setRequestPayer(payer);
            }
            if ((versionId = downloadFileRequest.getVersionId()) != null) {
                genericRequest.setVersionId(versionId);
            }
            SimplifiedObjectMeta meta = objectOperation.getSimplifiedObjectMeta(genericRequest);
            ObjectStat objStat = new ObjectStat();
            objStat.size = meta.getSize();
            objStat.lastModified = meta.getLastModified();
            objStat.digest = meta.getETag();
            return objStat;
        }
    }

    static class DownloadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 4682293344365787077L;
        private static final String DOWNLOAD_MAGIC = "92611BED-89E2-46B6-89E5-72F273D4B0A3";
        public String magic;
        public int md5;
        public String downloadFile;
        public String bucketName;
        public String objectKey;
        public ObjectStat objectStat;
        public ArrayList<DownloadPart> downloadParts;

        DownloadCheckPoint() {
        }

        public synchronized void load(String cpFile) throws IOException, ClassNotFoundException {
            FileInputStream fileIn = new FileInputStream(cpFile);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            DownloadCheckPoint dcp = (DownloadCheckPoint)in.readObject();
            this.assign(dcp);
            in.close();
            fileIn.close();
        }

        public synchronized void dump(String cpFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOut = new FileOutputStream(cpFile);
            ObjectOutputStream outStream = new ObjectOutputStream(fileOut);
            outStream.writeObject(this);
            outStream.close();
            fileOut.close();
        }

        public synchronized void update(int index, boolean completed) throws IOException {
            this.downloadParts.get((int)index).isCompleted = completed;
        }

        public synchronized boolean isValid(OSSObjectOperation objectOperation, DownloadFileRequest downloadFileRequest) {
            SimplifiedObjectMeta meta;
            String versionId;
            if (this.magic == null || !this.magic.equals(DOWNLOAD_MAGIC) || this.md5 != this.hashCode()) {
                return false;
            }
            GenericRequest genericRequest = new GenericRequest(this.bucketName, this.objectKey);
            Payer payer = downloadFileRequest.getRequestPayer();
            if (payer != null) {
                genericRequest.setRequestPayer(payer);
            }
            if ((versionId = downloadFileRequest.getVersionId()) != null) {
                genericRequest.setVersionId(versionId);
            }
            return this.objectStat.size == (meta = objectOperation.getSimplifiedObjectMeta(genericRequest)).getSize() && this.objectStat.lastModified.equals(meta.getLastModified()) && this.objectStat.digest.equals(meta.getETag());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.downloadFile == null ? 0 : this.downloadFile.hashCode());
            result = 31 * result + (this.magic == null ? 0 : this.magic.hashCode());
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.objectStat == null ? 0 : this.objectStat.hashCode());
            result = 31 * result + (this.downloadParts == null ? 0 : this.downloadParts.hashCode());
            return result;
        }

        private void assign(DownloadCheckPoint dcp) {
            this.magic = dcp.magic;
            this.md5 = dcp.md5;
            this.downloadFile = dcp.downloadFile;
            this.bucketName = dcp.bucketName;
            this.objectKey = dcp.objectKey;
            this.objectStat = dcp.objectStat;
            this.downloadParts = dcp.downloadParts;
        }
    }
}

