/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry.conditions;

import com.aliyun.core.utils.Validate;
import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.conditions.RetryCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class StatusCodeCondition
implements RetryCondition {
    private final Set<Integer> statusCodesToRetryOn;

    private StatusCodeCondition(Set<Integer> statusCodesToRetryOn) {
        this.statusCodesToRetryOn = new HashSet<Integer>((Collection)Validate.paramNotNull(statusCodesToRetryOn, (String)"statusCodesToRetryOn"));
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return Optional.ofNullable(context.httpStatusCode()).map(s -> this.statusCodesToRetryOn.stream().anyMatch(code -> code.equals(s))).orElse(false);
    }

    public static StatusCodeCondition create(Set<Integer> statusCodesToRetryOn) {
        return new StatusCodeCondition(statusCodesToRetryOn);
    }

    public static StatusCodeCondition create(Integer ... statusCodesToRetryOn) {
        return new StatusCodeCondition(Arrays.stream(statusCodesToRetryOn).collect(Collectors.toSet()));
    }
}

