/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy;

import com.aliyun.core.utils.Configuration;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class UserAgentPolicy {
    private static final String DEFAULT_USER_AGENT_HEADER = "AlibabaCloud";
    private static final int MAX_APP_ID_LENGTH = 50;
    private static String coreVersion = "unknown";

    public static String toUserAgentString(String serviceName) {
        return UserAgentPolicy.toUserAgentString(serviceName, new Configuration());
    }

    public static String toUserAgentString(String serviceName, Configuration configuration) {
        StringBuilder userAgentBuilder = new StringBuilder();
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osArch = Configuration.getGlobalConfiguration().get("os.arch");
        userAgentBuilder.append(String.format("%s (%s; %s) Java/%s AsyncCoreService/%s", DEFAULT_USER_AGENT_HEADER, osName, osArch, javaVersion, coreVersion)).append(" ").append("TeaDSL/1");
        if (serviceName != null) {
            serviceName = serviceName.length() > 50 ? serviceName.substring(0, 50) : serviceName;
            userAgentBuilder.append(" ").append("alibabacloud-").append(serviceName.toLowerCase(Locale.ROOT));
        }
        return userAgentBuilder.toString();
    }

    static {
        try {
            Properties props = new Properties();
            props.load(UserAgentPolicy.class.getClassLoader().getResourceAsStream("core.properties"));
            coreVersion = props.getProperty("sdk.project.version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

