/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.webflux;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcHeadersCarrier;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcTracer;
import com.alipay.sofa.tracer.plugins.webflux.SofaTraceableRequest;
import com.alipay.sofa.tracer.plugins.webflux.SofaTraceableResponse;
import java.net.URI;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebfluxSofaTracerFilter
implements WebFilter {
    @Value(value="${spring.application.name}")
    private String appName = "";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        SpringMvcTracer springMvcTracer = SpringMvcTracer.getSpringMvcTracerSingleton();
        SofaTracer tracer = springMvcTracer.getSofaTracer();
        ServerWebExchangeSofaTraceableRequest request = new ServerWebExchangeSofaTraceableRequest(exchange);
        SofaTracerSpanContext spanContext = (SofaTracerSpanContext)tracer.extract(ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new SpringMvcHeadersCarrier(new HashMap<String, String>(request.getHeaders().toSingleValueMap())));
        spanContext.setSpanId(spanContext.nextChildContextId());
        SofaTracerSpan springMvcSpan = springMvcTracer.serverReceive(spanContext);
        springMvcSpan.setOperationName(request.getUri().getPath());
        springMvcSpan.setTag("local.app", this.appName);
        springMvcSpan.setTag("remote.app", request.getRemoteAddress());
        springMvcSpan.setTag("request.url", request.getUri().toString());
        springMvcSpan.setTag("method", request.getMethod());
        springMvcSpan.setTag("req.size.bytes", (Number)request.getHeaders().getContentLength());
        return chain.filter(exchange).doAfterSuccessOrError((aVoid, throwable) -> {
            ServerWebExchangeSofaTraceableResponse response = new ServerWebExchangeSofaTraceableResponse((ServerHttpResponse)(throwable != null ? new SofaStatusResponseDecorator((Throwable)throwable, exchange.getResponse()) : exchange.getResponse()));
            springMvcSpan.setTag("resp.size.bytes", (Number)response.getHeaders().getContentLength());
            springMvcTracer.serverSend(String.valueOf(response.getStatus()));
        });
    }

    static class ServerWebExchangeSofaTraceableRequest
    implements SofaTraceableRequest {
        private final String method;
        private final HttpHeaders headers;
        private final URI uri;
        private final String remoteAddress;

        ServerWebExchangeSofaTraceableRequest(ServerWebExchange exchange) {
            ServerHttpRequest request = exchange.getRequest();
            this.method = request.getMethodValue();
            this.headers = request.getHeaders();
            this.uri = request.getURI();
            this.remoteAddress = request.getRemoteAddress() != null ? request.getRemoteAddress().getAddress().toString() : "";
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public String getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    static class ServerWebExchangeSofaTraceableResponse
    implements SofaTraceableResponse {
        private final ServerHttpResponse responseDecorator;

        ServerWebExchangeSofaTraceableResponse(ServerHttpResponse responseDecorator) {
            this.responseDecorator = responseDecorator;
        }

        @Override
        public int getStatus() {
            return this.responseDecorator.getStatusCode() != null ? this.responseDecorator.getStatusCode().value() : 200;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.responseDecorator.getHeaders();
        }
    }

    static class SofaStatusResponseDecorator
    extends ServerHttpResponseDecorator {
        private final HttpStatus status;

        SofaStatusResponseDecorator(Throwable throwable, ServerHttpResponse delegate) {
            super(delegate);
            this.status = throwable instanceof ResponseStatusException ? ((ResponseStatusException)throwable).getStatus() : HttpStatus.INTERNAL_SERVER_ERROR;
        }

        public HttpStatus getStatusCode() {
            return this.status;
        }
    }
}

