/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.grpc;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.grpc.GrpcClientInvoker;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

@Extension(value="grpc")
public class GrpcClientTransport
extends ClientTransport {
    private ProviderInfo providerInfo;
    private ManagedChannel channel;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClientTransport.class);

    public GrpcClientTransport(ClientTransportConfig transportConfig) {
        super(transportConfig);
        this.providerInfo = transportConfig.getProviderInfo();
        this.connect();
        this.remoteAddress = InetSocketAddress.createUnresolved(this.providerInfo.getHost(), this.providerInfo.getPort());
        this.localAddress = InetSocketAddress.createUnresolved(SystemInfo.getLocalHost(), 0);
    }

    @Override
    public void connect() {
        if (this.isAvailable()) {
            return;
        }
        ProviderInfo providerInfo = this.transportConfig.getProviderInfo();
        this.channel = ManagedChannelBuilder.forAddress((String)providerInfo.getHost(), (int)providerInfo.getPort()).usePlaintext().build();
    }

    @Override
    public void disconnect() {
        if (this.channel != null) {
            try {
                this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("GRPC channel shut down interrupted.");
            }
            this.channel = null;
        }
    }

    @Override
    public void destroy() {
        this.disconnect();
    }

    @Override
    public boolean isAvailable() {
        if (this.channel == null) {
            return false;
        }
        ConnectivityState state = this.channel.getState(true);
        return state == ConnectivityState.IDLE || state == ConnectivityState.READY || state == ConnectivityState.CONNECTING;
    }

    @Override
    public void setChannel(AbstractChannel channel) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public AbstractChannel getChannel() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int currentRequests() {
        return 0;
    }

    @Override
    public ResponseFuture asyncSend(SofaRequest message, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public SofaResponse syncSend(SofaRequest request, int timeout) throws SofaRpcException {
        try {
            SofaResponse r = new GrpcClientInvoker(request, (Channel)this.channel).invoke();
            return r;
        }
        catch (Exception e) {
            throw new SofaRpcException(299, "Grpc invoke error", e);
        }
    }

    @Override
    public void oneWaySend(SofaRequest message, int timeout) throws SofaRpcException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void receiveRpcResponse(SofaResponse response) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void handleRpcRequest(SofaRequest request) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }
}

