/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.rest;

import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.rest.SofaResourceFactory;
import com.alipay.sofa.rpc.server.rest.SofaResourceMethodInvoker;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;

@Provider
@Priority(value=100)
public class LookoutRequestFilter
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(LookoutRequestFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            SofaResourceMethodInvoker resourceMethodInvoker = (SofaResourceMethodInvoker)((PostMatchContainerRequestContext)requestContext).getResourceMethod();
            SofaResourceFactory factory = resourceMethodInvoker.getResource();
            String serviceName = factory.getServiceName();
            String appName = factory.getAppName();
            if (serviceName == null) {
                serviceName = resourceMethodInvoker.getResourceClass().getName();
            }
            String methodName = resourceMethodInvoker.getMethod().getName();
            RpcInternalContext context = RpcInternalContext.getContext();
            context.setAttachment("_rest_service", serviceName);
            context.setAttachment("_rest_methodname", methodName);
            context.setAttachment("app", appName);
        }
        catch (Exception e) {
            logger.error(LogCodes.getLog("020090005"), e);
        }
    }
}

