/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.grpc;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.Server;
import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.util.MutableHandlerRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="grpc")
public class GrpcServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcServer.class);
    protected ServerConfig serverConfig;
    protected volatile boolean started;
    protected io.grpc.Server server;
    protected MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
    protected ConcurrentHashMap<BindableService, ServerServiceDefinition> serviceInfo = new ConcurrentHashMap();
    protected AtomicInteger invokerCnt = new AtomicInteger();

    @Override
    public void init(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.server = ServerBuilder.forPort((int)serverConfig.getPort()).fallbackHandlerRegistry((HandlerRegistry)this.handlerRegistry).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.started) {
            return;
        }
        GrpcServer grpcServer = this;
        synchronized (grpcServer) {
            try {
                this.server.start();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Start the grpc server at port {}", this.serverConfig.getPort());
                }
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000028", "grpc", this.serverConfig.getPort()), e);
            }
            this.started = true;
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasNoEntry() {
        return false;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stop the http rest server at port {}", this.serverConfig.getPort());
            }
            this.server.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("Stop the http rest server at port " + this.serverConfig.getPort() + " error !", e);
        }
        this.started = false;
    }

    @Override
    public void registerProcessor(ProviderConfig providerConfig, Invoker instance) {
        BindableService bindableService = (BindableService)providerConfig.getRef();
        ServerServiceDefinition serverServiceDefinition = bindableService.bindService();
        this.serviceInfo.put(bindableService, serverServiceDefinition);
        try {
            this.handlerRegistry.addService(serverServiceDefinition);
            this.invokerCnt.incrementAndGet();
        }
        catch (Exception e) {
            LOGGER.error("Register grpc service error", e);
            this.serviceInfo.remove(bindableService);
        }
    }

    @Override
    public void unRegisterProcessor(ProviderConfig providerConfig, boolean closeIfNoEntry) {
        try {
            ServerServiceDefinition serverServiceDefinition = this.serviceInfo.get(providerConfig.getRef());
            this.handlerRegistry.removeService(serverServiceDefinition);
            this.invokerCnt.decrementAndGet();
        }
        catch (Exception e) {
            LOGGER.error("Unregister grpc service error", e);
        }
        if (closeIfNoEntry && this.invokerCnt.get() == 0) {
            this.stop();
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.server = null;
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (hook != null) {
            hook.preDestroy();
        }
        this.destroy();
        if (hook != null) {
            hook.postDestroy();
        }
    }
}

