/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProviderInvoker<T>
extends FilterInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderInvoker.class);
    private final ProviderConfig<T> providerConfig;
    private static Field causeField;

    public ProviderInvoker(ProviderConfig<T> providerConfig) {
        super(providerConfig);
        this.providerConfig = providerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        SofaResponse sofaResponse = new SofaResponse();
        long startTime = RpcRuntimeContext.now();
        try {
            Method method = request.getMethod();
            if (method == null) {
                throw new SofaRpcException(170, LogCodes.getLog("020120003"));
            }
            Object result = method.invoke(this.providerConfig.getRef(), request.getMethodArgs());
            sofaResponse.setAppResponse(result);
        }
        catch (IllegalArgumentException e) {
            sofaResponse.setErrorMsg(e.getMessage());
        }
        catch (IllegalAccessException e) {
            sofaResponse.setErrorMsg(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.cutCause(e.getCause());
            sofaResponse.setAppResponse(e.getCause());
        }
        finally {
            if (RpcInternalContext.isAttachmentEnable()) {
                long endTime = RpcRuntimeContext.now();
                RpcInternalContext.getContext().setAttachment("_impl_elapse", endTime - startTime);
            }
        }
        return sofaResponse;
    }

    public void cutCause(Throwable bizException) {
        if (causeField == null) {
            return;
        }
        Throwable rootCause = bizException;
        while (null != rootCause.getCause()) {
            rootCause = rootCause.getCause();
        }
        if (rootCause != bizException) {
            bizException.setStackTrace(rootCause.getStackTrace());
            try {
                causeField.set(bizException, bizException);
            }
            catch (Exception e) {
                LOGGER.warnWithApp(null, LogCodes.getLog("019990008"), e);
            }
        }
    }

    static {
        try {
            causeField = Throwable.class.getDeclaredField("cause");
            causeField.setAccessible(true);
        }
        catch (Exception e) {
            causeField = null;
            LOGGER.warnWithApp(null, "error  fetch causeField in ProviderInvoker", e);
        }
    }
}

