/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.context;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.ThreadPoolUtils;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class AsyncRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncRuntime.class);
    private static volatile ThreadPoolExecutor asyncThreadPool;

    public static ThreadPoolExecutor getAsyncThreadPool() {
        return AsyncRuntime.getAsyncThreadPool(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getAsyncThreadPool(boolean build) {
        if (asyncThreadPool != null || !build) return asyncThreadPool;
        Class<AsyncRuntime> clazz = AsyncRuntime.class;
        synchronized (AsyncRuntime.class) {
            if (asyncThreadPool != null || !build) return asyncThreadPool;
            int coresize = RpcConfigs.getIntValue("async.pool.core");
            int maxsize = RpcConfigs.getIntValue("async.pool.max");
            int queuesize = RpcConfigs.getIntValue("async.pool.queue");
            int keepAliveTime = RpcConfigs.getIntValue("async.pool.time");
            BlockingQueue<Runnable> queue = ThreadPoolUtils.buildQueue(queuesize);
            NamedThreadFactory threadFactory = new NamedThreadFactory("RPC-CB", true);
            RejectedExecutionHandler handler = new RejectedExecutionHandler(){
                private int i = 1;

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    if (this.i++ % 7 == 0) {
                        this.i = 1;
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Task:{} has been reject because of threadPool exhausted! pool:{}, active:{}, queue:{}, taskcnt: {}", r, executor.getPoolSize(), executor.getActiveCount(), executor.getQueue().size(), executor.getTaskCount());
                        }
                    }
                    throw new RejectedExecutionException(LogCodes.getLog("020080002"));
                }
            };
            asyncThreadPool = ThreadPoolUtils.newCachedThreadPool(coresize, maxsize, keepAliveTime, queue, threadFactory, handler);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return asyncThreadPool;
        }
    }
}

