/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.ConnectionHolder;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.common.struct.ListDifference;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.struct.ScheduledService;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.AsyncRuntime;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ConsumerStateListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.ClientTransportFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Extension(value="all")
public class AllConnectConnectionHolder
extends ConnectionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllConnectConnectionHolder.class);
    protected ConsumerConfig consumerConfig;
    protected boolean connectionValidate = RpcConfigs.getBooleanValue("connection.validate.sleep");
    protected boolean createConnWhenAbsent = RpcConfigs.getBooleanValue("consumer.connect.create.when.absent");
    protected ConcurrentMap<ProviderInfo, ClientTransport> uninitializedConnections = new ConcurrentHashMap<ProviderInfo, ClientTransport>();
    protected ConcurrentMap<ProviderInfo, ClientTransport> aliveConnections = new ConcurrentHashMap<ProviderInfo, ClientTransport>();
    protected ConcurrentMap<ProviderInfo, ClientTransport> subHealthConnections = new ConcurrentHashMap<ProviderInfo, ClientTransport>();
    protected ConcurrentMap<ProviderInfo, ClientTransport> retryConnections = new ConcurrentHashMap<ProviderInfo, ClientTransport>();
    protected Set<ProviderInfo> lastAddresses = new HashSet<ProviderInfo>();
    private Lock providerLock = new ReentrantLock();
    private volatile ScheduledService reconThread;
    private AtomicInteger reconnectFlag = new AtomicInteger();

    protected AllConnectConnectionHolder(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
        this.consumerConfig = consumerBootstrap.getConsumerConfig();
    }

    public ConcurrentMap<ProviderInfo, ClientTransport> getRetryConnections() {
        return this.retryConnections;
    }

    protected void addAlive(ProviderInfo providerInfo, ClientTransport transport) {
        if (this.checkState(providerInfo, transport)) {
            this.aliveConnections.put(providerInfo, transport);
        }
    }

    protected void addRetry(ProviderInfo providerInfo, ClientTransport transport) {
        this.retryConnections.put(providerInfo, transport);
    }

    protected void aliveToRetry(ProviderInfo providerInfo, ClientTransport transport) {
        this.providerLock.lock();
        try {
            if (this.aliveConnections.remove(providerInfo) != null) {
                this.retryConnections.put(providerInfo, transport);
            }
        }
        finally {
            this.providerLock.unlock();
        }
    }

    protected void retryToAlive(ProviderInfo providerInfo, ClientTransport transport) {
        this.providerLock.lock();
        try {
            if (this.retryConnections.remove(providerInfo) != null && this.checkState(providerInfo, transport)) {
                this.aliveConnections.put(providerInfo, transport);
            }
        }
        finally {
            this.providerLock.unlock();
        }
    }

    protected boolean checkState(ProviderInfo providerInfo, ClientTransport clientTransport) {
        return true;
    }

    protected void aliveToSubHealth(ProviderInfo providerInfo, ClientTransport transport) {
        this.providerLock.lock();
        try {
            if (this.aliveConnections.remove(providerInfo) != null) {
                this.subHealthConnections.put(providerInfo, transport);
            }
        }
        finally {
            this.providerLock.unlock();
        }
    }

    protected void subHealthToAlive(ProviderInfo providerInfo, ClientTransport transport) {
        this.providerLock.lock();
        try {
            if (this.subHealthConnections.remove(providerInfo) != null && this.checkState(providerInfo, transport)) {
                this.aliveConnections.put(providerInfo, transport);
            }
        }
        finally {
            this.providerLock.unlock();
        }
    }

    protected void subHealthToRetry(ProviderInfo providerInfo, ClientTransport transport) {
        this.providerLock.lock();
        try {
            if (this.subHealthConnections.remove(providerInfo) != null) {
                this.retryConnections.put(providerInfo, transport);
            }
        }
        finally {
            this.providerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientTransport remove(ProviderInfo providerInfo) {
        this.providerLock.lock();
        try {
            ClientTransport transport = (ClientTransport)this.uninitializedConnections.remove(providerInfo);
            if (transport == null && (transport = (ClientTransport)this.aliveConnections.remove(providerInfo)) == null && (transport = (ClientTransport)this.subHealthConnections.remove(providerInfo)) == null) {
                transport = (ClientTransport)this.retryConnections.remove(providerInfo);
            }
            ClientTransport clientTransport = transport;
            return clientTransport;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    public void notifyStateChangeToUnavailable() {
        final List<ConsumerStateListener> onAvailable = this.consumerConfig.getOnAvailable();
        if (onAvailable != null) {
            AsyncRuntime.getAsyncThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Object proxyIns = AllConnectConnectionHolder.this.consumerConfig.getConsumerBootstrap().getProxyIns();
                    for (ConsumerStateListener listener : onAvailable) {
                        try {
                            listener.onUnavailable(proxyIns);
                        }
                        catch (Exception e) {
                            LOGGER.errorWithApp(AllConnectConnectionHolder.this.consumerConfig.getAppName(), LogCodes.getLog("020020011", proxyIns.getClass().getName()));
                        }
                    }
                }
            });
        }
    }

    public void notifyStateChangeToAvailable() {
        final List<ConsumerStateListener> onAvailable = this.consumerConfig.getOnAvailable();
        if (onAvailable != null) {
            AsyncRuntime.getAsyncThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Object proxyIns = AllConnectConnectionHolder.this.consumerConfig.getConsumerBootstrap().getProxyIns();
                    for (ConsumerStateListener listener : onAvailable) {
                        try {
                            listener.onAvailable(proxyIns);
                        }
                        catch (Exception e) {
                            LOGGER.warnWithApp(AllConnectConnectionHolder.this.consumerConfig.getAppName(), LogCodes.getLog("020020012", proxyIns.getClass().getName()));
                        }
                    }
                }
            });
        }
    }

    @Override
    public void init() {
        if (this.reconThread == null) {
            this.startReconnectThread();
        }
    }

    @Override
    public void addProvider(ProviderGroup providerGroup) {
        if (!ProviderHelper.isEmpty(providerGroup)) {
            this.addNode(providerGroup.getProviderInfos());
        }
    }

    @Override
    public void removeProvider(ProviderGroup providerGroup) {
        if (!ProviderHelper.isEmpty(providerGroup)) {
            this.removeNode(providerGroup.getProviderInfos());
        }
    }

    @Override
    public void updateProviders(ProviderGroup providerGroup) {
        block8: {
            try {
                if (ProviderHelper.isEmpty(providerGroup)) {
                    if (CommonUtils.isNotEmpty(this.currentProviderList())) {
                        if (LOGGER.isInfoEnabled(this.consumerConfig.getAppName())) {
                            LOGGER.infoWithApp(this.consumerConfig.getAppName(), "Clear all providers, may be this consumer has been add to blacklist");
                        }
                        this.closeAllClientTransports(null);
                    }
                } else {
                    Collection nowall = this.currentProviderList();
                    List<ProviderInfo> oldAllP = providerGroup.getProviderInfos();
                    ArrayList nowAllP = new ArrayList(nowall);
                    ListDifference<ProviderInfo> diff = new ListDifference<ProviderInfo>(oldAllP, nowAllP);
                    List<ProviderInfo> needAdd = diff.getOnlyOnLeft();
                    List<ProviderInfo> needDelete = diff.getOnlyOnRight();
                    if (!needAdd.isEmpty()) {
                        this.addNode(needAdd);
                    }
                    if (!needDelete.isEmpty()) {
                        this.removeNode(needDelete);
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled(this.consumerConfig.getAppName())) break block8;
                LOGGER.errorWithApp(this.consumerConfig.getAppName(), LogCodes.getLog("020020013", this.consumerConfig.getInterfaceId(), providerGroup), e);
            }
        }
    }

    @Override
    public void updateAllProviders(List<ProviderGroup> providerGroups) {
        ArrayList<ProviderInfo> mergePs = new ArrayList<ProviderInfo>();
        if (CommonUtils.isNotEmpty(providerGroups)) {
            for (ProviderGroup providerGroup : providerGroups) {
                if (ProviderHelper.isEmpty(providerGroup)) continue;
                mergePs.addAll(providerGroup.getProviderInfos());
            }
        }
        this.updateProviders(new ProviderGroup().addAll(mergePs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(List<ProviderInfo> providerInfoList) {
        this.lastAddresses.addAll(providerInfoList);
        String interfaceId = this.consumerConfig.getInterfaceId();
        int providerSize = providerInfoList.size();
        String appName = this.consumerConfig.getAppName();
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, "Add provider of {}, size is : {}", interfaceId, providerSize);
        }
        if (providerSize > 0) {
            int threads = Math.min(10, providerSize);
            CountDownLatch latch = new CountDownLatch(providerSize);
            ThreadPoolExecutor initPool = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(providerInfoList.size()), new NamedThreadFactory("CLI-CONN-" + interfaceId, true));
            int connectTimeout = this.consumerConfig.getConnectTimeout();
            for (ProviderInfo providerInfo : providerInfoList) {
                this.initClientRunnable(initPool, latch, providerInfo);
            }
            try {
                int totalTimeout = (providerSize % threads == 0 ? providerSize / threads : providerSize / threads + 1) * connectTimeout + 500;
                latch.await(totalTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.errorWithApp(appName, LogCodes.getLog("020020013", this.consumerConfig.getInterfaceId(), ""), e);
            }
            finally {
                initPool.shutdown();
            }
        }
    }

    protected void initClientRunnable(ThreadPoolExecutor initPool, final CountDownLatch latch, final ProviderInfo providerInfo) {
        final ClientTransportConfig config = this.providerToClientConfig(providerInfo);
        initPool.execute(new Runnable(){

            @Override
            public void run() {
                ClientTransport transport = ClientTransportFactory.getClientTransport(config);
                if (AllConnectConnectionHolder.this.consumerConfig.isLazy()) {
                    AllConnectConnectionHolder.this.uninitializedConnections.put(providerInfo, transport);
                    latch.countDown();
                } else {
                    try {
                        AllConnectConnectionHolder.this.initClientTransport(AllConnectConnectionHolder.this.consumerConfig.getInterfaceId(), providerInfo, transport);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }
        });
    }

    protected void initClientTransport(String interfaceId, ProviderInfo providerInfo, ClientTransport transport) {
        try {
            transport.connect();
            if (this.doubleCheck(interfaceId, providerInfo, transport)) {
                this.printSuccess(interfaceId, providerInfo, transport);
                this.addAlive(providerInfo, transport);
            } else {
                this.printFailure(interfaceId, providerInfo, transport);
                this.addRetry(providerInfo, transport);
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled(this.consumerConfig.getAppName())) {
                LOGGER.debugWithApp(this.consumerConfig.getAppName(), "Failed to connect " + providerInfo, e);
            }
            this.printDead(interfaceId, providerInfo, transport, e);
            this.addRetry(providerInfo, transport);
        }
    }

    public void removeNode(List<ProviderInfo> providerInfos) {
        this.lastAddresses.removeAll(providerInfos);
        String interfaceId = this.consumerConfig.getInterfaceId();
        String appName = this.consumerConfig.getAppName();
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, "Remove provider of {}, size is : {}", interfaceId, providerInfos.size());
        }
        for (ProviderInfo providerInfo : providerInfos) {
            try {
                ClientTransport transport = this.remove(providerInfo);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, "Remove provider of {}: {} from list success !", interfaceId, providerInfo);
                }
                if (transport == null) continue;
                ClientTransportFactory.releaseTransport(transport, this.consumerConfig.getDisconnectTimeout());
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, LogCodes.getLog("020020014", this.consumerConfig.getInterfaceId(), providerInfo), e);
            }
        }
    }

    @Override
    public ConcurrentMap<ProviderInfo, ClientTransport> getAvailableConnections() {
        return this.aliveConnections.isEmpty() ? this.subHealthConnections : this.aliveConnections;
    }

    @Override
    public List<ProviderInfo> getAvailableProviders() {
        ConcurrentMap<ProviderInfo, ClientTransport> map = this.aliveConnections.isEmpty() ? this.subHealthConnections : this.aliveConnections;
        return new ArrayList<ProviderInfo>(map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientTransport getAvailableClientTransport(ProviderInfo providerInfo) {
        ClientTransport transport = (ClientTransport)this.aliveConnections.get(providerInfo);
        if (transport != null) {
            return transport;
        }
        transport = (ClientTransport)this.subHealthConnections.get(providerInfo);
        if (transport != null) {
            return transport;
        }
        transport = (ClientTransport)this.uninitializedConnections.get(providerInfo);
        if (transport != null) {
            AllConnectConnectionHolder allConnectConnectionHolder = this;
            synchronized (allConnectConnectionHolder) {
                transport = (ClientTransport)this.uninitializedConnections.get(providerInfo);
                if (transport != null) {
                    this.initClientTransport(this.consumerConfig.getInterfaceId(), providerInfo, transport);
                    this.uninitializedConnections.remove(providerInfo);
                }
                return this.getAvailableClientTransport(providerInfo);
            }
        }
        if (this.createConnWhenAbsent) {
            String targetIP;
            RpcInternalContext context = RpcInternalContext.peekContext();
            String string = targetIP = context == null ? null : (String)context.getAttachment(".pinpoint");
            if (StringUtils.isNotBlank(targetIP)) {
                ClientTransportConfig transportConfig = this.providerToClientConfig(providerInfo);
                transport = ClientTransportFactory.getClientTransport(transportConfig);
                this.initClientTransport(this.consumerConfig.getInterfaceId(), providerInfo, transport);
            }
        }
        return transport;
    }

    @Override
    public boolean isAvailableEmpty() {
        return this.aliveConnections.isEmpty() && this.subHealthConnections.isEmpty();
    }

    protected ClientTransportConfig providerToClientConfig(ProviderInfo providerInfo) {
        return new ClientTransportConfig().setConsumerConfig(this.consumerConfig).setProviderInfo(providerInfo).setContainer(this.consumerConfig.getProtocol()).setConnectTimeout(this.consumerConfig.getConnectTimeout()).setInvokeTimeout(this.consumerConfig.getTimeout()).setDisconnectTimeout(this.consumerConfig.getDisconnectTimeout()).setConnectionNum(this.consumerConfig.getConnectionNum()).setChannelListeners(this.consumerConfig.getOnConnect());
    }

    public Set<ProviderInfo> currentProviderList() {
        this.providerLock.lock();
        try {
            ConcurrentHashSet<ProviderInfo> providerInfos = new ConcurrentHashSet<ProviderInfo>();
            providerInfos.addAll(this.lastAddresses);
            ConcurrentHashSet<ProviderInfo> concurrentHashSet = providerInfos;
            return concurrentHashSet;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnavailable(ProviderInfo providerInfo, ClientTransport transport) {
        this.providerLock.lock();
        try {
            boolean first = this.isAvailableEmpty();
            if (this.aliveConnections.remove(providerInfo) != null) {
                this.retryConnections.put(providerInfo, transport);
                if (!first && this.isAvailableEmpty()) {
                    this.notifyStateChangeToUnavailable();
                }
            }
        }
        finally {
            this.providerLock.unlock();
        }
    }

    @Override
    public void destroy() {
        this.destroy(null);
    }

    @Override
    public void destroy(Destroyable.DestroyHook destroyHook) {
        this.shutdownReconnectThread();
        this.closeAllClientTransports(destroyHook);
    }

    protected Map<ProviderInfo, ClientTransport> clearProviders() {
        this.providerLock.lock();
        try {
            HashMap<ProviderInfo, ClientTransport> all = new HashMap<ProviderInfo, ClientTransport>(this.aliveConnections);
            all.putAll(this.subHealthConnections);
            all.putAll(this.retryConnections);
            all.putAll(this.uninitializedConnections);
            this.subHealthConnections.clear();
            this.aliveConnections.clear();
            this.retryConnections.clear();
            this.uninitializedConnections.clear();
            this.lastAddresses.clear();
            HashMap<ProviderInfo, ClientTransport> hashMap = all;
            return hashMap;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllClientTransports(Destroyable.DestroyHook destroyHook) {
        int providerSize;
        Map<ProviderInfo, ClientTransport> all;
        block10: {
            all = this.clearProviders();
            if (destroyHook != null) {
                try {
                    destroyHook.preDestroy();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) break block10;
                    LOGGER.warnWithApp(this.consumerConfig.getAppName(), e.getMessage(), e);
                }
            }
        }
        if ((providerSize = all.size()) > 0) {
            int timeout = this.consumerConfig.getDisconnectTimeout();
            int threads = Math.min(10, providerSize);
            final CountDownLatch latch = new CountDownLatch(providerSize);
            ThreadPoolExecutor closePool = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(providerSize), new NamedThreadFactory("CLI-DISCONN-" + this.consumerConfig.getInterfaceId(), true));
            for (Map.Entry<ProviderInfo, ClientTransport> entry : all.entrySet()) {
                final ProviderInfo providerInfo = entry.getKey();
                final ClientTransport transport = entry.getValue();
                closePool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ClientTransportFactory.releaseTransport(transport, 0);
                        }
                        catch (Exception e) {
                            if (LOGGER.isWarnEnabled(AllConnectConnectionHolder.this.consumerConfig.getAppName())) {
                                LOGGER.warnWithApp(AllConnectConnectionHolder.this.consumerConfig.getAppName(), "catch exception but ignore it when close alive client : {}", providerInfo);
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                int totalTimeout = (providerSize % threads == 0 ? providerSize / threads : providerSize / threads + 1) * timeout + 500;
                latch.await(totalTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.errorWithApp(this.consumerConfig.getAppName(), "Exception when close transport", e);
            }
            finally {
                closePool.shutdown();
            }
        }
    }

    protected void printSuccess(String interfaceId, ProviderInfo providerInfo, ClientTransport transport) {
        if (LOGGER.isInfoEnabled(this.consumerConfig.getAppName())) {
            LOGGER.infoWithApp(this.consumerConfig.getAppName(), "Connect to {} provider:{} success ! The connection is " + NetUtils.connectToString(transport.remoteAddress(), transport.localAddress()), interfaceId, providerInfo);
        }
    }

    protected void printFailure(String interfaceId, ProviderInfo providerInfo, ClientTransport transport) {
        if (LOGGER.isInfoEnabled(this.consumerConfig.getAppName())) {
            LOGGER.infoWithApp(this.consumerConfig.getAppName(), "Connect to {} provider:{} failure !", interfaceId, providerInfo);
        }
    }

    protected void printDead(String interfaceId, ProviderInfo providerInfo, ClientTransport transport, Exception e) {
        Throwable cause = e.getCause();
        if (LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) {
            LOGGER.warnWithApp(this.consumerConfig.getAppName(), "Connect to {} provider:{} failure !! The exception is " + ExceptionUtils.toShortString(e, 1) + (cause != null ? ", cause by " + cause.getMessage() + "." : "."), interfaceId, providerInfo);
        }
    }

    public Map<String, Set<ProviderInfo>> currentProviderMap() {
        this.providerLock.lock();
        try {
            LinkedHashMap<String, Set<ProviderInfo>> tmp = new LinkedHashMap<String, Set<ProviderInfo>>();
            tmp.put("alive", new HashSet(this.aliveConnections.keySet()));
            tmp.put("subHealth", new HashSet(this.subHealthConnections.keySet()));
            tmp.put("retry", new HashSet(this.retryConnections.keySet()));
            tmp.put("uninitialized", new HashSet(this.uninitializedConnections.keySet()));
            tmp.put("all", new HashSet<ProviderInfo>(this.lastAddresses));
            LinkedHashMap<String, Set<ProviderInfo>> linkedHashMap = tmp;
            return linkedHashMap;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    protected boolean doubleCheck(String interfaceId, ProviderInfo providerInfo, ClientTransport transport) {
        if (transport.isAvailable()) {
            if (!this.connectionValidate) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (transport.isAvailable()) {
                return true;
            }
            if (LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) {
                LOGGER.warnWithApp(this.consumerConfig.getAppName(), "Connection has been closed after connected (in last 100ms)! Maybe connectionNum of provider has been reached limit, or your host is in the blacklist of provider {}/{}", interfaceId, transport.getConfig().getProviderInfo());
            }
            providerInfo.setDynamicAttr("reconnectCoefficient", 5);
            return false;
        }
        return false;
    }

    protected void startReconnectThread() {
        String interfaceId = this.consumerConfig.getInterfaceId();
        int reconnect = this.consumerConfig.getReconnectPeriod();
        if (reconnect > 0) {
            reconnect = Math.max(reconnect, 2000);
            this.reconThread = new ScheduledService("CLI-RC-" + interfaceId, 1, new Runnable(){

                @Override
                public void run() {
                    try {
                        AllConnectConnectionHolder.this.doReconnect();
                    }
                    catch (Throwable e) {
                        LOGGER.warnWithApp(AllConnectConnectionHolder.this.consumerConfig.getAppName(), "Exception when retry connect to provider", e);
                    }
                }
            }, reconnect, reconnect, TimeUnit.MILLISECONDS).start();
        }
    }

    private void doReconnect() {
        String interfaceId = this.consumerConfig.getInterfaceId();
        String appName = this.consumerConfig.getAppName();
        int thisTime = this.reconnectFlag.incrementAndGet();
        boolean print = thisTime % 6 == 0;
        boolean isAliveEmptyFirst = this.isAvailableEmpty();
        for (Map.Entry alive : this.aliveConnections.entrySet()) {
            ClientTransport connection = (ClientTransport)alive.getValue();
            if (connection == null || connection.isAvailable()) continue;
            this.aliveToRetry((ProviderInfo)alive.getKey(), connection);
        }
        for (Map.Entry entry : this.getRetryConnections().entrySet()) {
            ProviderInfo providerInfo = (ProviderInfo)entry.getKey();
            int providerPeriodCoefficient = CommonUtils.parseNum((Integer)providerInfo.getDynamicAttr("reconnectCoefficient"), 1);
            if (thisTime % providerPeriodCoefficient != 0) continue;
            ClientTransport transport = (ClientTransport)entry.getValue();
            if (LOGGER.isDebugEnabled(appName)) {
                LOGGER.debugWithApp(appName, "Retry connect to {} provider:{} ...", interfaceId, providerInfo);
            }
            try {
                transport.connect();
                if (!this.doubleCheck(interfaceId, providerInfo, transport)) continue;
                providerInfo.setDynamicAttr("reconnectCoefficient", 1);
                this.retryToAlive(providerInfo, transport);
            }
            catch (Exception e) {
                if (print) {
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.warnWithApp(appName, "Retry connect to {} provider:{} error ! The exception is " + e.getMessage(), interfaceId, providerInfo);
                    continue;
                }
                if (!LOGGER.isDebugEnabled(appName)) continue;
                LOGGER.debugWithApp(appName, "Retry connect to {} provider:{} error ! The exception is " + e.getMessage(), interfaceId, providerInfo);
            }
        }
        if (isAliveEmptyFirst && !this.isAvailableEmpty()) {
            this.notifyStateChangeToAvailable();
        }
    }

    protected void shutdownReconnectThread() {
        if (this.reconThread != null) {
            this.reconThread.shutdown();
            this.reconThread = null;
        }
    }
}

