/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.grpc;

import com.alipay.sofa.rpc.bootstrap.DefaultConsumerBootstrap;
import com.alipay.sofa.rpc.client.ClusterFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.MessageBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

@Extension(value="grpc")
public class GrpcConsumerBootstrap<T>
extends DefaultConsumerBootstrap<T> {
    ProxyObject proxyObject;
    private final String interfaceID;
    private final String serviceName;
    private final String blockingStubName;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcConsumerBootstrap.class);

    protected GrpcConsumerBootstrap(ConsumerConfig<T> consumerConfig) {
        super(consumerConfig);
        this.interfaceID = consumerConfig.getInterfaceId();
        String[] segments = this.interfaceID.split("\\.");
        String lastSegment = segments[segments.length - 1];
        this.serviceName = lastSegment.substring(0, lastSegment.length() - 4);
        this.blockingStubName = this.interfaceID + "$" + this.serviceName + "BlockingStub";
    }

    @Override
    public synchronized T refer() {
        AtomicInteger cnt;
        if (this.proxyObject != null) {
            return (T)this.proxyObject;
        }
        String key = this.consumerConfig.buildKey();
        String appName = this.consumerConfig.getAppName();
        this.checkParameters();
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, "Refer consumer config : {} with bean id {}", key, this.consumerConfig.getId());
        }
        if ((cnt = (AtomicInteger)REFERRED_KEYS.get(key)) == null) {
            cnt = CommonUtils.putToConcurrentMap(REFERRED_KEYS, key, new AtomicInteger(0));
        }
        int c = cnt.incrementAndGet();
        int maxProxyCount = this.consumerConfig.getRepeatedReferLimit();
        if (maxProxyCount > 0) {
            if (c > maxProxyCount) {
                cnt.decrementAndGet();
                throw new SofaRpcRuntimeException("Duplicate consumer config with key " + key + " has been referred more than " + maxProxyCount + " times! Maybe it's wrong config, please check it. Ignore this if you did that on purpose!");
            }
            if (c > 1 && LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Duplicate consumer config with key {} has been referred! Maybe it's wrong config, please check it. Ignore this if you did that on purpose!", key);
            }
        }
        try {
            int port;
            String host;
            this.cluster = ClusterFactory.getCluster(this);
            this.consumerConfig.setConfigListener(this.buildConfigListener(this));
            this.consumerConfig.setProviderInfoListener(this.buildProviderInfoListener(this));
            this.cluster.init();
            this.proxyInvoker = this.buildClientProxyInvoker(this);
            if (this.cluster.getAddressHolder().getProviderInfos("").size() != 0) {
                host = this.cluster.getAddressHolder().getProviderInfos("").get(0).getHost();
                port = this.cluster.getAddressHolder().getProviderInfos("").get(0).getPort();
            } else {
                host = "localhost";
                port = 50052;
            }
            ManagedChannel channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
            Object blockingStubIns = null;
            Method newBlockingChannel = Class.forName(this.consumerConfig.getInterfaceId()).getDeclaredMethod("newBlockingStub", Channel.class);
            newBlockingChannel.setAccessible(true);
            blockingStubIns = newBlockingChannel.invoke(null, channel);
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setSuperclass(Class.forName(this.blockingStubName));
            Class proxyClass = proxyFactory.createClass();
            try {
                this.proxyObject = (ProxyObject)proxyClass.getConstructors()[0].newInstance(channel, this.proxyIns);
                channel.shutdown();
                this.proxyObject.setHandler(new MethodHandler(){

                    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                        SofaRequest sofaRequest = MessageBuilder.buildSofaRequest(thisMethod.getDeclaringClass(), thisMethod, (Class[])thisMethod.getParameterTypes(), args);
                        SofaResponse sofaResponse = GrpcConsumerBootstrap.this.proxyInvoker.invoke(sofaRequest);
                        if (sofaResponse.isError()) {
                            throw new SofaRpcException(199, sofaResponse.getErrorMsg());
                        }
                        Object appResponse = sofaResponse.getAppResponse();
                        if (appResponse instanceof Throwable) {
                            throw (Throwable)appResponse;
                        }
                        return sofaResponse.getAppResponse();
                    }
                });
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("", e);
            }
        }
        catch (Exception e) {
            if (this.cluster != null) {
                this.cluster.destroy();
                this.cluster = null;
            }
            this.consumerConfig.setConfigListener(null);
            this.consumerConfig.setProviderInfoListener(null);
            cnt.decrementAndGet();
            if (e instanceof SofaRpcRuntimeException) {
                throw (SofaRpcRuntimeException)e;
            }
            throw new SofaRpcRuntimeException("Build consumer proxy error!", e);
        }
        if (this.consumerConfig.getOnAvailable() != null && this.cluster != null) {
            this.cluster.checkStateChange(false);
        }
        RpcRuntimeContext.cacheConsumerConfig(this);
        return (T)this.proxyObject;
    }

    @Override
    public synchronized void unRefer() {
        if (this.proxyObject == null) {
            return;
        }
        this.proxyObject = null;
    }
}

