/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.connectors.mysql.table;

import com.alibaba.ververica.cdc.connectors.mysql.table.MySQLTableSource;
import com.alibaba.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.alibaba.ververica.cdc.debezium.table.DebeziumOptions;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;

public class MySQLTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "mysql-cdc";
    private static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the MySQL database server.");
    private static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)3306).withDescription("Integer port number of the MySQL database server.");
    private static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the MySQL database to use when connecting to the MySQL database server.");
    private static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the MySQL database server.");
    private static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the MySQL server to monitor.");
    private static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the MySQL database to monitor.");
    private static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    private static final ConfigOption<Integer> SERVER_ID = ConfigOptions.key((String)"server-id").intType().noDefaultValue().withDescription("A numeric ID of this database client, which must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL database cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for MySQL CDC consumer, valid enumerations are \"initial\", \"earliest-offset\", \"latest-offset\", \"timestamp\"\nor \"specific-offset\"");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_FILE = ConfigOptions.key((String)"scan.startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Integer> SCAN_STARTUP_SPECIFIC_OFFSET_POS = ConfigOptions.key((String)"scan.startup.specific-offset.pos").intType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.startup.timestamp-millis").longType().noDefaultValue().withDescription("Optional timestamp used in case of \"timestamp\" startup mode");
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_EARLIEST = "earliest-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSET = "specific-offset";
    private static final String SCAN_STARTUP_MODE_VALUE_TIMESTAMP = "timestamp";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(HOSTNAME);
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String databaseName = (String)config.get(DATABASE_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        int port = (Integer)config.get(PORT);
        Integer serverId = config.getOptional(SERVER_ID).orElse(null);
        ZoneId serverTimeZone = ZoneId.of((String)config.get(SERVER_TIME_ZONE));
        StartupOptions startupOptions = MySQLTableSourceFactory.getStartupOptions(config);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new MySQLTableSource(physicalSchema, port, hostname, databaseName, tableName, username, password, serverTimeZone, DebeziumOptions.getDebeziumProperties(context.getCatalogTable().getOptions()), serverId, startupOptions);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(HOSTNAME);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(DATABASE_NAME);
        options.add(TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PORT);
        options.add(SERVER_TIME_ZONE);
        options.add(SERVER_ID);
        options.add(SCAN_STARTUP_MODE);
        options.add(SCAN_STARTUP_SPECIFIC_OFFSET_FILE);
        options.add(SCAN_STARTUP_SPECIFIC_OFFSET_POS);
        options.add(SCAN_STARTUP_TIMESTAMP_MILLIS);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "earliest-offset": {
                return StartupOptions.earliest();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
            case "specific-offset": {
                String offsetFile = (String)config.get(SCAN_STARTUP_SPECIFIC_OFFSET_FILE);
                int offsetPos = (Integer)config.get(SCAN_STARTUP_SPECIFIC_OFFSET_POS);
                return StartupOptions.specificOffset(offsetFile, offsetPos);
            }
            case "timestamp": {
                long millis = (Long)config.get(SCAN_STARTUP_TIMESTAMP_MILLIS);
                return StartupOptions.timestamp(millis);
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s, %s, %s, %s], but was: %s", SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_EARLIEST, SCAN_STARTUP_MODE_VALUE_LATEST, SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSET, SCAN_STARTUP_MODE_VALUE_TIMESTAMP, modeString));
    }
}

