/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.spring.context.annotation.config.EnableNacosConfig;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.aot.AotDetector;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

public class EnableNacosConfigAotProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
BeanFactoryAware {
    private Environment environment;
    private BeanFactory beanFactory;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (!AotDetector.useGeneratedArtifacts()) {
            return;
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.beanFactory;
        Map beansWithAnnotation = beanFactory.getBeansWithAnnotation(EnableNacosConfig.class);
        Object[] beans = beansWithAnnotation.values().toArray();
        if (beans.length != 0) {
            Class<?> aClass = beans[0].getClass();
            if (aClass.getAnnotation(EnableNacosConfig.class) == null) {
                aClass = aClass.getSuperclass();
            }
            AnnotationMetadata annotationMetadata = AnnotationMetadata.introspect(aClass);
            AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(EnableNacosConfig.class.getName()));
            NacosBeanUtils.registerGlobalNacosProperties(attributes, registry, (PropertyResolver)this.environment, "globalNacosProperties$config");
        }
        NacosBeanUtils.registerNacosConfigListenerExecutor(registry, this.environment);
        NacosBeanUtils.invokeNacosPropertySourcePostProcessor(this.beanFactory);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

